#ifndef MEDIAPLAYERSELECTOR_H
#define MEDIAPLAYERSELECTOR_H

#include "selectionmodels.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class MediaPlayerSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit MediaPlayerSelector(const QString &text, QWidget *parent = 0);
    void setValue(const QString &value);
    QString currentValue();

private slots:
    void onSelected();

signals:
    void valueChanged(const QString &value);

private:
    MediaPlayerModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // MEDIAPLAYERSELECTOR_H
