#ifndef DAILYMOTIONVIDEOLISTMODEL_H
#define DAILYMOTIONVIDEOLISTMODEL_H

#include "abstractvideolistmodel.h"
#include "session.h"

class DailymotionVideoListModel : public AbstractVideoListModel
{
    Q_OBJECT

public:
    explicit DailymotionVideoListModel(Session *session, QObject *parent = 0);
    inline QString feed() const { return m_feed; }
    void setFeed(const QString &afeed);
    inline QString playlistId() const { return m_playlistId; }
    inline QString groupId() const { return m_groupId; }
    inline bool favourites() const { return m_favourites; }
    inline bool uploads() const { return m_uploads; }
    inline bool loading() const { return m_loading; }

public slots:
    void reset();
    void getVideos(const QString &afeed = QString());
    void getMoreVideos();
    void getRelatedVideos(const QString &id);
    void getPlaylistVideos(const QString &id);
    void getGroupVideos(const QString &id);
    void search(const QString &query = QString(),
                Queries::QueryOrder order = Queries::Relevance,
                const QString &language = QString());

private slots:
    void addVideos();
    void onAddedToFeed(QSharedPointer<VideoItem> video);
    void onAddedToPlaylist(const QString &id, QSharedPointer<VideoItem> video);
    void onDeletedFromFeed(QSharedPointer<VideoItem> video);
    void onDeletedFromPlaylist(const QString &id, QSharedPointer<VideoItem> video);
    inline void onError() { setError(true); setLoading(false); }

private:
    inline void setPlaylistId(const QString &id) { m_playlistId = id; }
    inline void setGroupId(const QString &id) { m_groupId = id; }
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline Queries::QueryOrder order() const { return m_order; }
    inline void setOrder(Queries::QueryOrder order) { m_order = order; }
    inline QString languageFilter() const { return m_language; }
    inline void setLanguageFilter(const QString &language) { m_language = language; }
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(); }
    inline void setFavourites(bool favourites) { m_favourites = favourites; }
    inline void setUploads(bool uploads) { m_uploads = uploads; }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged();

private:
    Session *m_session;
    QString m_feed;
    QString m_playlistId;
    QString m_groupId;
    QString m_query;
    Queries::QueryOrder m_order;
    QString m_language;
    bool m_favourites;
    bool m_uploads;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // DAILYMOTIONVIDEOLISTMODEL_H
