#include "dailymotionmychannelwindow.h"
#include <QMenuBar>

DailymotionMyChannelWindow::DailymotionMyChannelWindow(Session *session, QWidget *parent) :
    StackedWindow(session, parent),
    m_menu(menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_favouritesAction(new QAction("Fav", this)),
    m_playlistsAction(new QAction("Play", this)),
    m_groupsAction(new QAction("Gro", this)),
    m_subscriptionsAction(new QAction("Subs", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new DailymotionProfileTab(m_session, "me", m_tabWidget)),
    m_uploadsTab(0),
    m_favouritesTab(0),
    m_playlistsTab(0),
    m_groupsTab(0),
    m_subscriptionsTab(0)
{
    setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_favouritesAction->setCheckable(true);
    m_favouritesAction->setActionGroup(m_actionGroup);

    m_playlistsAction->setCheckable(true);
    m_playlistsAction->setActionGroup(m_actionGroup);

    m_groupsAction->setCheckable(true);
    m_groupsAction->setActionGroup(m_actionGroup);

    m_subscriptionsAction->setCheckable(true);
    m_subscriptionsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_favouritesAction);
    m_menu->addAction(m_playlistsAction);
    m_menu->addAction(m_groupsAction);
    m_menu->addAction(m_subscriptionsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    connect(m_favouritesAction, SIGNAL(triggered()), this, SLOT(showFavourites()));
    connect(m_playlistsAction, SIGNAL(triggered()), this, SLOT(showPlaylists()));
    connect(m_groupsAction, SIGNAL(triggered()), this, SLOT(showGroups()));
    connect(m_subscriptionsAction, SIGNAL(triggered()), this, SLOT(showSubscriptions()));

    showProfile();
    onOrientationChanged();
}

void DailymotionMyChannelWindow::clearMenuActions() {
    QList<QAction*> actions = menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        menuBar()->removeAction(actions.at(i));
    }
}

void DailymotionMyChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    setWindowTitle(tr("Profile"));
    clearMenuActions();
}

void DailymotionMyChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new DailymotionVideoListTab(m_session, this);
        m_uploadsTab->setVideoFeed(DAILYMOTION_UPLOADS_FEED);
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    setWindowTitle(tr("Uploads"));
    clearMenuActions();
    menuBar()->addActions(m_uploadsTab->actions());
}

void DailymotionMyChannelWindow::showFavourites() {
    if (!m_favouritesTab) {
        m_favouritesTab = new DailymotionVideoListTab(m_session, this);
        m_favouritesTab->setVideoFeed(DAILYMOTION_FAVOURITES_FEED);
        m_tabWidget->addWidget(m_favouritesTab);
    }

    m_tabWidget->setCurrentWidget(m_favouritesTab);
    setWindowTitle(tr("Favourites"));
    clearMenuActions();
    menuBar()->addActions(m_favouritesTab->actions());
}

void DailymotionMyChannelWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new DailymotionUserPlaylistListTab(m_session, this);
        m_tabWidget->addWidget(m_playlistsTab);
    }

    m_tabWidget->setCurrentWidget(m_playlistsTab);
    setWindowTitle(tr("Playlists"));
    clearMenuActions();
    menuBar()->addActions(m_playlistsTab->actions());
}

void DailymotionMyChannelWindow::showGroups() {
    if (!m_groupsTab) {
        m_groupsTab = new DailymotionUserGroupListTab(m_session, this);
        m_tabWidget->addWidget(m_groupsTab);
    }

    m_tabWidget->setCurrentWidget(m_groupsTab);
    setWindowTitle(tr("Groups"));
    clearMenuActions();
}

void DailymotionMyChannelWindow::showSubscriptions() {
    if (!m_subscriptionsTab) {
        m_subscriptionsTab = new DailymotionSubscriptionsTab(m_session, this);
        m_tabWidget->addWidget(m_subscriptionsTab);
    }

    m_tabWidget->setCurrentWidget(m_subscriptionsTab);
    setWindowTitle(tr("Subscriptions"));
    clearMenuActions();
    menuBar()->addActions(m_subscriptionsTab->actions());
}
