#ifndef SOCIALVIDEOLISTWINDOW_H
#define SOCIALVIDEOLISTWINDOW_H

#include "stackedwindow.h"
#include "socialvideolistmodel.h"
#include "listview.h"
#include <QAction>
#include <QLabel>

class SocialVideoListWindow : public StackedWindow
{
    Q_OBJECT
public:
    explicit SocialVideoListWindow(Session *session, QWidget *parent);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onLoadingChanged();
    void refresh();
    void addVideoDownloads();
    void addAudioDownloads();
    void queueVideos();
    void onItemClicked(const QModelIndex &index);
    void playVideo(const QModelIndex &index);
    void showVideoInfo(QSharedPointer<VideoItem> video);

private:
    ListView *m_listView;
    SocialVideoListModel *m_model;
    QAction *m_refreshAction;
    QAction *m_addToQueueAction;
    QAction *m_videoDownloadAction;
    QAction *m_audioDownloadAction;
    QLabel *m_noResultsLabel;
};

#endif // SOCIALVIDEOLISTWINDOW_H
