#include "sharetofacebookdialog.h"
#include <QLabel>

ShareToFacebookDialog::ShareToFacebookDialog(Session *session, QSharedPointer<VideoItem> video, QWidget *parent) :
    AbstractDialog(parent),
    m_session(session),
    m_video(video),
    m_titleEdit(new QLineEdit(m_video.data()->title(), this)),
    m_descriptionEdit(new QTextEdit(m_video.data()->description(), this)),
    m_messageEdit(new QTextEdit(this)),
    m_scrollArea(new QScrollArea(this)),
    m_buttonBox(new QDialogButtonBox(Qt::Vertical, this)),
    m_doneButton(m_buttonBox->addButton(tr("Done"), QDialogButtonBox::AcceptRole)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Share to facebook"));

    QLabel *titleLabel = new QLabel(tr("Title"), this);
    QLabel *descriptionLabel = new QLabel(tr("Description"), this);
    QLabel *messageLabel = new QLabel(tr("Message"), this);
    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(titleLabel);
    vbox->addWidget(m_titleEdit);
    vbox->addWidget(descriptionLabel);
    vbox->addWidget(m_descriptionEdit);
    vbox->addWidget(messageLabel);
    vbox->addWidget(m_messageEdit);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);
    m_scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(shareVideo()));

    onOrientationChanged();
}

void ShareToFacebookDialog::setLandscapeLayout() {
    setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void ShareToFacebookDialog::setPortraitLayout() {
    setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void ShareToFacebookDialog::shareVideo() {
    VideoShare share;
    share.setTitle(m_titleEdit->text());
    share.setDescription(m_descriptionEdit->toPlainText());
    share.setMessage(m_messageEdit->toPlainText());
    share.setVideoId(m_video.data()->videoId());
    share.setVideoUrl(m_video.data()->url().toString());
    share.setThumbnailUrl(m_video.data()->largeThumbnailUrl().toString());
    share.setEmbedUrl(m_video.data()->service() == Services::YouTube
                      ? QString("http://www.youtube.com/e/%1").arg(share.videoId())
                      : QString("http://www.dailymotion.com/swf/video/%1").arg(share.videoId()));

    m_session->sharing()->postToFacebook(share);
    accept();
}
