#ifndef SETTINGS_H
#define SETTINGS_H

#include "enums.h"
#include "transferitem.h"
#include <QSettings>
#include <QStringList>
#include <QSet>

class Settings : public QSettings
{
    Q_OBJECT

public:
    explicit Settings(QObject *parent = 0);
    ~Settings();
    inline bool enableYouTube1080Playback() const { return m_youtubePlaybackSet.contains(37); }
    inline bool enableYouTube720Playback() const { return m_youtubePlaybackSet.contains(22); }
    inline bool enableYouTube480Playback() const { return m_youtubePlaybackSet.contains(35); }
    inline bool enableYouTube360Playback() const { return m_youtubePlaybackSet.contains(34); }
    inline bool enableYouTube1080Download() const { return m_youtubeDownloadSet.contains(37); }
    inline bool enableYouTube720Download() const { return m_youtubeDownloadSet.contains(22); }
    inline bool enableYouTube480Download() const { return m_youtubeDownloadSet.contains(35); }
    inline bool enableYouTube360Download() const { return m_youtubeDownloadSet.contains(34); }
    inline bool enableDailymotion720Playback() const { return m_dailymotionPlaybackSet.contains("hd720URL"); }
    inline bool enableDailymotion480Playback() const { return m_dailymotionPlaybackSet.contains("hqURL"); }
    inline bool enableDailymotion720Download() const { return m_dailymotionDownloadSet.contains("hd720URL"); }
    inline bool enableDailymotion480Download() const { return m_dailymotionDownloadSet.contains("hqURL"); }
    inline bool enableVimeo720Playback() const { return m_vimeoPlaybackSet.contains("hd"); }
    inline bool enableVimeo360Playback() const { return m_vimeoPlaybackSet.contains("sd"); }
    inline bool enableVimeo720Download() const { return m_vimeoDownloadSet.contains("hd"); }
    inline bool enableVimeo360Download() const { return m_vimeoDownloadSet.contains("sd"); }
    inline TransferItem::Status defaultTransferStatus() const { return m_transferStatus; }
    inline QString downloadPath() const { return m_path; }
    inline bool safeSearch() { return m_safeSearch; }
    inline Services::VideoService searchSite() const { return showSearchSite() ? m_searchSite : Services::YouTube; }
    inline bool showSearchSite() const { return m_showSearchSite; }
    inline Queries::QueryOrder searchOrder() const { return showSearchOrder() ? m_searchOrder : Queries::Relevance; }
    inline bool showSearchOrder() const { return m_showSearchOrder; }
    inline Queries::TimeFilter searchTime() const { return showSearchTime() ? m_searchTime : Queries::AllTime; }
    inline bool showSearchTime() const { return m_showSearchTime; }
    inline Queries::DurationFilter searchDuration() const { return showSearchDuration() ? m_searchDuration : Queries::Any; }
    inline bool showSearchDuration() const { return m_showSearchDuration; }
    inline Queries::QueryType searchType() const { return showSearchType() ? m_searchType : Queries::Videos; }
    inline bool showSearchType() const { return m_showSearchType; }
    inline QString languageFilter() const { return m_languageFilter; }
    inline bool showSearchLanguage() const { return m_showSearchLanguage; }
    inline QString language() const { return m_language; }
    inline QString uploadAttribute() const { return m_attribute; }
    inline QString mediaPlayer() const { return m_mediaplayer; }
    inline QString mediaPlayerCommand() const { return m_command; }
    inline bool xtubeEnabled() const { return m_xtubeEnabled; }
    inline ScreenOrientation::Orientation screenOrientation() const { return m_orientation; }

public slots:
    void saveSettings();
    void restoreSettings();
    void setEnableYouTube1080Playback(bool enable);
    void setEnableYouTube720Playback(bool enable);
    void setEnableYouTube480Playback(bool enable);
    void setEnableYouTube360Playback(bool enable);
    void setEnableYouTube1080Download(bool enable);
    void setEnableYouTube720Download(bool enable);
    void setEnableYouTube480Download(bool enable);
    void setEnableYouTube360Download(bool enable);
    void setEnableDailymotion720Playback(bool enable);
    void setEnableDailymotion480Playback(bool enable);
    void setEnableDailymotion720Download(bool enable);
    void setEnableDailymotion480Download(bool enable);
    void setEnableVimeo720Playback(bool enable);
    void setEnableVimeo360Playback(bool enable);
    void setEnableVimeo720Download(bool enable);
    void setEnableVimeo360Download(bool enable);
    void setDefaultTransferStatus(TransferItem::Status status);
    void setDownloadPath(const QString &path);
    void setSafeSearch(bool safe);
    void setSearchSite(Services::VideoService site);
    void setShowSearchSite(bool show);
    void setSearchOrder(Queries::QueryOrder order);
    void setShowSearchOrder(bool show);
    void setSearchTime(Queries::TimeFilter time);
    void setShowSearchTime(bool show);
    void setSearchDuration(Queries::DurationFilter duration);
    void setShowSearchDuration(bool show);
    void setSearchType(Queries::QueryType type);
    void setShowSearchType(bool show);
    void setLanguageFilter(const QString &language);
    void setShowSearchLanguage(bool show);
    void setLanguage(const QString &lang);
    void setUploadAttribute(const QString &attribute);
    void setMediaPlayer(const QString &player);
    void setMediaPlayerCommand(const QString &command);
    void setScreenOrientation(ScreenOrientation::Orientation orientation);

private:
    void setYouTubePlaybackQualitySet(const QVariantList &qualityList);
    void setYouTubeDownloadQualitySet(const QVariantList &qualityList);
    void setDailymotionPlaybackQualitySet(const QVariantList &qualityList);
    void setDailymotionDownloadQualitySet(const QVariantList &qualityList);
    void setVimeoPlaybackQualitySet(const QVariantList &qualityList);
    void setVimeoDownloadQualitySet(const QVariantList &qualityList);
    QVariantList toVariantList(const QSet<int> &set);
    QVariantList toVariantList(const QSet<QByteArray> &set);
    void setXtubeEnabled(bool enabled);

signals:
    void youtubePlaybackQualityChanged(const QSet<int> &qualitySet);
    void youtubeDownloadQualityChanged(const QSet<int> &qualitySet);
    void dailymotionPlaybackQualityChanged(const QSet<QByteArray> &qualitySet);
    void dailymotionDownloadQualityChanged(const QSet<QByteArray> &qualitySet);
    void vimeoPlaybackQualityChanged(const QSet<QByteArray> &qualitySet);
    void vimeoDownloadQualityChanged(const QSet<QByteArray> &qualitySet);
    void defaultTransferStatusChanged(TransferItem::Status status);
    void downloadPathChanged(const QString &path);
    void safeSearchChanged(bool safe);
    void searchSiteChanged(Services::VideoService service);
    void searchOrderChanged(Queries::QueryOrder order);
    void searchTimeChanged(Queries::TimeFilter time);
    void searchDurationChanged(Queries::DurationFilter duration);
    void searchTypeChanged(Queries::QueryType type);
    void languageFilterChanged(const QString &language);
    void alert(const QString &message);
    void uploadAttributeChanged();
    void mediaPlayerChanged(const QString &player);
    void mediaPlayerCommandChanged(const QString &command);
    void screenOrientationChanged(ScreenOrientation::Orientation orientation);

private:
    QSet<int> m_youtubePlaybackSet;
    QSet<int> m_youtubeDownloadSet;
    QSet<QByteArray> m_dailymotionPlaybackSet;
    QSet<QByteArray> m_dailymotionDownloadSet;
    QSet<QByteArray> m_vimeoPlaybackSet;
    QSet<QByteArray> m_vimeoDownloadSet;
    TransferItem::Status m_transferStatus;
    QString m_path;
    bool m_safeSearch;
    Services::VideoService m_searchSite;
    bool m_showSearchSite;
    Queries::QueryOrder m_searchOrder;
    bool m_showSearchOrder;
    Queries::TimeFilter m_searchTime;
    bool m_showSearchTime;
    Queries::DurationFilter m_searchDuration;
    bool m_showSearchDuration;
    Queries::QueryType m_searchType;
    bool m_showSearchType;
    QString m_languageFilter;
    bool m_showSearchLanguage;
    QString m_language;
    QString m_attribute;
    QString m_mediaplayer;
    QString m_command;
    bool m_xtubeEnabled;
    ScreenOrientation::Orientation m_orientation;
};

#endif // SETTINGS_H
