#include "dailymotionuserlistmodel.h"
#include "feedurls.h"
#include "json.h"
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>

using namespace QtJson;

DailymotionUserListModel::DailymotionUserListModel(Session *session, QObject *parent) :
    AbstractUserListModel(session->newThumbnailCache(), parent),
    m_session(session),
    m_moreResults(true),
    m_error(false),
    m_offset(1)
{
}

void DailymotionUserListModel::setFeed(const QString &afeed) {
    m_feed = afeed + "&fields=" + DAILYMOTION_USER_FIELDS;
}

void DailymotionUserListModel::getUsers(const QString &afeed) {
    if (!afeed.isEmpty()) {
        setFeed(afeed);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->dailymotion()->createReply(feed(), offset());
    connect(reply, SIGNAL(finished()), this, SLOT(addUsers()));
}

void DailymotionUserListModel::search(const QString &aquery) {
    if (!aquery.isEmpty()) {
        setQuery(aquery);
    }

    setLoading(true);
    QNetworkReply *reply = m_session->dailymotion()->createSearchReply(Queries::Users, query(), offset());
    connect(reply, SIGNAL(finished()), this, SLOT(addUsers()));
}

void DailymotionUserListModel::addUsers() {
    QNetworkReply *reply = qobject_cast<QNetworkReply*>(sender());

    if (!reply) {
        setLoading(false);
        setError(true);
        return;
    }

    int statusCode = reply->attribute(QNetworkRequest::HttpStatusCodeAttribute).toInt();

    if (statusCode == 401) {
        connect(m_session->dailymotion(), SIGNAL(accessTokenRefreshed(QString,QString)), this, SLOT(getUsers()));
        connect(m_session->dailymotion(), SIGNAL(refreshError()), this, SLOT(onError()));
        m_session->dailymotion()->refreshAccessToken();
    }
    else {
        QString response(reply->readAll());
        bool ok;
        QVariantMap res = Json::parse(response, ok).toMap();

        if (!ok) {
            setLoading(false);
            setError(true);
        }
        else {
            QVariantList entries = res.value("list").toList();

            for (int i = 0; i < entries.size(); i++) {
                appendUser(QSharedPointer<UserItem>(new UserItem(entries.at(i).toMap())));
            }

            setLoading(false);
            setMoreResults(res.value("has_more").toBool());
            setOffset(res.value("page").toInt() + 1);
        }

        disconnect(m_session->dailymotion(), SIGNAL(accessTokenRefreshed(QString,QString)), this, SLOT(getUsers()));
        disconnect(m_session->dailymotion(), SIGNAL(refreshError()), this, SLOT(onError()));
    }

    reply->deleteLater();
}

void DailymotionUserListModel::getMoreUsers() {
    if ((moreResults()) && (!loading())) {
        if (!query().isEmpty()) {
            search();
        }
        else {
            getUsers();
        }
    }
}
