#include "dailymotionusergrouplisttab.h"
#include "dailymotiongrouplistdelegate.h"
#include "dailymotionvideolistwindow.h"

DailymotionUserGroupListTab::DailymotionUserGroupListTab(Session *session, QWidget *parent) :
    AbstractTab(parent),
    m_session(session),
    m_listView(new ListView(this)),
    m_model(new DailymotionUserGroupListModel(m_session, this)),
    m_contextMenu(new QMenu(this)),
    m_leaveAction(m_contextMenu->addAction(tr("Leave group"), this, SLOT(leaveGroup()))),
    m_noResultsLabel(new QLabel(QString("<p style='color:#4d4d4d;font-size:40px;'><center><b>%1</b></center></p>").arg(tr("No groups found")), this)),
    m_grid(new QGridLayout(this))
{
    m_grid->addWidget(m_listView, 0, 0);
    m_listView->setItemDelegate(new DailymotionGroupListDelegate(m_listView));
    m_noResultsLabel->hide();

    if (m_session->dailymotion()->groupsLoaded()) {
        onGroupsLoaded();
    }
    else {
        m_session->toggleBusy(true);
        connect(m_session->dailymotion(), SIGNAL(allGroupsLoaded()), this, SLOT(onGroupsLoaded()));
    }

    onOrientationChanged();
}

void DailymotionUserGroupListTab::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void DailymotionUserGroupListTab::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void DailymotionUserGroupListTab::onGroupsLoaded() {
    m_session->toggleBusy(false);
    m_noResultsLabel->setVisible(m_model->rowCount() == 0);
    m_listView->setModel(m_model);

    connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    connect(m_listView, SIGNAL(customContextMenuRequested(QPoint)), this, SLOT(showContextMenu(QPoint)));
}

void DailymotionUserGroupListTab::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        showGroup(m_model->get(index.row()));
    }
}

void DailymotionUserGroupListTab::showGroup(QSharedPointer<GroupItem> group) {
    DailymotionVideoListWindow *window = new DailymotionVideoListWindow(m_session, m_session->currentWindow());
    window->setWindowTitle(group.data()->title());
    window->getGroupVideos(group);
    window->show();
}

void DailymotionUserGroupListTab::showContextMenu(const QPoint &pos) {
    m_contextMenu->popup(pos, m_leaveAction);
}

void DailymotionUserGroupListTab::leaveGroup() {
    m_session->dailymotion()->leaveGroup(m_model->get(m_listView->currentIndex().row()));
}
