#ifndef ABSTRACTVIDEOLISTMODEL_H
#define ABSTRACTVIDEOLISTMODEL_H

#include "thumbnailcache.h"
#include "videoitem.h"
#include <QAbstractListModel>
#include <QSharedPointer>

class AbstractVideoListModel : public QAbstractListModel
{
    Q_OBJECT

public:
    enum Roles {

        IdRole = Qt::UserRole+1,
        VideoIdRole,
        TitleRole,
        ArtistRole,
        DateRole,
        DurationRole,
        ViewCountRole,
        RatingCountRole,
        RatingRole,
        ThumbnailRole,
        ArchiveRole,
        ServiceRole,
        CheckedRole
    };

public:
    explicit AbstractVideoListModel(ThumbnailCache *cache, QObject *parent = 0);
    ~AbstractVideoListModel();
    int rowCount(const QModelIndex &parent = QModelIndex()) const;
    QVariant data(const QModelIndex &index, int role) const;
    QSharedPointer<VideoItem> get(int row) const;
    QList< QSharedPointer<VideoItem> > checkedItems() const;
    inline bool itemsChecked() const { return !m_checkedRows.isEmpty(); }
    void insertVideo(int row, QSharedPointer<VideoItem> video);
    void appendVideo(QSharedPointer<VideoItem> video);
    bool removeVideo(const QString &id);

public slots:
    void checkAll();
    void checkNone();
    void toggleChecked(int row);

protected:
    bool removeRow(int row, const QModelIndex &parent = QModelIndex());

protected slots:
    void onThumbnailReady();
    
protected:
    ThumbnailCache *m_cache;
    QList< QSharedPointer<VideoItem> > m_list;
    QList<int> m_checkedRows;
};

#endif // ABSTRACTVIDEOLISTMODEL_H
