#include "youtubeplaylistlistwindow.h"
#include "youtubeplaylistvideoswindow.h"
#include "youtubeplaylistdelegate.h"
#include "../base/youtubeplaylistlistmodel.h"
#include "listview.h"
#include <QLabel>
#include <QMaemo5Style>

YouTubePlaylistListWindow::YouTubePlaylistListWindow(QWidget *parent) :
    StackedWindow(parent),
    m_listView(new ListView(this)),
    m_model(new YouTubePlaylistListModel(this)),
    m_noResultsLabel(new QLabel(QString("<p style='color:%1;font-size:40px;'><center><b>%2</b></center></p>").arg(QMaemo5Style::standardColor("SecondaryTextColor").name()).arg(tr("No playlists found")), this))
{
    this->setCentralWidget(m_listView);

    m_listView->setModel(m_model);
    m_listView->setItemDelegate(new YouTubePlaylistDelegate(m_listView));
    m_noResultsLabel->hide();

    this->connect(m_model, SIGNAL(loadingChanged(bool)), this, SLOT(onLoadingChanged(bool)));
    this->connect(m_model, SIGNAL(countChanged(int)), this, SLOT(onCountChanged(int)));
    this->connect(m_listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
    this->connect(m_listView, SIGNAL(atEnd()), m_model, SLOT(getMorePlaylists()));

    this->onOrientationChanged();
}

void YouTubePlaylistListWindow::setLandscapeLayout() {
    m_noResultsLabel->setFixedSize(800, 400);
}

void YouTubePlaylistListWindow::setPortraitLayout() {
    m_noResultsLabel->setFixedSize(480, 700);
}

void YouTubePlaylistListWindow::search(const QString &query, Queries::QueryOrder order) {
    this->setWindowTitle(tr("Search") + QString(" ('%1')").arg(query));
    m_model->search(query, order);
}

void YouTubePlaylistListWindow::onLoadingChanged(bool loading) {
    this->toggleBusy(loading);
    m_noResultsLabel->setVisible((!loading) && (m_model->rowCount() == 0));
}

void YouTubePlaylistListWindow::onCountChanged(int count) {
    m_noResultsLabel->setVisible((count == 0) && (!m_model->loading()));
}

void YouTubePlaylistListWindow::onItemClicked(const QModelIndex &index) {
    if (index.isValid()) {
        this->showPlaylist(m_model->get(index.row()));
    }
}

void YouTubePlaylistListWindow::showPlaylist(QSharedPointer<PlaylistItem> playlist) {
    YouTubePlaylistVideosWindow *window = new YouTubePlaylistVideosWindow(playlist, this);
    window->show();
}
