# -*- coding: utf-8 -*-

"""
Module implementing VideoItemWidget.
"""

from PyQt4.QtGui import *
from PyQt4.QtCore import *
import time

from Ui_customwidgets import Ui_VideoItemWidget,  Ui_VideoDownloadWidget

class VideoItemWidget(QWidget, Ui_VideoItemWidget):
    """
    Widget showing a video thumbnail, duration, title, 
    author and rating.
    """
    def __init__(self, parent, video):
        """
        Constructor
        """
        QWidget.__init__(self, parent)
        self.setupUi(self)
        self.checkBox.mousePressEvent = self.ignoreClick
        self.titleLabel.setText(unicode(video.title.text,  "utf-8"))
        try:
            self.durationLabel.setText(unicode(time.strftime('%M:%S', time.gmtime(float(video.media.duration.seconds)))))
        except:
            self.durationLabel.setText("--")
        self.authorLabel.setText("By %s on %s" % (unicode(video.media.credit.text, "utf-8"), video.media.uploaded.text.split("T")[0]))
            
    def ignoreClick(self, event):
        """
        Propagates the mouse event to the parent.
        """
        event.ignore()

    def hideCheckBox(self):
        """
        Hides the widget's checkbox.
        """       
        self.thumbLabel.move(0, 2)
        self.durationLabel.move(73, 68)
        self.widget.setGeometry(QRect(130, 0, 670, 94))
        self.checkBox.setVisible(False)
        self.checkBox.setCheckState(Qt.Unchecked)

    def showCheckBox(self):
        """
        Displays the widget's checkbox.
        """
        self.thumbLabel.move(70, 2)
        self.durationLabel.move(143, 68)
        self.widget.setGeometry(QRect(200, 0, 590, 94))
        self.checkBox.setVisible(True)


    def toggleCheckBox(self):
        """
        Displays or removes the checkbox at the left of 
        the widget.
        """
        if not self.checkBox.isVisible():
            self.showCheckBox()
        else:
            self.hideCheckBox()

class VideoDownloadItemWidget(QWidget, Ui_VideoDownloadWidget):
    """
    Widget showing same information as VideoItemWidget 
    with an additional progress bar showing the download 
    progress.
    """
    def __init__(self, parent, video):
        """
        Constructor
        """
        QWidget.__init__(self, parent)
        self.setupUi(self)
        self.titleLabel.setText(unicode(video.title.text,  "utf-8"))
        self.durationLabel.setText(unicode(time.strftime('%M:%S', time.gmtime(float(video.media.duration.seconds)))))
        self.orientationChanged()
        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged)
        
    def orientationChanged(self):
        """
        Changes the geometry of the progressBar to keep it visible.
        """
        screenGeometry = QApplication.desktop().screenGeometry()
        if screenGeometry.height() > screenGeometry.width():
            self.widget.setGeometry(QRect(130, 2, 180, 90))
            self.progressBar.setGeometry(QRect(330, 2, 120, 90))
        else:
            self.widget.setGeometry(QRect(130, 2, 470, 90))
            self.progressBar.setGeometry(QRect(620, 2, 150, 90))

class CommentWidget(QWidget):
    """
    Widget displaying comment author and comment text.
    """
    def __init__(self, parent, author, comment):
        """
        Constructor
        """
        QWidget.__init__(self, parent)
        self.textEdit = QTextEdit()
        self.textEdit.setReadOnly(True)
        self.textEdit.viewport().setAutoFillBackground(False)
        self.textEdit.setFrameStyle(QFrame.NoFrame)
        self.textEdit.setStyleSheet("color: rgb(255, 255, 255); font-size: 18px")
        self.document = QTextDocument(unicode(comment, "utf-8"))
        self.textEdit.setDocument(self.document)
        self.textEdit.setFixedHeight(self.document.documentLayout().documentSize().toSize().height())
        self.authorLabel = QLabel(unicode(author, "utf-8"))
        self.authorLabel.setStyleSheet("color: rgb(120, 120, 120) ")
        self.vbox = QVBoxLayout(self)
        self.vbox.addWidget(self.authorLabel)
        self.vbox.addWidget(self.textEdit)
        self.setLayout(self.vbox)
        self.show()
