# -*- coding: utf-8 -*-

"""
Module providing access to the YouTube API and downloading of videos.
"""
from __future__ import with_statement
from PyQt4.QtCore import *
from PyQt4.QtGui import *
try:
    from PyQt4.QtMaemo5 import QMaemo5InformationBox
except:
    pass
import urllib2
import urllib
from cgi import parse_qs
import re
import time
import os
import shutil
import gdata.youtube.service

class YouTubeDataService(object):
    """
    Class providing access to the YouTube API.
    """
    # Static variables
    userDict = {}
    defaultUser = ""
    currentUser = ""
    raiseNoAccountFoundDialog = True
    ytService = gdata.youtube.service.YouTubeService()
    ytService.email = ""
    ytService.password = ""
    ytService.source = "cuteTube"
    ytService.developer_key = "AI39si6x9O1gQ1Z_BJqo9j2n_SdVsHu1pk2uqvoI3tVq8d6alyc1og785IPCkbVY3Q5MFuyt-IFYerMYun0MnLdQX5mo2BueSw"
    stdHeaders = {
    'User-Agent': 'Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.8) Gecko/20100723 Firefox/3.6.8',
    'Accept-Charset': 'ISO-8859-1,utf-8;q=0.7,*;q=0.7',
    'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
    'Accept-Language': 'en-us,en;q=0.5',
    }
    
    def __init__(self,  parent):
        object.__init__(self,  parent)
    
    @staticmethod
    def youtubeLogin(username):
        """
        Logs in to the user's chosen YouTube account.
        """       
        YouTubeDataService.ytService.email = unicode(YouTubeDataService.userDict[username][0], "utf-8")
        YouTubeDataService.ytService.password = unicode(YouTubeDataService.userDict[username][1], "utf-8")
        try:
            YouTubeDataService.ytService.ProgrammaticLogin()
            YouTubeDataService.currentUser = username
        except:
            # Some users have reported authentication issues. Using the username in place of the email address may work.
            YouTubeDataService.ytService.email = unicode(username, "utf-8")
            YouTubeDataService.ytService.password = unicode(YouTubeDataService.userDict[username][1], "utf-8")
            YouTubeDataService.ytService.ProgrammaticLogin()
            YouTubeDataService.currentUser = username
        
    @staticmethod
    def addComment(comment, videoID):
        """
        Adds a comment to the video argument's comment feed.
        """
        videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(uri = videoID)
        YouTubeDataService.ytService.AddComment(unicode(comment), videoEntry) 

    @staticmethod
    def addRating(rating, videoID):
        """
        Adds a rating to the video argument.
        """
        videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(uri = videoID)
        YouTubeDataService.ytService.AddRating(rating, videoEntry)
    
    @staticmethod
    def addSubscription(username):
        """
        Adds a subscription to the username argument.
        """
        YouTubeDataService.ytService.AddSubscriptionToChannel(username)

    @staticmethod
    def removeSubscription(subscriptionUri):
        """
        Removes the subscription to the specified channel.
        """
        YouTubeDataService.ytService.DeleteSubscription(subscriptionUri)

    @staticmethod
    def addVideoToFavourites(video):
        if "playlists" in video.id.text:
            videoId = video.comments.feed_link[0].href.split("/")[-2]
            video = YouTubeDataService.ytService.GetYouTubeVideoEntry(video_id = videoId)
        YouTubeDataService.ytService.AddVideoEntryToFavorites(video)

    @staticmethod
    def removeVideoFromFavourites(videoID):
        YouTubeDataService.ytService.DeleteVideoEntryFromFavorites(videoID.split("/")[-1])

    @staticmethod
    def newPlaylist(playlistTitle, playlistDescription, private):
        """
        Creates a new playlist using the title and description arguments.
        """
        return YouTubeDataService.ytService.AddPlaylist(playlistTitle, playlistDescription, private)


    @staticmethod
    def addVideoToPlaylist(playlist, videoId):
        """
        Add the current video to the chosen playlist.
        """
        playlistId = playlist.id.text
        playlistUri = "http://gdata.youtube.com/feeds/api/playlists/%s" % playlistId.split("/")[-1]
        YouTubeDataService.ytService.AddPlaylistVideoEntryToPlaylist(playlistUri, videoId)

    @staticmethod
    def removeVideoFromPlaylist(playlistEntry):
        """
        Removes the chosen video from the playlist.
        """
        playlistUri = playlistEntry[:playlistEntry.rfind("/")]
        videoId = playlistEntry.split("/")[-1]
        YouTubeDataService.ytService.DeletePlaylistVideoEntry(playlistUri, videoId)

    @staticmethod
    def updatePlaylistVideo(playlistId, playlistVideoId, newVideoTitle, newVideoDescription, newPosition):
        YouTubeDataService.ytService.UpdatePlaylistVideoEntryMetaData(playlistId, playlistVideoId, newVideoTitle, newVideoDescription, newPosition)

    @staticmethod
    def updatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private):
        YouTubeDataService.ytService.UpdatePlaylist(playlistId, newPlaylistTitle, newPlaylistDescription, private)

    @staticmethod
    def deletePlaylist(playlistUri):
        YouTubeDataService.ytService.DeletePlaylist(playlistUri)

    @staticmethod
    def getVideoEntry(videoId):
        return YouTubeDataService.ytService.GetYouTubeVideoEntry(videoId)

    @staticmethod
    def getVideoThumbnail(thumbUrl):
        """
        Retrieves and returns the thumbnail for the video.
        """
        opener = urllib2.build_opener()
        thumbPage = opener.open(thumbUrl)
        image = QImage()
        if image.loadFromData(thumbPage.read()):
            thumbnail = QPixmap.fromImage(image)
            return thumbnail

    @staticmethod
    def updateVideo(videoId, newVideoTitle, newVideoDescription):
        video = YouTubeDataService.getVideoEntry(videoId)
        video.media.title.text = newVideoTitle
        video.media.description.text = newVideoDescription
        video.link.append(atom.Link(rel='edit', href='http://gdata.youtube.com/feeds/api/users/%s/uploads/%s' % (YouTubeDataService.currentUser, videoId.split("/")[-1])))
        YouTubeDataService.ytService.UpdateVideoEntry(video)

    @staticmethod
    def deleteVideo(videoId):
        """
        Deletes the video from the user's uploads.
        """
        videoEntry = YouTubeDataService.ytService.GetYouTubeVideoEntry(videoId)
        YouTubeDataService.ytService.DeleteVideoEntry(videoEntry)

    @staticmethod
    def getVideoUrl(video,  videoFormat = "18"):
        """
        Returns the YouTube video url for download or playback.
        """
        videoUrl = ""        
        if "playlists" in video.id.text:
            videoId = video.comments.feed_link[0].href.split("/")[-2]
        else:
            videoId = video.id.text.split("/")[-1]
        for elType in ['&el=embedded', '&el=detailpage', '&el=vevo', '']:
            videoInfoUrl = ('http://www.youtube.com/get_video_info?&video_id=%s%s&ps=default&eurl=&gl=US&hl=en' % (videoId, elType))
            request = urllib2.Request(videoInfoUrl, None, YouTubeDataService.stdHeaders)
            videoInfoWebpage = urllib2.urlopen(request).read()
            videoInfo = parse_qs(videoInfoWebpage)
            if 'token' in videoInfo:
                videoToken = urllib.unquote_plus(videoInfo['token'][0])
                formatList = ['22', '35', '34', '18', '17']
                for format in formatList[formatList.index(videoFormat):]:
                    videoUrl = 'http://www.youtube.com/get_video?video_id=%s&t=%s&eurl=&el=&ps=&asv=&fmt=%s' % (videoId, videoToken,  format)
                    videoLength = urllib.urlopen(videoUrl).info()["Content-Length"]
                    if videoLength !="0":
                        break
                break
        return videoUrl

class YouTubeVideoFeed(QThread):
    """
    Pulls the video feed from the YouTube server.
    """

    def __init__(self, parent, videoFeed,  results = 0):
        QThread.__init__(self, parent)
        self.videoFeed = videoFeed
        self.videoList = []
        self.results = results
    
    def getVideoFeed(self):
        """
        Retrieves and returns the video feed.
        """
        try:
            self.ytVideoFeed = YouTubeDataService.ytService.GetYouTubeVideoFeed(self.videoFeed + "?start-index=%s" % unicode(self.results + 1))
        except:
            self.ytVideoFeed = YouTubeDataService.ytService.GetYouTubeVideoFeed(self.videoFeed + "&start-index=%s" % unicode(self.results + 1))
            
    def getVideoData(self):
        for video in self.ytVideoFeed.entry:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[3].url)
                videoData = (video, thumbnail)
                self.videoList.append(video)
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), videoData)
                self.results += 1
            except:
                pass

    def run(self):
        self.emit(SIGNAL("feedCompleted(bool)"), True)
        self.getVideoFeed() 
        self.getVideoData()
        self.emit(SIGNAL("feedCompleted(bool)"), False)

class YouTubeQueueFeed(QThread):
    """
    Pulls the video feed from the YouTube server.
    """

    def __init__(self, parent):
        QThread.__init__(self, parent)
    
    def getQueueFeed(self):
        """
        Retrieves and returns the video feed.
        """
        for video in YouTubeVideoPlayer.playlist:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[3].url)
                videoData = (video, thumbnail)
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), videoData)
            except:
                pass

    def run(self):
        self.getQueueFeed() 

class YouTubeDownloadQueueFeed(QThread):
    """
    Pulls the video feed from the YouTube server.
    """

    def __init__(self, parent):
        QThread.__init__(self, parent)
    
    def getQueueFeed(self):
        """
        Retrieves and returns the video feed.
        """
        for video in YouTubeVideoDownloader.downloadQueue:
            try:
                thumbnail = YouTubeDataService.getVideoThumbnail(video.media.thumbnail[3].url)
                videoData = (video, thumbnail)
                self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), videoData)
            except:
                pass

    def run(self):
        self.getQueueFeed()

class YouTubePlaylistFeed(QThread):
    """
    Pulls the user's playlist feed.
    """

    def __init__(self, parent):
        QThread.__init__(self, parent)

    
    def getPlaylistFeed(self):
        """
        Retrieves and returns the user's playlist feed.
        """
        playlistsUri = "http://gdata.youtube.com/feeds/api/users/default/playlists?max-results=50"
        self.playlistFeed = YouTubeDataService.ytService.GetYouTubePlaylistFeed(uri = playlistsUri)
        self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.playlistFeed.entry)
    
    def run(self):
        self.getPlaylistFeed()

class YouTubeSubscriptionsFeed(QThread):
    """
    Provides access to the user's subscriptions.
    """
    def __init__(self, parent):
        """
        Constructor
        """
        QThread.__init__(self, parent)

    def getSubscriptionsFeed(self):
        """
        Retrieves the user's subscriptions feed.
        """
        subscriptionsUri = "http://gdata.youtube.com/feeds/api/users/default/subscriptions?max-results=50"
        self.subscriptionsFeed = YouTubeDataService.ytService.GetYouTubeSubscriptionFeed(uri = subscriptionsUri)
        self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), self.subscriptionsFeed.entry)

    def run(self):
        self.getSubscriptionsFeed()

class YouTubeCommentsFeed(QThread):
    """
    Retrieves and returns the comments feed 
    for the video.
    """
    def __init__(self, parent, video):
        """
        Constructor
        """
        QThread.__init__(self, parent)
        self.video = video

    def getVideoComments(self):
        """
        Retrieves and returns the comments feed 
        for the video.
        """
        videoId = self.video.comments.feed_link[0].href.split("/")[-2]
        comments = YouTubeDataService.ytService.GetYouTubeVideoCommentFeed(video_id = videoId)
        self.emit(SIGNAL("dataLoaded(PyQt_PyObject)"), comments.entry)

    def run(self):
        self.getVideoComments()

class YouTubeVideoPlayer(QThread):
    """
    Provides YouTube video playback functions.
    """
    # Static variables
    playlist = []
    mediaPlayer = "Media Player"
    formatList = ["17", "18", "34", "35", "22"]
    playbackFormat = "18"
    playCommandDict = {"KMPlayer": "dbus-send --print-reply --dest=com.nokia.kmplayer /com/nokia/kmplayer com.nokia.kmplayer.mime_open string:\'%s\'", "MPlayer": "mplayer -fs \'%s\'", "Media Player": "dbus-send --print-reply --dest=com.nokia.mediaplayer /com/nokia/mediaplayer com.nokia.mediaplayer.mime_open string:\'%s\'"}
    
    def __init__(self, parent, video = None):
        """
        Constructor
        """
        QThread.__init__(self, parent)
        self.video = video
        
    def createAndPlayPlaylist(self):
        playlistFile = "%s/cutetube.m3u" % YouTubeVideoDownloader.downloadFolder
        with open(playlistFile, "w") as file:
            for video in YouTubeVideoPlayer.playlist:
                videoUrl = YouTubeDataService.getVideoUrl(video)
                file.write(unicode(videoUrl + "\n"))
        playbackCommand = YouTubeVideoPlayer.playCommandDict.get(YouTubeVideoPlayer.mediaPlayer)
        os.system(playbackCommand % playlistFile)

    def playYouTubeVideo(self):
        playbackCommand = YouTubeVideoPlayer.playCommandDict.get(unicode(YouTubeVideoPlayer.mediaPlayer))
        filename = "%s/%s.mp4" % (YouTubeVideoDownloader.downloadFolder, re.sub('[:/|\\\\]', "-", self.video.media.title.text).decode("utf-8"))
        if os.path.exists(filename):
            os.system(playbackCommand % filename.encode("utf-8"))
        else:
            videoUrl = YouTubeDataService.getVideoUrl(self.video,  YouTubeVideoPlayer.playbackFormat)
            os.system(playbackCommand % videoUrl)  

    def run(self):
        if self.video != None:
            self.playYouTubeVideo()
        else:
            self.createAndPlayPlaylist()

class YouTubeVideoDownloader(object):
    """
    Manages download tasks in the download queue.
    """
    # Static variables
    downloadFolder = "/home/user/MyDocs/.videos"
    downloadFormat = "18"
    downloadQueue = []
    taskQueue = []
    currentTask = None
    currentStatus = "inactive"
    defaultTaskStatus = "queued"


    def __init__(self, parent = None):
        """
        Constructor
        """
        object.__init__(self, parent = None)
        
    @staticmethod
    def addTask(video):
        """
        Add the video to the download queue. 
        """
        YouTubeVideoDownloader.downloadQueue.append(video)
        task = DownloadTask(video)
        YouTubeVideoDownloader.taskQueue.append(task)
        if YouTubeVideoDownloader.currentStatus == "inactive" and YouTubeVideoDownloader.defaultTaskStatus == "queued":
            YouTubeVideoDownloader.run()
            
    @staticmethod
    def pauseTask(task):
        """
        Sets the status of the task to "paused".
        """
        YouTubeVideoDownloader.taskQueue[task].setStatus("paused")
        
    @staticmethod
    def cancelTask(task):
        """
        Sets the status of the task to "cancelled"
        """
        YouTubeVideoDownloader.taskQueue[task].setStatus("cancelled")
            
    @staticmethod
    def resumeTask(task):
        """
        Sets the status of the task to "queued" and resumes the download 
        if currentStatus is "inactive".
        """
        YouTubeVideoDownloader.taskQueue[task].setStatus("queued")
        if YouTubeVideoDownloader.currentStatus == "inactive":
            YouTubeVideoDownloader.run()
            
    @staticmethod
    def clearTasks():
        """
        Clears the taskQueue and the downloadQueue.
        """
        YouTubeVideoDownloader.taskQueue = []
        YouTubeVideoDownloader.downloadQueue = []
    
    @staticmethod
    def run():
        for task in YouTubeVideoDownloader.taskQueue:
            if task.getStatus() == "queued":
                YouTubeVideoDownloader.currentTask = task
                YouTubeVideoDownloader.currentTask.start()
                YouTubeVideoDownloader.currentStatus = "active"
                break
        else:
            YouTubeVideoDownloader.currentStatus = "inactive"

class DownloadTask(QThread):
    """
    Thread that carries out individual video downloads. Much of the 
    code is taken from download.py of gPodder.
    """
        
    def getTitle(self):
        return self.video.media.title.text

    def getStatus(self):
        return self.status

    def setStatus(self, status):
        if status != self.getStatus:
            self.statusChanged = True
            self.status = status
            
    def getUrl(self):
        return YouTubeDataService.getVideoUrl(self.video)
        
    def removedFromList(self):
        if self.status != "completed":
            os.remove(self.tempname)

    def __init__(self, video):
        QThread.__init__(self,  parent = None)
        self.status = YouTubeVideoDownloader.defaultTaskStatus
        self.statusChanged = True
        self.video = video
        self.connect(self,  SIGNAL("finished()"),  YouTubeVideoDownloader.run)

        # Create the target filename

        self.filename = "%s/%s.mp4" % (YouTubeVideoDownloader.downloadFolder, unicode(re.sub('[:/|\\\\]', "-", self.video.media.title.text), "utf-8"))
        self.tempname = self.filename + '.partial'

        self.totalSize = 0
        self.speed = 0.0
        self.progress = 0.0
        self.errorMessage = None

        # Variables for speed calculation
        self.startTime = 0
        self.startBlocks = 0

        # If the tempname already exists, set progress accordingly
        if os.path.exists(self.tempname):
            try:
                already_downloaded = os.path.getsize(self.tempname)
                if self.totalSize > 0:
                    self.progress = max(0.0, min(1.0, float(alreadyDownloaded)/self.totalSize))
            except OSError, os_error:
                print 'Error while getting size for existing file: %s' % os_error

    def statusUpdated(self, count, blockSize, totalSize):
        # We see a different "total size" while downloading,
        # so correct the total size variable in the thread
        if totalSize != self.totalSize and totalSize > 0:
            self.totalSize = float(totalSize)

        if self.totalSize > 0:
            self.progress = max(0.0, min(1.0, float(count*blockSize)/self.totalSize))

        self.calculateSpeed(count, blockSize)

        if self.status == "cancelled":
            raise DownloadCancelledException()

        if self.status == "paused":
            raise DownloadCancelledException()
            
        self.emit(SIGNAL("downloadUpdated()"))

    def calculateSpeed(self, count, blockSize):
        if count % 5 == 0:
            now = time.time()
            if self.startTime > 0:
                passed = now - self.startTime
                if passed > 0:
                    speed = ((count-self.startBlocks)*blockSize)/passed
                else:
                    speed = 0
            else:
                self.startTime = now
                self.startBlocks = count
                passed = now - self.startTime
                speed = count*blockSize

            self.speed = float(speed/1000)

    def run(self):
        # Speed calculation (re-)starts here
        self.startTime = 0
        self.startBlocks = 0

        # If the download has already been cancelled, skip it
        if self.status == "cancelled":
            os.remove(self.tempname)
            self.progress = 0.0
            self.speed = 0.0

        # We are downloading this file right now
        self.status = "downloading"

        try:
            # Resolve URL and start downloading the episode
            url = YouTubeDataService.getVideoUrl(self.video,  YouTubeVideoDownloader.downloadFormat)
            downloader =  DownloadURLOpener()
            headers, realUrl = downloader.retrieveResume(url, \
                    self.tempname, reporthook=self.statusUpdated)

            shutil.move(self.tempname, self.filename)
            self.status = "completed"
            self.speed = 0.0

        except DownloadCancelledException:
            print'Download has been cancelled/paused'
            if self.status == "cancelled":
                os.remove(self.tempname)
                self.progress = 0.0
                self.speed = 0.0
                self.emit(SIGNAL("statusChanged()"))
        except urllib.ContentTooShortError, ctse:
            self.status = "failed"
            print'Missing content from server'
            self.emit(SIGNAL("statusChanged()"))
            
        except IOError, ioe:
            print 'Error "%s" while downloading "%s"' % (ioe.strerror, self.video.media.title.text)
            self.status = "failed"
            self.emit(SIGNAL("statusChanged()"))
        except Exception, e:
            self.status = "failed"
            print 'Error: %s' % e.message
            self.emit(SIGNAL("statusChanged()"))
        
        
class ContentRange(object):
    # Based on:
    # http://svn.pythonpaste.org/Paste/WebOb/trunk/webob/byterange.py
    #
    # Copyright (c) 2007 Ian Bicking and Contributors
    #
    # Permission is hereby granted, free of charge, to any person obtaining
    # a copy of this software and associated documentation files (the
    # "Software"), to deal in the Software without restriction, including
    # without limitation the rights to use, copy, modify, merge, publish,
    # distribute, sublicense, and/or sell copies of the Software, and to
    # permit persons to whom the Software is furnished to do so, subject to
    # the following conditions:
    #
    # The above copyright notice and this permission notice shall be
    # included in all copies or substantial portions of the Software.
    #
    # THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    # EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    # MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    # NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
    # LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
    # OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    # WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
    """
    Represents the Content-Range header

    This header is ``start-stop/length``, where stop and length can be
    ``*`` (represented as None in the attributes).
    """

    def __init__(self, start, stop, length):
        assert start >= 0, "Bad start: %r" % start
        assert stop is None or (stop >= 0 and stop >= start), (
            "Bad stop: %r" % stop)
        self.start = start
        self.stop = stop
        self.length = length

    def __repr__(self):
        return '<%s %s>' % (
            self.__class__.__name__,
            self)

    def __str__(self):
        if self.stop is None:
            stop = '*'
        else:
            stop = self.stop + 1
        if self.length is None:
            length = '*'
        else:
            length = self.length
        return 'bytes %s-%s/%s' % (self.start, stop, length)

    def __iter__(self):
        """
        Mostly so you can unpack this, like:

            start, stop, length = res.content_range
        """
        return iter([self.start, self.stop, self.length])

    @classmethod
    def parse(cls, value):
        """
        Parse the header.  May return None if it cannot parse.
        """
        if value is None:
            return None
        value = value.strip()
        if not value.startswith('bytes '):
            # Unparseable
            return None
        value = value[len('bytes '):].strip()
        if '/' not in value:
            # Invalid, no length given
            return None
        range, length = value.split('/', 1)
        if '-' not in range:
            # Invalid, no range
            return None
        start, end = range.split('-', 1)
        try:
            start = int(start)
            if end == '*':
                end = None
            else:
                end = int(end)
            if length == '*':
                length = None
            else:
                length = int(length)
        except ValueError:
            # Parse problem
            return None
        if end is None:
            return cls(start, None, length)
        else:
            return cls(start, end-1, length)
        
class DownloadURLOpener(urllib.FancyURLopener):
    """
    This code is from download.py of gPodder.
    """
    def __init__(self):
        urllib.FancyURLopener.__init__(self, None)

    def retrieveResume(self, url, filename, reporthook=None, data=None):
        """Download files from an URL; return (headers, real_url)

        Resumes a download if the local filename exists and
        the server supports download resuming.
        """

        currentSize = 0
        tfp = None
        if os.path.exists(filename):
            try:
                currentSize = os.path.getsize(filename)
                tfp = open(filename, 'ab')
                #If the file exists, then only download the remainder
                if currentSize > 0:
                    self.addheader('Range', 'bytes=%s-' % (currentSize))
            except:
                print 'Cannot open file for resuming: %s' % filename
                tfp = None
                currentSize = 0

        if tfp is None:
            tfp = open(filename, 'wb')

        url = urllib.unwrap(urllib.toBytes(url))
        fp = self.open(url, data)
        headers = fp.info()

        if currentSize > 0:
            # We told the server to resume - see if she agrees
            # See RFC2616 (206 Partial Content + Section 14.16)
            # XXX check status code here, too...
            range = ContentRange.parse(headers.get('content-range', ''))
            if range is None or range.start != currentSize:
                # Ok, that did not work. Reset the download
                # TODO: seek and truncate if content-range differs from request
                tfp.close()
                tfp = open(filename, 'wb')
                currentSize = 0
                print 'Cannot resume. Missing or wrong Content-Range header (RFC2616)'

        result = headers, fp.geturl()
        bs = 1024*8
        size = -1
        read = currentSize
        blocknum = int(currentSize/bs)
        if reporthook:
            if "content-length" in headers:
                size = int(headers["Content-Length"]) + currentSize
            reporthook(blocknum, bs, size)
        while read < size or size == -1:
            if size == -1:
                block = fp.read(bs)
            else:
                block = fp.read(min(size-read, bs))
            if block == "":
                break
            read += len(block)
            tfp.write(block)
            blocknum += 1
            if reporthook:
                reporthook(blocknum, bs, size)
        fp.close()
        tfp.close()
        del fp
        del tfp

        # raise exception if actual size does not match content-length header
        if size >= 0 and read < size:
            raise urllib.ContentTooShortError("retrieval incomplete: got only %i out "
                                       "of %i bytes" % (read, size), result)

        return result
        
class DownloadCancelledException(Exception): pass
