# -*- coding: utf-8 -*-

"""
Module implementing RateVideoDialog.
"""

from PyQt4.QtGui import *
from PyQt4.QtCore import pyqtSignature
try:
    from PyQt4.QtMaemo5 import QMaemo5InformationBox
except:
    pass
import youtubeservice

from Ui_ratevideodialog import Ui_RateVideoDialog

class RateVideoDialog(QDialog, Ui_RateVideoDialog):
    """
    Class documentation goes here.
    """
    def __init__(self, parent, videoID):
        """
        Constructor
        """
        QDialog.__init__(self, parent)
        self.setupUi(self)
        try:
            self.setAttribute(Qt.WA_Maemo5StackedWindow)
        except:
            pass
        self.videoID = videoID
        for num in range(5):
            item = QListWidgetItem(unicode(num + 1))
            self.ratingListWidget.addItem(item)
        self.show()
    
    @pyqtSignature("QListWidgetItem*")
    def on_ratingListWidget_itemClicked(self, item):
        """
        Adds the chosen rating to the video.
        """
        try:
            youtubeservice.YouTubeDataService.addRating(int(item.text()), self.videoID)
            QMaemo5InformationBox.information(self, "Rating of %s stars added to video" % item.text()) 
            self.close()
        except:
            QMaemo5InformationBox.information(self, "Unable to add rating") 
