from threading import Timer

from square import *
from random import randrange

class BlitzSquare(SquareObserver):

    def __init__(self, game, time = 30, managed = None):
        self.time = time
        self.game = game
        self.timer = None

        if managed == None:
            self.managed = range(len(game.players))
        else:
            self.managed = managed
        
        game.add_square_observer(self)

    def timeout(self):
        game = self.game

        while True:
            point = (randrange(game.size), randrange(game.size))

            if game.point_free(point):
                break

        game.set_point(point, self.cur_player)

    def point_set(self, player, point, squares):
        if self.timer:
            self.timer.cancel()
            self.timer = None
            
        self.cur_player = (player + 1) % len(self.game.players)

        if self.cur_player in self.managed:
            self.timer = Timer(self.time, self.timeout)
            self.timer.start()

    def player_wins(self, player):
        if self.timer:
            self.timer.cancel()
            self.timer = None

