class SquareObserver():

    def point_set(self, player, point, squares):
        pass

    def player_wins(self, player):
        pass


class Player():

    def __init__(self, name):
        self.name = name
        self.score = 0
        self.points = []
        self.squares = []


class SquareGame():

    def __init__(self, size, players, win_target = 150, win_offset = 15):
        self.size = size
        self.players = map(lambda p: Player(p), players)
        self.observers = []

        self.win_target = win_target
        self.win_offset = win_offset

    def add_square_observer(self, observer):
        self.observers.append(observer)

    def remove_square_observer(self, observer):
        self.observers.remove(observer)

    def point_free(self, point):
        for player in self.players:
            if point in player.points:
                return False

        return True

    def _find_squares(self, point, player):
        points = self.players[player].points

        if point not in points:
            return []

        tadd = lambda a, b: (a[0]+b[0], a[1]+b[1]) 

        found = []
        for p in points:
            if p != point:
                dx = p[0] - point[0]
                dy = p[1] - point[1]

                a = tadd(point, (dx + dy, dy - dx))
                if a in points:
                    b = tadd(point, (dy, -dx))
                    if b in points:
                        found.append((point, p, a, b))
                    
        return found

    def _check_win(self, player):
        p = self.players[player]

        if p.score > self.win_target:
            for opponent in self.players:
                if opponent != p:
                    if p.score - opponent.score < self.win_offset:
                        return False

            return True

        return False

    def set_point(self, point, player):
        assert(self.point_free(point))

        p = self.players[player]

        p.points.append(point)

        found = self._find_squares(point, player)
        if found:
            for square in found:
                self.score_square(square, player)
            p.squares.extend(found)

        for observer in self.observers:
            observer.point_set(player, point, found)

        if self._check_win(player):
            self._end_game(player)

        if sum((len(p.points) for p in self.players)) >= self.size**2:
            maxscore = 0
            winner = 0
            for i, p in enumerate(self.players):
                if p.score >= maxscore:
                    winner = i
                    maxscore = p.score

            self._end_game(winner)

        return found

    def score_square(self, square, player):
        a = square[0]
        b = square[1]

        score = (abs(a[0]-b[0]) + abs(a[1]-b[1]) + 1) ** 2

        self.players[player].score += score
        
        print("Player %s gets %i points for %s" % (self.players[player].name, score, str(square)))

    def _end_game(self, player):
        for observer in self.observers:
            observer.player_wins(player)

