/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef PODCASTLISTWINDOW_H
#define PODCASTLISTWINDOW_H

#include "stackedwindow.h"

class PodcastFilterListModel;
class ListView;
class FilterBox;
class QLabel;
class QModelIndex;
class QVBoxLayout;

class PodcastListWindow : public StackedWindow
{
    Q_OBJECT

public:
    explicit PodcastListWindow(QWidget *parent = 0);

public slots:
    void searchPodcasts(const QString &query);
    void showPodcasts();

    void clear();
    void reload();

private:
    void showEvent(QShowEvent *event);
    void keyPressEvent(QKeyEvent *event);

private slots:
    void onScrollingStopped();
    void onLoadingChanged(bool loading);
    void onCountChanged(int count);
    void showContextMenu(const QPoint &pos);
    void showEditDialog();
    void deletePodcast();
    void onItemClicked(const QModelIndex &index);

private:
    ListView *m_view;
    PodcastFilterListModel *m_model;
    FilterBox *m_filterBox;

    QMenu *m_contextMenu;
    QAction *m_editAction;
    QAction *m_deleteAction;

    QLabel *m_noResultsLabel;

    QVBoxLayout *m_vbox;
};

#endif // PODCASTLISTWINDOW_H
