/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef EDITPODCASTDIALOG_H
#define EDITPODCASTDIALOG_H

#include "abstractdialog.h"

class QLineEdit;
class QTextEdit;
class QCheckBox;
class QDialogButtonBox;
class QGridLayout;
class ScrollArea;
class Station;
class LogoDownloader;

class EditPodcastDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit EditPodcastDialog(Station *podcast, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleChanged(const QString &title);
    void onSourceChanged(const QString &source);

    void editPodcast();

    void onLogoDownloaderFinished(LogoDownloader *downloader);

private:
    Station *m_podcast;

    QLineEdit *m_titleEdit;
    QLineEdit *m_logoEdit;
    QLineEdit *m_sourceEdit;

    QTextEdit *m_descriptionEdit;

    ScrollArea *m_scrollArea;

    QDialogButtonBox *m_buttonBox;

    QGridLayout *m_grid;
};

#endif // EDITPODCASTDIALOG_H
