/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <QStringListModel>
#include "searchlistmodel.h"
#include "settings.h"

SearchListModel::SearchListModel(QObject *parent) :
    StringListModel(parent)
{
    this->setSearches(Settings::instance()->value("Search/recentSearches").toStringList());
}

SearchListModel::~SearchListModel() {
    this->saveSearches();
}

void SearchListModel::setSearches(const QStringList &searches) {
    StringListModel::setStrings(searches);
}

void SearchListModel::addSearch(const QString &query) {
    int i = m_model->stringList().indexOf(QRegExp(query, Qt::CaseInsensitive, QRegExp::FixedString));

    if (i >= 0) {
        m_model->removeRow(i);
    }

    m_model->insertRow(0);
    m_model->setData(m_model->index(0), query, 0);
    emit countChanged(this->rowCount());
}

void SearchListModel::removeSearch(const QModelIndex &index) {
    StringListModel::removeString(index);
}

void SearchListModel::removeSearch(int row) {
    StringListModel::removeString(row);
}

void SearchListModel::clearSearches() {
    StringListModel::clear();
}

void SearchListModel::saveSearches() {
    QStringList strings;
    int i = 0;

    while ((i < 50) && (i < m_model->stringList().size())) {
        strings << m_model->stringList().at(i);
        i++;
    }

    Settings::instance()->setValue("Search/recentSearches", strings);
}
