/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1
import com.cuteradio.models 1.0

MyPage {
    id: root

    function showNames(id, filter) {
        nameModel.showNames(id, filter);
    }

    title: qsTr("Stations by name")
    tools: ToolBarLayout {

        BackToolButton {}

        NowPlayingButton {}
    }

    MyListView {
        id: view

        anchors.fill: parent
        model: TuneInPairListModel {
            id: nameModel
        }
        delegate: TuneInNameDelegate {
            onClicked: {
                var page = appWindow.pageStack.push(Qt.resolvedUrl("TuneInStationListPage.qml"), { title: name });
                page.showStations(value);
            }
        }
    }

    MyScrollBar {
        flickableItem: view
    }

    Label {
        anchors {
            fill: parent
            margins: platformStyle.paddingLarge
        }
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        color: platformStyle.colorNormalMid
        font.bold: true
        font.pixelSize: 32
        text: qsTr("No stations found")
        visible: (!nameModel.count) && (!nameModel.loading)
    }

    BusyIndicator {
        anchors.centerIn: parent
        width: 64
        height: 64
        visible: nameModel.loading
        running: visible
    }
}
