import QtQuick 1.1
import com.nokia.symbian 1.1

MyQueryDialog {
    id: root

    function showBusyMessage(info, numberOfOperations) {
        if (info !== "") {
            infoLabel.text = info;
            progressBar.value = 0;
            progressBar.maximumValue = numberOfOperations;
            root.open();
        }
        else {
            root.close();
        }
    }

    Connections {
        target: root.enabled ? StreamExtractor : null
        onBusy: root.showBusyMessage(message, numberOfOperations)
        onBusyProgressChanged: progressBar.value = progress
        onError: root.close()
    }

    height: contentItem.height
    platformInverted: false
    rejectButtonText: qsTr("Cancel")
    titleText: qsTr("Please wait")
    icon: "images/info.png"
    content: Item {
        id: contentItem

        height: column.height
        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            margins: platformStyle.paddingLarge
        }

        Column {
            id: column

            anchors {
                left: parent.left
                right: parent.right
                top: parent.top
            }
            spacing: platformStyle.paddingLarge

            Label {
                id: infoLabel

                width: parent.width
                wrapMode: Text.Wrap
            }

            ProgressBar {
                id: progressBar

                width: parent.width
                visible: maximumValue > 1
                onValueChanged: if (value === maximumValue) root.close();
            }
        }
    }

    onRejected: StreamExtractor.cancelCurrentOperation()
}
