/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0
import com.cuteradio.items 1.0
import "file:///usr/lib/qt4/imports/com/nokia/meego/UIConstants.js" as UI

MyPage {
    id: root

    function loadPodcastEpisode(episodeItem) {
        episode.loadStation(episodeItem);
    }

    title: !episode.title ? qsTr("Episode info") : episode.title
    tools: ToolBarLayout {

        BackToolIcon {}

        NowPlayingButton {}
    }

    Station {
        id: episode
    }

    Flickable {
        id: flicker

        anchors {
            fill: parent
            margins: UI.PADDING_DOUBLE
        }
        contentHeight: column.height + UI.PADDING_DOUBLE

        Column {
            id: column

            anchors {
                top: parent.top
                left: parent.left
                right: parent.right
            }
            spacing: UI.PADDING_DOUBLE

            Logo {
                width: 120
                height: 120
                image: episode.logo
                text: episode.title
                enabled: (!MediaPlayer.currentStation) || (MediaPlayer.currentStation.id != episode.id)
                onClicked: appWindow.playStation(episode)
            }

            Label {
                width: parent.width
                wrapMode: Text.WordWrap
                text: episode.description
            }

            SeparatorLabel {
                width: parent.width
                text: qsTr("Properties")
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: qsTr("Genre") + ": " + episode.genre
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: qsTr("Country") + ": " + episode.country
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: qsTr("Language") + ": " + episode.language
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: qsTr("Source") + ": " + episode.source
            }

            Label {
                width: parent.width
                elide: Text.ElideRight
                font.pixelSize: UI.FONT_SMALL
                text: qsTr("Last played") + ": " + Utils.dateFromMSecs(episode.lastPlayed)
                visible: episode.lastPlayed > 0
            }
        }
    }

    ScrollDecorator {
        flickableItem: flicker
    }
}
