/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.meego 1.0

PageStackWindow {
    id: appWindow

    showStatusBar: true
    showToolBar: true
    initialPage: MainPage {
        id: mainPage
    }
    platformStyle: PageStackWindowStyle {
        id: appStyle

        background: "image://theme/meegotouch-applicationpage-background-inverted"
        backgroundFillMode: Image.Stretch
        cornersVisible: true
    }

    TitleHeader {
        id: titleHeader
    }

    MyInfoBanner {
        id: infoBanner
    }

    Loader {
        id: nowPlayingLoader

        z: Number.MAX_VALUE
        parent: appWindow.pageStack
        anchors {
            left: parent.left
            right: parent.right
            top: parent.bottom
        }
        visible: (!inputContext.softwareInputPanelVisible) && (!inputContext.customSoftwareInputPanelVisible)
        sourceComponent: !MediaPlayer.currentStation ? undefined
                                                     : appWindow.inPortrait
                                                       ? nowPlayingIndicatorPortrait
                                                       : nowPlayingIndicatorLandscape

        states: State {
            name: "showIndicator"
            when: (MediaPlayer.currentStation) && (!appWindow.pageStack.currentPage.hideNowPlayingIndicator)
            AnchorChanges { target: nowPlayingLoader; anchors { top: undefined; bottom: parent.bottom } }
        }

        transitions: Transition {
            AnchorAnimation { duration: 200 }
        }
    }

    Component {
        id: nowPlayingIndicatorLandscape

        NowPlayingIndicatorLandscape {}
    }

    Component {
        id: nowPlayingIndicatorPortrait

        NowPlayingIndicatorPortrait {}
    }

    Component.onCompleted: theme.inverted = true
}
