/*
 * Copyright (C) 2014 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

import QtQuick 1.1
import com.nokia.symbian 1.1

Item {
    id: root

    property int maxHeight: inputContext.visible ? parent.height - inputContext.height - 100 : parent.height - 100
    property int count: repeater.count

    signal suggestionChosen(string suggestion)

    height: flow.height < maxHeight - 30 ? flow.height + 30 : maxHeight

    Behavior on height { NumberAnimation { duration: 200 } }
    Behavior on opacity { NumberAnimation { duration: 200 } }

    BorderImage {
        id: frame

        anchors.fill: parent
        source: privateStyle.imagePath("qtg_fr_popup", false)
        border {
            left: platformStyle.borderSizeMedium
            top: platformStyle.borderSizeMedium
            right: platformStyle.borderSizeMedium
            bottom: platformStyle.borderSizeMedium
        }
        smooth: true
    }

    Flickable {
        id: flicker

        height: parent.height - 10
        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
            margins: 5
        }
        contentWidth: width
        contentHeight: flow.height + 30
        clip: true
        interactive: flow.height > height

        Flow {
            id: flow

            anchors {
                left: parent.left
                top: parent.top
                right: parent.right
                margins: platformStyle.paddingLarge
            }
            spacing: platformStyle.paddingLarge

            Repeater {
                id: repeater

                model: SearchModel

                Label {
                    verticalAlignment: Text.AlignVCenter
                    text: SearchModel.query == "" ? name : queryMatch
                    opacity: mouseArea.pressed ? 0.5 : 1

                    MouseArea {
                        id: mouseArea

                        anchors.fill: parent
                        onPressed: privateStyle.play(0)
                        onClicked: root.suggestionChosen(name)
                    }
                }
            }
        }
    }

    MyScrollBar {
        flickableItem: flicker
    }

    MouseArea {
        z: -1
        anchors.fill: parent
    }
}
