var Database = (function() {
    var ARTICLES_PATH = "/articles";
    var PLUGINS_PATH = "/plugins";
    var SUBSCRIPTIONS_PATH = "/subscriptions";
    var TRANSFERS_PATH = "/transfers";

    var database = {
        addSubscription: function(source, sourceType, downloadEnclosures, onsuccess, onerror) {
            Requests.post(SUBSCRIPTIONS_PATH, JSON.stringify({"source": source, "sourceType": sourceType,
                "downloadEnclosures": downloadEnclosures}), onsuccess, onerror);
        },

        deleteSubscription: function(id, onsuccess, onerror) {
            Requests.deleteResource(SUBSCRIPTIONS_PATH + "/" + id, onsuccess, onerror);
        },

        fetchSubscription: function(id, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/" + id, onsuccess, onerror);
        },

        fetchSubscriptions: function(offset, limit, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONSPATH + "?offset=" + (offset || 0) + "&limit=" + (limit || 0), onsucess, onerror);
        },

        updateSubscription: function(id, properties, onsuccess, onerror) {
            Requests.put(SUBSCRIPTIONS_PATH + "/" + id, JSON.stringify(properties), onsuccess, onerror);
        },

        markSubscriptionRead: function(id, isRead, onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/" + id + "/" + (isRead ? "read" : "unread"), onsuccess, onerror);
        },

        markAllSubscriptionsRead: function(onsuccess, onerror) {
            Requests.get(SUBSCRIPTIONS_PATH + "/read", onsuccess, onerror);
        },

        deleteArticle: function(id, onsuccess, onerror) {
            Requests.deleteResource(ARTICLES_PATH + "/" + id, onsuccess, onerror);
        },

        fetchArticle: function(id, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/" + id, onsuccess, onerror);
        },

        markArticleFavourite: function(id, isFavourite, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/" + id + "/" + (isFavourite ? "favourite" : "unfavourite"), onsuccess,
                onerror);
        },

        markArticleRead: function(id, isRead, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/" + id + "/" + (isRead ? "read" : "unread"), onsuccess, onerror);
        },

        fetchArticlesForSubscription: function(subscriptionId, offset, limit, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "?sort=date&sortDescending=true&subscriptionId=" + subscriptionId
                + "&offset=" + (offset || 0) + "&limit=" + (limit || 0), onsuccess, onerror);
        },

        searchArticles: function(query, offset, limit, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "?sort=date&sortDescending=true&search=" + query + "&offset=" + (offset || 0)
                + "&limit=" + (limit || 0), onsuccess, onerror);
        },

        deleteReadArticles: function(expiry, onsuccess, onerror) {
            Requests.get(ARTICLES_PATH + "/deleteread", onsuccess, onerror);
        }
    };

    return database;
})();
