/*
 * Copyright (C) 2016 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "opmlparser.h"
#include <QCoreApplication>
#include <QFile>
#include <QDebug>

int main(int argc, char *argv[]) {
    QCoreApplication app(argc, argv);
    
    QFile file(app.arguments().last());
    OpmlParser parser(&file);
    
    parser.readHead();
    
    qDebug() << "Head title:" << parser.title();
    
    while (parser.readNextSubscription()) {
        qDebug() << "Subscription description:" << parser.description();
        qDebug() << "Subscription feedType:" << parser.feedType();
        qDebug() << "Subscription htmlUrl:" << parser.htmlUrl();
        qDebug() << "Subscription text:" << parser.text();
        qDebug() << "Subscription title:" << parser.title();
        qDebug() << "Subscription xmlUrl:" << parser.xmlUrl();
    }
    
    qDebug() << parser.errorString();
        
    return app.exec();
}
