/*
 * Copyright (C) 2016 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SEARCHDIALOG_H
#define SEARCHDIALOG_H

#include <QDialog>

class QDialogButtonBox;
class QFormLayout;
class QLineEdit;

class SearchDialog : public QDialog
{
    Q_OBJECT
    
    Q_PROPERTY(QString query READ query)
    
public:
    explicit SearchDialog(QWidget *parent = 0);
    
    QString query() const;

private:
    QDialogButtonBox *m_buttonBox;
    
    QFormLayout *m_layout;
    
    QLineEdit *m_searchEdit;
};

#endif // SEARCHDIALOG_H
