/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "feedparser.h"
#include <QCoreApplication>
#include <QFile>
#include <QDebug>

int main(int argc, char *argv[]) {
    QCoreApplication app(argc, argv);
    
    QFile file(app.arguments().last());
    FeedParser parser(&file);
    
    parser.readChannel();
    
    qDebug() << "Channel date:" << parser.date();
    qDebug() << "Channel description:" << parser.description();
    qDebug() << "Channel iconUrl:" << parser.iconUrl();
    qDebug() << "Channel title:" << parser.title();
    qDebug() << "Channel url:" << parser.url();
    
    while (parser.readNextArticle()) {
        qDebug() << "Article author:" << parser.author();
        qDebug() << "Article categories:" << parser.categories();
        qDebug() << "Article date:" << parser.date();
        qDebug() << "Article description:" << parser.description();
        qDebug() << "Article enclosures:" << parser.enclosures();
        qDebug() << "Article title:" << parser.title();
        qDebug() << "Article url:" << parser.url();
    }
    
    qDebug() << parser.errorString();
        
    return app.exec();
}
