// checksum 0xcf61 version 0x30002
/*
  This file was generated by the Mobile Qt Application wizard of Qt Creator.
  MainWindow is a convenience class containing mobile device specific code
  such as screen orientation handling.
  It is recommended not to modify this file, since newer versions of Qt Creator
  may offer an updated version of it.
*/

#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "newtaskdialog.h"
#include "todolistmodel.h"

#include <QtCore/QCoreApplication>
#include <QMessageBox>
#include <QDebug>
#include <QStringListModel>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QNetworkRequest>
#include <QOrganizerCollectionFetchRequest>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QDesktopServices>
#include <QDir>

#if defined(Q_WS_MAEMO_5)
#include <alarmd/libalarm.h>
#endif

#define DELAY 30000 // check delay in ms
#define APPID "Cue"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    setWindowTitle(tr(APPID) + "[*]");
    cur_pos = 0;
    todos = 0;
    map_view = 0;
    network_manager = new QNetworkAccessManager;
    createCellIdDB();

    in = new QSystemNetworkInfo();
    connect(in, SIGNAL(cellIdChanged(int)), this, SLOT(cellIdChanged(int)));

    connect(&organizer, SIGNAL(itemsAdded(QList<QOrganizerItemId>)), this, SLOT(itemsChanged(QList<QOrganizerItemId>)));
    // Change event is causing race condition
    connect(&organizer, SIGNAL(itemsChanged(QList<QOrganizerItemId>)), this, SLOT(itemsChanged(QList<QOrganizerItemId>)));
    connect(&organizer, SIGNAL(itemsRemoved(QList<QOrganizerItemId>)), this, SLOT(itemsChanged(QList<QOrganizerItemId>)));
    connect(&timer, SIGNAL(timeout()), this, SLOT(check()));

    fetchReq.setManager(&organizer);
    connect(&fetchReq, SIGNAL(resultsAvailable()), this, SLOT(refreshView()));
    refreshView();
}

MainWindow::~MainWindow()
{
    delete ui;
    delete todos;
    delete cur_pos;
    delete map_view;
    delete network_manager;
}

void MainWindow::setOrientation(ScreenOrientation orientation)
{
#if defined(Q_OS_SYMBIAN)
    // If the version of Qt on the device is < 4.7.2, that attribute won't work
    if (orientation != ScreenOrientationAuto) {
        const QStringList v = QString::fromAscii(qVersion()).split(QLatin1Char('.'));
        if (v.count() == 3 && (v.at(0).toInt() << 16 | v.at(1).toInt() << 8 | v.at(2).toInt()) < 0x040702) {
            qWarning("Screen orientation locking only supported with Qt 4.7.2 and above");
            return;
        }
    }
#endif // Q_OS_SYMBIAN

    Qt::WidgetAttribute attribute;
    switch (orientation) {
#if QT_VERSION < 0x040702
    // Qt < 4.7.2 does not yet have the Qt::WA_*Orientation attributes
    case ScreenOrientationLockPortrait:
        attribute = static_cast<Qt::WidgetAttribute>(128);
        break;
    case ScreenOrientationLockLandscape:
        attribute = static_cast<Qt::WidgetAttribute>(129);
        break;
    default:
    case ScreenOrientationAuto:
        attribute = static_cast<Qt::WidgetAttribute>(130);
        break;
#else // QT_VERSION < 0x040702
    case ScreenOrientationLockPortrait:
        attribute = Qt::WA_LockPortraitOrientation;
        break;
    case ScreenOrientationLockLandscape:
        attribute = Qt::WA_LockLandscapeOrientation;
        break;
    default:
    case ScreenOrientationAuto:
        attribute = Qt::WA_AutoOrientation;
        break;
#endif // QT_VERSION < 0x040702
    };
    setAttribute(attribute, true);
}

void MainWindow::showExpanded()
{
#ifdef Q_OS_SYMBIAN
    showFullScreen();
#elif defined(Q_WS_MAEMO_5)
    showMaximized();
#else
    show();
#endif
}


void MainWindow::positionUpdated(const QGeoPositionInfo &update)
{
    qDebug() << "Current position is" << update.coordinate() << reminders.size();

    QString alarmNote, cmd;
    foreach(QOrganizerTodo todo, reminders) {
        QList<QString> values = todo.description().split("\n");
        if (values.size() < 4) {
            // we didn't create this todo
            qDebug() << "Removed: " << reminders.removeAll(todo);
            continue;
        }

        QGeoCoordinate loc(values.at(1).toDouble(), values.at(2).toDouble());
        double radius = values.at(3).toDouble();
        QGeoBoundingCircle circle(loc, radius);
        if (!values.at(4).isEmpty()) {
            cmd.append(values.at(4));
            cmd.append(";");
        }
        qDebug() << "loc: " << loc;
        qDebug() << "time:" << QDateTime::currentDateTime() << todo.startDateTime() << todo.dueDateTime();
        qDebug() << "date check:" <<(QDate::currentDate() >= todo.startDateTime().date()
                                     && QDate::currentDate() <= todo.dueDateTime().date());
        qDebug() << "time check:" << (QTime::currentTime() >= todo.startDateTime().time()
                                      && QTime::currentTime() <= todo.dueDateTime().time());
//        QTime zero(0,0);
        if (circle.contains(update.coordinate())
                // between dates
                && (QDate::currentDate() >= todo.startDateTime().date())) {
//                    && QDate::currentDate() <= todo.dueDateTime().date())) {
//            if ((todo.startDateTime().time() != zero || todo.dueDateTime().time() != zero)
//                // between time
//                && (todo.startDateTime().time() != zero && QTime::currentTime() >= todo.startDateTime().time())) {
//                    && QTime::currentTime() <= todo.dueDateTime().time()))
//                continue;
            //            if (todo.recurrenceRule().)
            qDebug() << "Removed: " << reminders.removeAll(todo);
            qDebug() << "trigger alarm:" << todo.id();
            alarmNote.append(todo.displayLabel());// + endl;
            todo.setStatus(QOrganizerTodoProgress::StatusComplete);
#if defined(Q_OS_SYMBIAN)
            QOrganizerItemVisualReminder oldReminder =
                    todo.detail(QOrganizerItemVisualReminder::DefinitionName);
            todo.removeDetail(&oldReminder);

            QOrganizerItemVisualReminder reminder;
            reminder.setMessage(todo.displayLabel());
            reminder.setSecondsBeforeStart(0);

            todo.saveDetail(&reminder);
#endif
            organizer.saveItem(&todo);
        }
    }
    if (!alarmNote.isEmpty()) {
        updateAlarm(alarmNote, cmd);
    }
}

void MainWindow::updateAlarm(QString label, QString cmd) {
    qDebug() << "Updating alarm: " << label << cmd;
#if defined(Q_WS_MAEMO_5)
    cookie_t cookie = 0;
    alarm_event_t *eve = 0;
    alarm_action_t *act = 0;

    /* Create alarm event structure, set application
     * identifier and dialog message */
    eve = alarm_event_create();
    alarm_event_set_alarm_appid(eve, APPID);
    QByteArray ba = label.toLocal8Bit();
    const char *c_str = ba.data();
    alarm_event_set_message(eve, c_str);

    /* Use absolute time triggering, show dialog
     * ten seconds from now */
    eve->alarm_time = time(0);

    /* Add stop button action */
    act = alarm_event_add_actions(eve, 1);
    alarm_action_set_label(act, "Stop");
    act->flags |= ALARM_ACTION_WHEN_RESPONDED;
    act->flags |= ALARM_ACTION_TYPE_NOP;

    /* Add snooze button action */
    act = alarm_event_add_actions(eve, 1);
    alarm_action_set_label(act, "Snooze");
    act->flags |= ALARM_ACTION_WHEN_RESPONDED;
    act->flags |= ALARM_ACTION_TYPE_SNOOZE;

    /* Run custom command */
    if (!cmd.isEmpty()) {
        act = alarm_event_add_actions(eve, 1);
        act->flags = ALARM_ACTION_TYPE_EXEC | ALARM_ACTION_WHEN_TRIGGERED;
        alarm_action_set_exec_command(act, cmd.toLocal8Bit().data());
    }

    /* Send the alarm to alarmd */
    cookie = alarmd_event_add(eve);

    /* Free all dynamic memory associated with the
     * alarm event */
    alarm_event_delete(eve);
#endif
}

void MainWindow::check()
{
    qDebug() << "Checking";
    if (reminders.size() == 0) {
        disconnect(in, SIGNAL(cellIdChanged(int)), this, SLOT(cellIdChanged(int)));
        return;
    }

    timer.start(DELAY);
    connect(in, SIGNAL(cellIdChanged(int)), this, SLOT(cellIdChanged(int)));

    if (cur_pos) {
        positionUpdated(*cur_pos);
    } else {
        // Use last connected cellid
        cellIdChanged(0);
    }
}

// Todo created / removed
void MainWindow::itemsChanged(QList<QOrganizerItemId> list) {
    qDebug() << list.size();

    fetchReq.start();
}

void MainWindow::refreshView() {
    QOrganizerItemSortOrder sortOrder;
    sortOrder.setDetailDefinitionName(QOrganizerTodoTime::DefinitionName, QOrganizerTodoTime::FieldStartDateTime);
    QList<QOrganizerItem> entries =
            organizer.items(QOrganizerItemFilter(),  QList<QOrganizerItemSortOrder>() << sortOrder);

    qDebug() << entries.size();
    if (!todos) {
        delete todos;
        reminders.clear();
    }
    todos = new TodoListModel;
    int starttime = DELAY;
    foreach(const QOrganizerItem &item, entries)
    {
        if (item.type() != QOrganizerItemType::TypeTodo)
            continue;

        QOrganizerTodo todo = static_cast<QOrganizerTodo>(item);
        todos->add(item);
        if (todo.status() == QOrganizerTodoProgress::StatusComplete)
            continue;
        qDebug() << todo.id() << todo.startDateTime() << QDateTime::currentDateTime();

        // If start time is in future, sleep.
        if ((starttime == DELAY) && (todo.startDateTime() > QDateTime::currentDateTime())) {
            qDebug("here");
            starttime = QDateTime::currentDateTime().msecsTo(todo.startDateTime());
        }
        if (!reminders.contains(todo)) {
            reminders.insert(reminders.size(), todo);
        }
    }
    qDebug("setting model");
    ui->listView->setModel(todos);
    timer.start(starttime);
    cellIdChanged(0);
}

void MainWindow::on_pushButton_clicked()
{
    NewTaskDialog newTask(this);
    newTask.cur_pos = *cur_pos;
    newTask.map_view = getMapView();
    if (newTask.exec() == QDialog::Accepted) {
        organizer.saveItem(&(newTask.todo));
    }
}

QDeclarativeView* MainWindow::getMapView() {
    if (!map_view) {
        map_view = new QDeclarativeView(this);
        map_view->setScene(new QGraphicsScene(this));
        qDebug("3");
        map_view->engine()->addImportPath(QString("/opt/qtm12/imports"));
        map_view->engine()->addPluginPath(QString("/opt/qtm12/plugins"));
    }
    return map_view;
}

void MainWindow::on_listView_clicked(const QModelIndex &index)
{
    NewTaskDialog newTask(this);
    newTask.cur_pos = *cur_pos;
    newTask.map_view = getMapView();
    qDebug() << *cur_pos;
    QOrganizerItem item = todos->data(index, Qt::EditRole).value<QOrganizerItem>();
    newTask.setTodo(item);
    connect(&newTask, SIGNAL(delClicked(QOrganizerItemId)), this, SLOT(handleDelete(QOrganizerItemId)));
    if (newTask.exec() == QDialog::Accepted) {
        qDebug() << "Edit: " << newTask.todo;
        organizer.saveItem(&(newTask.todo));
    }
}

void MainWindow::handleDelete(QOrganizerItemId id) {
    qDebug() << "button delete" << id;
    organizer.removeItem(id);
}

void MainWindow::replyFinished(QNetworkReply* reply) {
    if (reply->error() != QNetworkReply::NoError)
        return;

    //    QFile file("cellid.xml");
    //    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    //        return;

    QByteArray response = reply->readAll();
//    for (int i = 0; i < response.length(); i++) {
//        qDebug(") << %d <<  %x", i, response.data()[i]);
//    }
    int successful = (GetCode(response, 3));
    qDebug() << "geocode result:" << successful << reply->error();
    if (successful != 0)
        return;
    double lat = GetCode(response, 7) / 1000000;
    double lng = GetCode(response, 11) / 1000000;

/*    QXmlStreamReader xml;
    //    xml.setDevice(reply);  // for file read
    xml.addData(reply->readAll()); // for network read
    QString lat, lng;
    while (!xml.atEnd() && !xml.hasError())
    {
        xml.readNext();
        if (xml.isStartElement())
        {
            QString name = xml.name().toString();
            //            qDebug() << name;
            if (name == "rsp" && xml.attributes().at(0).value() != "ok")
            {
                xml.raiseError(tr("Location not found. Try again"));
            }

            if (name == "cell")
            {
                foreach (QXmlStreamAttribute att, xml.attributes()) {
                    if (att.name() == "lat")
                        lat = att.value().toString();
                    if (att.name() == "lon")
                        lng = att.value().toString();
                }
            }
        }
    }
    qDebug() << lat << lng;

    //    file.close();
    if (xml.hasError())
    {
        qDebug() << "XML error: " << xml.errorString() << endl;
        return;
    }
    */
    delete cur_pos;
    reply->deleteLater();
    cur_pos = new QGeoPositionInfo (QGeoCoordinate(lat, lng),
                                    QDateTime::currentDateTime());
    insertCellIdDB(lat, lng);
    positionUpdated(*cur_pos);

}

bool MainWindow::createCellIdDB() {
    QSqlDatabase defaultDB = QSqlDatabase::addDatabase("QSQLITE", APPID);
    // NOTE: We have to store database file into user home folder in Linux
    QString path(QDir::home().path());
    path.append(QDir::separator()).append(".cue");
    QDir().mkpath(path);
    path.append(QDir::separator()).append(APPID);
    defaultDB.setDatabaseName(path);

    qDebug() << defaultDB.open();
    QSqlQuery query("select * from cellidinfo",
                    defaultDB);
    bool result = false;
    if (query.size() == -1) {
        qDebug() << "create table";
        result = query.exec("create table cellidinfo (lac int, cellid int, lat double, lng double)");
    }
    defaultDB.close();
    qDebug() << "create:" << result;
    return result;
}

bool MainWindow::insertCellIdDB(double lat, double lng) {
    int lac = in->locationAreaCode();
    int cellid = in->cellId();

    QSqlDatabase defaultDB = QSqlDatabase::database(APPID);
    QSqlQuery query(defaultDB);
    query.prepare("insert into cellidinfo (lac, cellid, lat, lng) values(:lac, :cellid, :lat, :lng)");
    query.bindValue(":lac", lac);
    query.bindValue(":cellid", cellid);
    query.bindValue(":lat", lat);
    query.bindValue(":lng", lng);

    bool result = query.exec();
    defaultDB.close();
    qDebug() << "insert:" << result;
    return result;
}

bool MainWindow::queryCellIdDB(int lac, int cellid) {
    QSqlDatabase defaultDB = QSqlDatabase::database(APPID);
    QSqlQuery query(defaultDB);
    query.prepare("SELECT lat, lng FROM cellidinfo WHERE lac=:lac and cellid=:cellid");
    query.bindValue(":lac", lac);
    query.bindValue(":cellid", cellid);
    query.exec();

    bool result = false;
    while (query.next()) {
        double lat = query.value(0).toDouble();
        double lng = query.value(1).toDouble();
        qDebug() << lat << lng;

        delete cur_pos;
        cur_pos = new QGeoPositionInfo (QGeoCoordinate(lat, lng),
                                        QDateTime::currentDateTime());
        positionUpdated(*cur_pos);
        result = true;
        break;
    }
    defaultDB.close();
    qDebug() << "select:" << result;
    return result;
}

void MainWindow::cellIdChanged(int i) {
    qDebug() << "cell id changed";
    if (i == 0)
        i = in->cellId();

    if (queryCellIdDB(in->locationAreaCode(), i))
        return;

    QNetworkAccessManager *manager = network_manager;
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));
    if(in) {
        qDebug() << in->currentMobileCountryCode()
                 << in->currentMobileNetworkCode()
                 << QString::number(in->locationAreaCode())
                 << QString::number(i);

        QUrl u("http://cellid.labs.ericsson.net/xml/lookup");
        u = "http://www.location-api.com/cell/get/";
        u = "http://www.google.com/glm/mmap";
//        u.addQueryItem("mcc", in->currentMobileCountryCode());
//        u.addQueryItem("mnc", in->currentMobileNetworkCode());
//        u.addQueryItem("lac", QString::number( in->locationAreaCode()));
//        u.addQueryItem("cellid", QString::number( i));
        //        u.addQueryItem("key", "PbLUi5t4lWuj3Hmke72bRS2CB997fbPvLa1cGpFn"); // ericcson
//        u.addQueryItem("key", "o6mbro12o9pmt9jomfj3"); // location-api
        qDebug() << u;
//        QNetworkReply *reply = manager->get(QNetworkRequest(u));
        QByteArray str = GetFormPostData(i, in->currentMobileCountryCode().toInt(),
                                         in->currentMobileNetworkCode().toInt(),
                                         in->locationAreaCode());
//        for (int i = 0; i < 80; i++) {
//            qDebug(") << %d <<  %x", i, str.data()[i]);
//        }

        QNetworkRequest request(u);
        request.setHeader(QNetworkRequest::ContentTypeHeader, "application/binary");
        request.setHeader(QNetworkRequest::ContentLengthHeader, 80);
        QNetworkReply *reply = manager->post(request, str);

        QEventLoop loop;
        connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
        loop.exec();

    }
}


void MainWindow::on_actionAbout_triggered()
{
    QMessageBox::about(this, APPID, tr("Developed by Creative Karma"));
}

QByteArray MainWindow::GetFormPostData(int cellTowerId, int mobileCountryCode,
        int mobileNetworkCode, int locationAreaCode)
{
    QByteArray pd;
    pd.resize(80);
    pd.fill(0);
    pd[1] = 21;

    pd[11] = 0x2;
    pd[12] = 0x66;
    pd[13] = 0x72;

    pd[15] = 0xd;
    pd[16] = 0x4e;
    pd[17] = 0x6f;
    pd[18] = 0x6b;
    pd[19] = 0x69;
    pd[20] = 0x61;
    pd[21] = 0x20;
    pd[22] = 0x4e;
    pd[23] = 0x39;
    pd[24] = 0x35;
    pd[25] = 0x20;
    pd[26] = 0x38;
    pd[27] = 0x47;
    pd[28] = 0x42;

    pd[30] = 0x5;
    pd[31] = 0x31;
    pd[32] = 0x2e;
    pd[33] = 0x33;
    pd[34] = 0x2e;
    pd[35] = 0x31;

    pd[37] = 0x3;
    pd[38] = 0x57;
    pd[39] = 0x65;
    pd[40] = 0x62;
    pd[41] = 0x1b;

    pd[53] = 0x3;

//    pd[58] = 0xcb;
//    pd[59] = 0x7c;

//    pd[63] = 0xf5;

    Shift(pd, 56, cellTowerId);
    Shift(pd, 60, locationAreaCode);


    return pd;
}

/// <summary>
/// Shifts specified data in the byte array starting at the specified array index.
/// </summary>
/// <param name="data">The data.</param>
/// <param name="startIndex">The start index.</param>
/// <param name="leftOperand">The left operand.</param>
void MainWindow::Shift(QByteArray& data, int startIndex, int leftOperand)
{
    int rightOperand = 24;

    for (int i = 0; i < 4; i++, rightOperand -= 8)
    {
        data[startIndex++] = ((leftOperand >> rightOperand) & 255);
    }
}

double MainWindow::GetCode(QByteArray& data, int startIndex)
{
    unsigned int hex = 0;
    sscanf(data.mid(startIndex, 4).toHex(), "%X", &hex);
    qDebug() << (data.mid(startIndex, 4).toHex()) << hex;
    return (double) hex;
}
