#include "mapdialog.h"
#include "ui_mapdialog.h"

MapDialog::MapDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);
    setWindowTitle(tr("Choose Location[*]"));

}

int MapDialog::exec() {
    view->setParent(ui->widget);
    QDeclarativeItem *item = qobject_cast<QDeclarativeItem *>(view->rootObject());
    item->setProperty("defaultLatitude", latitude);
    item->setProperty("defaultLongitude", longitude);
    qDebug() << item->property("defaultLatitude");
    qDebug() << item->property("defaultLongitude");
    int result = QDialog::exec();

    latitude = item->property("latitude").toDouble();
    longitude = item->property("longitude").toDouble();
    return result;
}

MapDialog::~MapDialog()
{
    delete ui;
}
