#ifndef TODOLISTMODEL_H
#define TODOLISTMODEL_H

#include <QAbstractListModel>
#include <QOrganizerTodo>
#include <QOrganizerItemId>

QTM_USE_NAMESPACE

Q_DECLARE_METATYPE(QOrganizerItem)

class TodoListModel : public QAbstractListModel
{
    Q_OBJECT
public:
    explicit TodoListModel(QObject *parent = 0);

    int rowCount(const QModelIndex &parent) const;
    QVariant data(const QModelIndex &index, int role) const;
    bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
    void add(const QOrganizerItem &todo);

signals:

public slots:

private:
    QList<QOrganizerItem> todos;

};

#endif // TODOLISTMODEL_H
