import Qt 4.7
import QtMobility.location 1.2
import "common" as Common

Rectangle {
   id: pinchmap

   property double defaultLatitude: 37.69
   property double defaultLongitude: -97.33
   property double latitude: 0
   property double longitude: 0
   property int  defaultZoomLevel: 10

   property alias mapType: map.mapType

   width: 640
   height: 350
   anchors.fill: parent

   Map {
      id: map

      anchors.fill: parent
      zoomLevel: pinchmap.defaultZoomLevel
      plugin: Plugin {
          name: "nokia";
          parameters: [
              PluginParameter { name: "app_id"; value: "APPID" },
              PluginParameter { name: "token"; value: "TOKEN" }
          ]}
      mapType: Map.StreetMap

      center: Coordinate {
         latitude: pinchmap.defaultLatitude
         longitude: pinchmap.defaultLongitude
      }
      onCenterChanged: {
          pinchmap.latitude = map.center.latitude
          pinchmap.longitude = map.center.longitude
      }

      MapImage {
           source:  "resources/marker.png"
           coordinate: Coordinate {
               latitude: pinchmap.defaultLatitude
               longitude: pinchmap.defaultLongitude
           }
           z: 1
       }

   }

/*   PinchArea {
      id: pincharea

      property double __oldZoom

      anchors.fill: parent

      function calcZoomDelta(zoom, percent) {
         return zoom + Math.log(percent)/Math.log(2)
      }

      onPinchStarted: {
         __oldZoom = map.zoomLevel
      }

      onPinchUpdated: {
         map.zoomLevel = calcZoomDelta(__oldZoom, pinch.scale)
      }

      onPinchFinished: {
         map.zoomLevel = calcZoomDelta(__oldZoom, pinch.scale)
      }
   }
*/
   MouseArea {
      id: mousearea

      property bool __isPanning: false
      property int __lastX: -1
      property int __lastY: -1

      anchors.fill : parent

      onPressed: {
         __isPanning = true
         __lastX = mouse.x
         __lastY = mouse.y
      }

      onReleased: {
         __isPanning = false
      }

      onPositionChanged: {
         if (__isPanning) {
            var dx = mouse.x - __lastX
            var dy = mouse.y - __lastY
            map.pan(-dx, -dy)
            __lastX = mouse.x
            __lastY = mouse.y
         }
      }

      onCanceled: {
         __isPanning = false;
      }
   }

   Common.Slider {
       id: zoomSlider;
       minimum: map.minimumZoomLevel;
       maximum: map.maximumZoomLevel;
       opacity: 1
       z: map.z + 1
       anchors {
           bottom: parent.bottom;
           bottomMargin: 50; rightMargin: 5; leftMargin: 5
           left: parent.left
       }
       width: parent.width - anchors.rightMargin - anchors.leftMargin
       value: map.zoomLevel
       onValueChanged: {
           map.zoomLevel = value
       }
   }

   Rectangle {
       width: 50
       height: 50
       radius: 5
       z: 1
       color: Qt.rgba(0, 0, 0, 0.5)
       anchors.margins: 20

        Rectangle {
            width: 20
            height: 20
            radius: 10
            anchors.centerIn: parent
            color: "red"
        }

       MouseArea {
           anchors.fill: parent
           onClicked: {
               map.center.latitude = pinchmap.defaultLatitude
               map.center.longitude = pinchmap.defaultLongitude
           }
       }
   }
}
