#ifndef NEWTASKDIALOG_H
#define NEWTASKDIALOG_H

#include <QDialog>
#include <QFile>
#include <QDebug>
#include <QMessageBox>
#include <QOrganizerTodo>
#include <QXmlStreamReader>
#include <QNetworkReply>

QTM_USE_NAMESPACE

namespace Ui {
    class NewTaskDialog;
}

class NewTaskDialog : public QDialog
{
    Q_OBJECT

public:
    explicit NewTaskDialog(QWidget *parent = 0);
    ~NewTaskDialog();
    QOrganizerTodo todo;
    void setTodo(const QOrganizerTodo &todo);
    void on_buttonBox_accepted1();

signals:
    void delClicked(QOrganizerItemId id);
    void valid(bool valid);

public slots:
    void del();
    void gReplyFinished(QNetworkReply* reply);

private slots:
    void on_buttonBox_clicked(QAbstractButton *button);
    void on_location_textChanged();
    void validAction(bool valid);

    void on_search_clicked();

    void on_date_clicked(bool checked);

    void on_time_clicked(bool checked);

    void on_dateEdit_dateChanged(const QDate &date);

private:
    Ui::NewTaskDialog *ui;
    QXmlStreamReader xml;
    bool valid_data;
    QString lat, lng;

};

#endif // NEWTASKDIALOG_H
