#include "newtaskdialog.h"
#include "ui_newtaskdialog.h"

#include <QPushButton>
#include <QtNetwork/QNetworkAccessManager>
#include <QtNetwork/QNetworkReply>
#include <QtNetwork/QNetworkRequest>
#include <QCloseEvent>

#define RADIUS "1000"
#define EXPIRE_AFTER_DAYS 30

NewTaskDialog::NewTaskDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::NewTaskDialog), valid_data(false)
{
    ui->setupUi(this);
    setWindowTitle(tr("New Task[*]"));

    ui->radius->setText(RADIUS);
    ui->dateEdit->setDateTime(QDateTime::currentDateTime());
//    ui->timeEdit->setDateTime(QDateTime::currentDateTime());
    ui->dateEdit_2->setDateTime(QDateTime::currentDateTime());
//    ui->timeEdit_2->setDateTime(QDateTime::currentDateTime());
    ui->complete->setVisible(false);

    connect(this, SIGNAL(valid(bool)), this, SLOT(validAction(bool)));
}

NewTaskDialog::~NewTaskDialog()
{
    delete ui;
}

void NewTaskDialog::setTodo(const QOrganizerTodo &todo1) {
    qDebug() << "Editing: " << todo1;
    setWindowTitle(tr("Edit Task[*]"));
    todo = todo1;

    ui->task->setText(todo.displayLabel());

    QStringList desc = todo.description().split("\n");
    ui->location->setText(desc.value(0));
    lat = desc.value(1);
    lng = desc.value(2);
    ui->radius->setText(desc.value(3));
    qDebug() << "desc size:" << desc.size();
    if (desc.size() == 4)
        emit valid(true);

    ui->date->setChecked(true);
    on_date_clicked(true);
    ui->dateEdit->setDateTime(todo.startDateTime());
    ui->dateEdit_2->setDateTime(todo.dueDateTime());

    qDebug() << todo.startDateTime().time().isNull();
    QTime zero(0,0);
    if (todo.startDateTime().time() != zero || todo.dueDateTime().time() != zero) {
        ui->time->setChecked(true);
        ui->timeEdit->setEnabled(true);
        ui->timeEdit_2->setEnabled(true);
        ui->timeEdit->setDateTime(todo.startDateTime());
        ui->timeEdit_2->setDateTime(todo.dueDateTime());
    }

    ui->complete->setVisible(true);
    ui->complete->setChecked(todo.status() == QOrganizerTodoProgress::StatusComplete);

    QPushButton *delButton = new QPushButton(tr("Delete"));
    connect(delButton, SIGNAL(clicked()), this, SLOT(del()));
    ui->buttonBox->addButton(delButton, QDialogButtonBox::ActionRole);
}

void NewTaskDialog::on_buttonBox_accepted1()
{
    // Create todo
    todo.setDisplayLabel(ui->task->toPlainText());

    if (ui->date->isChecked())
        todo.setStartDateTime(QDateTime(ui->dateEdit->date(), ui->timeEdit->time()));
    else
        todo.setStartDateTime(QDateTime(QDate::currentDate()));
    if (ui->time->isChecked())
        todo.setDueDateTime(QDateTime(ui->dateEdit_2->date(), ui->timeEdit_2->time()));
    else
        todo.setDueDateTime(QDateTime(QDate::currentDate().addDays(EXPIRE_AFTER_DAYS)));

    QString desc = ui->location->toPlainText() + "\n" + lat + "\n" + lng + "\n" + ui->radius->toPlainText();
    todo.setDescription(desc);
    if (ui->complete->isChecked())
        todo.setStatus(QOrganizerTodoProgress::StatusComplete);
    else
        todo.setStatus(QOrganizerTodoProgress::StatusNotStarted);
    qDebug() << "after edit:" << todo.startDateTime() << todo.dueDateTime();
    if (valid_data)
        QDialog::accept();
//    else
//        on_search_clicked();
}

void NewTaskDialog::del() {
    qDebug() << "in del()";
    emit delClicked(todo.id());
    reject();
}

void NewTaskDialog::on_buttonBox_clicked(QAbstractButton *button)
{

    switch(ui->buttonBox->buttonRole(button)) {
    case QDialogButtonBox::AcceptRole:
        if (ui->task->toPlainText().isEmpty() ||
                ui->location->toPlainText().isEmpty()) {
            QMessageBox error;
            error.setText(tr("Please enter mandatory (*) field(s)."));
            error.exec();
            return;
        }
        if ((ui->date->isChecked() &&
                ui->dateEdit->date() > ui->dateEdit_2->date()) ||
                (ui->time->isChecked() &&
                 ui->timeEdit->time() > ui->timeEdit_2->time())) {
            QMessageBox error;
            error.setText(tr("Please check date/time range."));
            error.exec();
            return;
        }
        on_buttonBox_accepted1();
        break;
    case QDialogButtonBox::RejectRole:
        QDialog::reject();
        break;
    }

}

void NewTaskDialog::gReplyFinished(QNetworkReply* reply) {
    //    QFile file("geocode.xml");
    //    if (!file.open(QIODevice::ReadOnly | QIODevice::Text))
    //        return;

    //    xml.setDevice(&file);
    xml.addData(reply->readAll());
    QString lat, lng, address;
    while (!xml.atEnd() && !xml.hasError())
    {
        xml.readNext();
        if (xml.isStartElement())
        {
            QString name = xml.name().toString();
            //            qDebug() << name;
            if (name == "status" && xml.readElementText() != "OK")
            {
                xml.raiseError(tr("Location not found. Try again"));
            }
            if (name == "formatted_address") {
                address = xml.readElementText();
                qDebug() << address;
            }
            if (name == "location")
            {
                xml.readNextStartElement();
                lat = xml.readElementText();
                xml.readNextStartElement();
                lng = xml.readElementText();
            }
        }
    }

    //    file.close();
    qDebug() << lat << lng;
    if (xml.hasError())
    {
        qDebug() << "XML error: " << xml.errorString() << endl;
        QMessageBox error;
        error.setWindowTitle(tr("Error"));
        error.setText(xml.errorString());
        error.exec();
        return;
    }

    ui->location->setText(address);
    this->lat = lat;
    this->lng = lng;
    qDebug() << "after google request" << todo.id() << todo.startDateTime();
    emit valid(true);
}

void NewTaskDialog::on_search_clicked()
{
    QNetworkAccessManager *manager = new QNetworkAccessManager();
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(gReplyFinished(QNetworkReply*)));

    QUrl url("http://maps.googleapis.com/maps/api/geocode/xml");
    url.addQueryItem("address", ui->location->toPlainText().replace(" ", "+"));
    url.addQueryItem("sensor", "true");
    qDebug() << url;
    QNetworkReply *reply = manager->get(QNetworkRequest(url));

    QEventLoop loop;
    connect(reply, SIGNAL(finished()), &loop, SLOT(quit()));
    loop.exec();

}

void NewTaskDialog::validAction(bool valid) {
    this->valid_data = valid;
    ui->buttonBox->setEnabled(valid);
    ui->search->setEnabled(!valid);
}

void NewTaskDialog::on_location_textChanged()
{
    if (ui->location->toPlainText().isEmpty()) {
        ui->search->setEnabled(false);
        return;
    }

    emit valid(false);
}

void NewTaskDialog::on_date_clicked(bool checked)
{
    ui->dateEdit->setEnabled(checked);
    ui->dateEdit_2->setEnabled(checked);
}

void NewTaskDialog::on_time_clicked(bool checked)
{
    ui->timeEdit->setEnabled(checked);
    ui->timeEdit_2->setEnabled(checked);
    ui->timeEdit->setTime(QTime(0,0));
    ui->timeEdit_2->setTime(QTime(0,0));
}

void NewTaskDialog::on_dateEdit_dateChanged(const QDate &date)
{
    ui->dateEdit_2->setDate(date.addDays(EXPIRE_AFTER_DAYS));
}
