#!/usr/bin/env python
#-*- coding: utf-8 -*-

import sys
import random
import pickle
import os
#import dbus
import subprocess
from PySide import QtCore
from PySide.QtCore import Qt
from PySide import QtGui
from PySide import QtDeclarative
#OpenGL Rendering
from PySide import QtOpenGL

class cubetimer():
	def __init__(self):

		#Oberfläche und Instanzierungen für QML2Py Funktionen		
		self.view = QtDeclarative.QDeclarativeView()

		#OpenGL Rendering
		self.glw = QtOpenGL.QGLWidget()
        	self.view.setViewport(self.glw)

		self.view.setSource(QtCore.QUrl('QML/UI.qml'))	
		self.root = self.view.rootObject()

		# instantiate the Python object
		self.pyfunc = pyfunc()

    		# expose the object to QML
		self.context = self.view.rootContext()
		self.context.setContextProperty("pyfunc", self.pyfunc)
		
		self.view.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)

		#Buttons der UI
		self.scramblebutton = self.root.findChild(QtCore.QObject,"button1")
		self.scramblebutton.clicked.connect(self.reset)

		self.timerbutton = self.root.findChild(QtCore.QObject,"timer_start")
		self.timerbutton.released.connect(self.timer_start)

		self.stopwatchbutton = self.root.findChild(QtCore.QObject,"stopwatch_check_mouse")
		self.stopwatchbutton.clicked.connect(self.stopwatchmode)

		#Vorher auch "stopwatchbutton" - verwirrend daher neuer Name!
		self.inspectionbutton = self.root.findChild(QtCore.QObject,"waittime_check_mouse")
		self.inspectionbutton.clicked.connect(self.waittime)

		self.reset_button = self.root.findChild(QtCore.QObject, "reset_button")
		self.reset_button.clicked.connect(self.time_reset) 

		#Es könnte der Ende Button des Menü's auch wie oben realisiert werden, aktuell wird pyfunc.ende() aus QML heraus angesprochen!
		#self.exitbutton = self.root...		

		#Variable ob der Timer läuft
		self.timer_on = False
		#Variable mit Gesamtzeit
		self.total_time = 0
		#Variable für Timer (hochzählen), Timer2 (runterzählen)
		self.timer = QtCore.QTimer()
		self.timer2 = QtCore.QTimer()
		#Variable für Update/Unterbrecher damit UI weiter reagiert + Zeit in ms 
        	self.timer.setInterval(10)
		self.timer2.setInterval(500)
		#Gibt an was ausgeführt wird wenn der Interval abgelaufen ist!
        	self.timer.timeout.connect(self.update_time)
		self.timer2.timeout.connect(self.update_wait_time)
		#Zeitnehmer
        	self.zeit = QtCore.QTime()

		self.inspectionmode = None
		self.stopwatchmode = None
		
#--------------------------------------------------------------------------------------------------

		#Setting von ersten Werten auf Oberfläche Zeiten, Stopwatch-Modus, Inspection-Time		
		self.settings()
		self.scrambler()
		self.backlighter() #Not very nice - cause also implementable with dbus
		
#--------------------------------------------------------------------------------------------------
	#Funktionen des Programms/Python-Logik

	def settings(self):
		if os.path.isfile('/home/user/.config/cubetimer.cfg') == True:
			print "cfg war schon da"
			#Laden der gespeicherten Werte
			f = open("/home/user/.config/cubetimer.cfg")
			l = pickle.load(f)

		else:
			print "cfg wird erstellt"
			f = open("/home/user/.config/cubetimer.cfg", "w")
			pickle.dump({"stopwatch": False ,"inspection": False, "record":0 ,"average":0,"last":0,"averagetimeaddion": 0, "averagedivider": 1}, f)
			f = open("/home/user/.config/cubetimer.cfg")
			l = pickle.load(f)

		#Stopuhr-Setting lesen und bestimmen
		self.stopwatchmode = l["stopwatch"]
		self.root.stopwatchsetting(str(self.stopwatchmode))

		#Inspection-Setting lesen und bestimmen
		self.inspectionmode = l["inspection"]
		self.root.inspectionsetting(str(self.inspectionmode))

		#einlesen der Zeiten
		rec = l["record"]
		ave = l["average"]
		last = l["last"]

		#Zuordnung der Variablen und Umwandlung in MIN:SEC:MS Format
		record = self.time_transformer(rec)
		average = self.time_transformer(ave)
		last = self.time_transformer(last)
		
		#Schreiben der Zeitwerte
		self.root.record_time("best: %s" % record)
		self.root.average_time("average: %s" % average)
		self.root.last_time("last: %s" % last)

#--------------------------------------------------------------------------------------------------

	#Umwandlung in MIN:SEC:MS
	def time_transformer(self, ms):
        	ms /= 10
		hundredthseconds = ms % 100
		ms /= 100
		seconds = ms % 60
		ms /= 60
		minutes = ms % 60
		
		ms = '%02d:%02d:%02d' % (minutes, seconds, hundredthseconds)
		return ms

#--------------------------------------------------------------------------------------------------
	
	# Notationen werden zufällig gezogen und dann auf die ersten beiden Linien geschrieben - die 2 Linien kommen durch Schriftgröße/Platz.
	# Es können auch andere Notationen, oder zusätzliche in die Liste eingetragen werden! ;)	
	def scrambler(self):
		notationsU = ["U  ","U'  ","U2  "]
		notationsD = ["D  ","D'  ","D2  "]
		notationsR = ["R  ","R'  ","R2  "]
		notationsL = ["L  ","L'  ","L2  "]
		notationsF = ["F  ","F'  ","F2  "]
		notationsB = ["B  ","B'  ","B2  "]

		scrambled = []
		counter = 0
		while counter < 30:
			
			i = random.choice(notationsU)
			scrambled.append(i)
			counter += 1

			i = random.choice(notationsD)
			scrambled.append(i)
			counter += 1

			i = random.choice(notationsR)
			scrambled.append(i)
			counter += 1

			i = random.choice(notationsL)
			scrambled.append(i)
			counter += 1

			i = random.choice(notationsF)
			scrambled.append(i)
			counter += 1

			i = random.choice(notationsB)
			scrambled.append(i)
			counter += 1

		#Bestimmen der ersten 15 und zweiten 15 Notationen
		scrambled1 = scrambled[0:14]
		scrambled2 = scrambled[14:29]

		scrambled1 = "%s" % "".join(scrambled1)
		scrambled2 = "%s" % "".join(scrambled2)

		#Ausgabe auf der UI
		self.root.scrambler(scrambled1)
		self.root.scrambler2(scrambled2)

		#Nullen des Timers beim Start sowie beim drücken des Reload-Button
		self.root.timerUpdate("00:00:00")

#--------------------------------------------------------------------------------------------------	

	#Thanks to Boris Pohlers, for help with the stopwatch and hint to QTimer.
	#Timer starten/stoppen!
	def timer_start(self):
		if self.inspectionmode == True:
			if self.timer_on == True:
				self.timer_start_stop()

			else:
				zeit = self.time_transformer(15000)
				self.root.timerUpdate(zeit)

				self.zeit.start()
				self.timer2.start()
		else:
			self.timer_start_stop()
			
#--------------------------------------------------------------------------------------------------

	def timer_start_stop(self):
		if self.timer_on == False:
			self.timer_on = True		
			self.zeit.start()
        		self.timer.start()
			return self.timer_on
	
		elif self.timer_on == True:
			self.timer_on = False
			self.total_time = self.total_time + self.zeit.elapsed()
        		self.timer.stop()
			self.save_times(self.total_time)
			return self.timer_on

#--------------------------------------------------------------------------------------------------

	#Updaten der Zeitangabe für die QML UI
	def update_time(self):
		milliseconds = self.total_time + self.zeit.elapsed()
        	milliseconds /= 10
		hundredthseconds = milliseconds % 100
		milliseconds /= 100
		seconds = milliseconds % 60
		milliseconds /= 60
		minutes = milliseconds % 60
		
        	self.root.timerUpdate('%02d:%02d:%02d' % (minutes, seconds, hundredthseconds))	

#--------------------------------------------------------------------------------------------------

	def save_times(self, zeit):
		#Die Zeiten sollen natürlich nicht gespeichert werden, wenn der User im Stopuhr Modus ist!		
		if self.stopwatchmode == False:
			#Laden der gespeicherten Daten
			f = open("/home/user/.config/cubetimer.cfg")
			l = pickle.load(f)

			#Einlesen der Zeiten und Berechnung! "last" ist die letzte Zeit, der Durchschnitt ergibt sich aus allen jemals gespielten Zeiten.
			#Diese werden einfach aufaddiert in "averagetimeaddion" geteilt durch die Anzahl aller je gespielten Spiele "averagedivider".	
			l["last"] = zeit
			l["average"] = ((l["averagetimeaddion"]+int(zeit))/l["averagedivider"])
			l["averagetimeaddion"] = (l["averagetimeaddion"]+int(zeit*1.0))
			l["averagedivider"] += 1
		
			# Kontrolle ob neue Zeit auch neuer Rekord ist!
			if l["record"] == 0:
				l["record"] = zeit

			elif zeit < l["record"]:
				l["record"] = zeit

			#Speichern der Daten
			f = open("/home/user/.config/cubetimer.cfg", "w")
			pickle.dump(l,f)

		else:
			pass
		
#--------------------------------------------------------------------------------------------------

	def reset(self):
		self.timer_on = False
        	self.timer.stop()
		self.settings()
		self.total_time = 0
		self.scrambler()

#--------------------------------------------------------------------------------------------------

	def time_reset(self):
		f = open("/home/user/.config/cubetimer.cfg", "w")
		pickle.dump({"stopwatch": False ,"inspection": False, "record":0 ,"average":0,"last":0,"averagetimeaddion": 0, "averagedivider": 1}, f)
		self.settings()

#--------------------------------------------------------------------------------------------------

	def stopwatchmode(self):
		if self.stopwatchmode == False:
			self.stopwatchmode = True
			self.root.stopwatchsetting(str(self.stopwatchmode))
		else:
			self.stopwatchmode = False
			self.root.stopwatchsetting(str(self.stopwatchmode))

		#Laden der gespeicherten Daten
		f = open("/home/user/.config/cubetimer.cfg")
		l = pickle.load(f)

		l["stopwatch"] = self.stopwatchmode
		
		#Speichern der Daten
		f = open("/home/user/.config/cubetimer.cfg", "w")
		pickle.dump(l,f)

#--------------------------------------------------------------------------------------------------
	
	def waittime(self):
		if self.inspectionmode == False:
			self.inspectionmode = True
			self.root.inspectionsetting(str(self.inspectionmode))
		else:
			self.inspectionmode = False
			self.root.inspectionsetting(str(self.inspectionmode))

		#Laden der gespeicherten Daten
		f = open("/home/user/.config/cubetimer.cfg")
		l = pickle.load(f)

		l["inspection"] = self.inspectionmode
		
		#Speichern der Daten
		f = open("/home/user/.config/cubetimer.cfg", "w")
		pickle.dump(l,f)

#--------------------------------------------------------------------------------------------------

	def update_wait_time(self):
		waittime = 15000
		milliseconds = waittime - self.zeit.elapsed()
	        milliseconds /= 10
		hundredthseconds = milliseconds % 100
		milliseconds /= 100
		seconds = milliseconds % 60
		milliseconds /= 60
		minutes = milliseconds % 60
		
		if waittime-self.zeit.elapsed() <= 0:
			print "STOP"
			self.timer2.stop()
			self.timer_start_stop()

	        self.root.timerUpdate('%02d:%02d:%02d' % (minutes, seconds, hundredthseconds))

#-------------------------------------------------------------------------------------------------
#DBUS für Display Helligkeit:
#dbus-send --system --type=method_call --print-reply --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.req_display_blanking_pause
	def backlighter(self):
		subprocess.Popen(['dbus-send', '--system', '--type=method_call', '--print-reply', '--dest=com.nokia.mce','/com/nokia/mce/request', 'com.nokia.mce.request.req_display_blanking_pause'])



#!/bin/bash
#for i in $(seq 0 20); do
#dbus-send --system --type=method_call --print-reply --dest=com.nokia.mce /com/nokia/mce/request com.nokia.mce.request.req_display_blanking_pause 
#sleep 30
#done

#--------------------------------------------------------------------------------------------------

# Klasse für Funktionen die aus QML heraus angesprochen werden sollen:
class pyfunc(QtCore.QObject):
	#Beenden Funktion
	@QtCore.Slot()
	def ende(self):
		exit()

	@QtCore.Slot()
	def minimize(self):
        #Thanks to Boris Pohlers PyQt Toolbox, cause I've found it there! :)
        	subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])

#--------------------------------------------------------------------------------------------------

if __name__ == '__main__':
	app = QtGui.QApplication(sys.argv)
	start = cubetimer()
	start.view.showFullScreen()
    	sys.exit(app.exec_())
