#include <QtGui>
#include "mainwindow.h"
#include "ui_mainwindow.h"

mainwindow::mainwindow(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::mainwindow)
{
    
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
    
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);

    if (!QFile::exists("/opt/cssutransitionstuner/cssuinstalled")) {
        ui->blurless->setDisabled(true);
        ui->forcerotation->setDisabled(true);
        ui->parallax->setDisabled(true);
        ui->zaxis->setDisabled(true);
        ui->tactile->setDisabled(true);
        ui->taskswitcher->setDisabled(true);
        ui->zoomonpress->setDisabled(true);
    }

    if (!QFile::exists("/opt/cssutransitionstuner/tactileinstalled")) {
        ui->tactile->setDisabled(true);
    }
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
    orientationChanged();
    readvalues();
    abouttext = "CSSU Transitions Tuner ver. 0.0.7<br /><br />Auhtor: d-iivil<br />Licence: GPL";
}

mainwindow::~mainwindow()
{
    delete ui;
}

void mainwindow::orientationChanged()
{
     QRect screenGeometry = QApplication::desktop()->screenGeometry();
     if (screenGeometry.width() > screenGeometry.height())
     {
         ui->widget_bot->setVisible(false);
         ui->widget_right->setVisible(true);

         //ui->listWidget->setMaximumWidth(720);
     }
     else
     {
         ui->widget_bot->setVisible(true);
         ui->widget_right->setVisible(false);
     }

}

void mainwindow::readvalues()
{
    QString path;

    if (QFile::exists("/etc/hildon/theme/transitions.ini")) {
        path = "/etc/hildon/theme/transitions.ini";
    } else {
        path = "/usr/share/hildon-desktop/transitions.ini";
    }

    QSettings settings(path, QSettings::IniFormat);

    settings.beginGroup("thp_tweaks");

    if (settings.contains("blurless")) {
        QString blurless = settings.value("blurless").toString();
        if (blurless == "1") ui->blurless->setChecked(true);
    }

    if (settings.contains("taskswitcher")) {
        int taskswitcherint = settings.value("taskswitcher").toInt();
        ui->taskswitcher->setCurrentIndex(taskswitcherint);
    }

    if (settings.contains("zaxisrotation")) {
        QString zaxisrotation = settings.value("zaxisrotation").toString();
        if (zaxisrotation == "1") ui->zaxis->setChecked(true);
    }

    if (settings.contains("forcerotation")) {
        QString forcerotation = settings.value("forcerotation").toString();
        if (forcerotation == "1") ui->forcerotation->setChecked(true);
    }

    if (settings.contains("tactilepopups")) {
        QString tactilepopups = settings.value("tactilepopups").toString();
        if (tactilepopups == "1") ui->tactile->setChecked(true);
    }

     settings.endGroup();

     settings.beginGroup("home");

        if (settings.contains("zoom_on_press")) {
        QString zoom_on_press = settings.value("zoom_on_press").toString();
        if (zoom_on_press == "1") ui->zoomonpress->setChecked(true);
    }


        if (settings.contains("parallax")) {
        QString parallax = settings.value("parallax").toString();
        double parallaxdouble = parallax.replace('.', ',').toDouble();
        ui->parallax->setValue(parallaxdouble);
        }

        if (settings.contains("radius_more")) {
        QString radius_more = settings.value("radius_more").toString();
        int radius_moreint = radius_more.toInt();
        ui->blur->setValue(radius_moreint);
        }


     settings.endGroup();

     settings.beginGroup("launcher_in");
     int speed = settings.value("duration").toInt();
     if (speed <= 50) {
         ui->speed->setCurrentIndex(0);
     } else if (speed >= 51 && speed <= 100) {
         ui->speed->setCurrentIndex(1);
     } else if (speed >= 101 && speed <= 300) {
         ui->speed->setCurrentIndex(2);
     } else if (speed >= 301 && speed <= 400) {
         ui->speed->setCurrentIndex(3);
     } else if (speed >= 401) {
         ui->speed->setCurrentIndex(4);
     }
     settings.endGroup();

}

void mainwindow::storevalues()
{
    QString path2 = "/usr/share/hildon-desktop/transitions.ini";

    if (QFile::exists("/etc/hildon/theme/transitions.ini")) {

    path2 = "/etc/hildon/theme/transitions.ini";
    system("perl -pi -e \"s/#/;/g\" /etc/hildon/theme/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration=.*/duration=50/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration=.*/duration=100/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration=.*/duration=300/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration=.*/duration=400/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration=.*/duration=500/g\" /etc/hildon/theme/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration_in=.*/duration_in=50/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration_in=.*/duration_in=100/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration_in=.*/duration_in=300/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration_in=.*/duration_in=400/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration_in=.*/duration_in=500/g\" /etc/hildon/theme/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration_out=.*/duration_out=50/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration_out=.*/duration_out=100/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration_out=.*/duration_out=300/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration_out=.*/duration_out=400/g\" /etc/hildon/theme/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration_out=.*/duration_out=500/g\" /etc/hildon/theme/transitions.ini");

    }

    QString path = "/usr/share/hildon-desktop/transitions.ini";
    system("perl -pi -e \"s/#/;/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration=.*/duration=50/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration=.*/duration=100/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration=.*/duration=300/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration=.*/duration=400/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration=.*/duration=500/g\" /usr/share/hildon-desktop/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration_in=.*/duration_in=50/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration_in=.*/duration_in=100/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration_in=.*/duration_in=300/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration_in=.*/duration_in=400/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration_in=.*/duration_in=500/g\" /usr/share/hildon-desktop/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration_out=.*/duration_out=50/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration_out=.*/duration_out=100/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration_out=.*/duration_out=300/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration_out=.*/duration_out=400/g\" /usr/share/hildon-desktop/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration_out=.*/duration_out=500/g\" /usr/share/hildon-desktop/transitions.ini");

    QString path3 = "/usr/share/hildon-desktop/transitions.ini";
    if (QFile::exists("/opt/theme-customizer/transitions.ini")) {
    path3 = "/opt/theme-customizer/transitions.ini";
    system("perl -pi -e \"s/#/;/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration=.*/duration=50/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration=.*/duration=100/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration=.*/duration=300/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration=.*/duration=400/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration=.*/duration=500/g\" /opt/theme-customizer/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration_in=.*/duration_in=50/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration_in=.*/duration_in=100/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration_in=.*/duration_in=300/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration_in=.*/duration_in=400/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration_in=.*/duration_in=500/g\" /opt/theme-customizer/transitions.ini");

    if (ui->speed->currentIndex() == 0) system("perl -pi -e \"s/duration_out=.*/duration_out=50/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 1) system("perl -pi -e \"s/duration_out=.*/duration_out=100/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 2) system("perl -pi -e \"s/duration_out=.*/duration_out=300/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 3) system("perl -pi -e \"s/duration_out=.*/duration_out=400/g\" /opt/theme-customizer/transitions.ini");
    if (ui->speed->currentIndex() == 4) system("perl -pi -e \"s/duration_out=.*/duration_out=500/g\" /opt/theme-customizer/transitions.ini");
    }

    QSettings settings(path, QSettings::IniFormat);
    QSettings settings2(path2, QSettings::IniFormat);
    QSettings settings3(path3, QSettings::IniFormat);

    settings.beginGroup("thp_tweaks");

    if (settings.contains("blurless")) {
        if ( ui->blurless->checkState() == Qt::Checked ) {
            settings.setValue("blurless","1");
        } else {
            settings.setValue("blurless","0");
        }
    }

    if (settings.contains("taskswitcher")) {
        settings.setValue("taskswitcher", ui->taskswitcher->currentIndex());
    }

    if (settings.contains("zaxisrotation")) {
        if ( ui->zaxis->checkState() == Qt::Checked ) {
            settings.setValue("zaxisrotation", "1");
        } else {
            settings.setValue("zaxisrotation", "0");
        }
    }

    if (settings.contains("tactilepopups")) {
        if ( ui->tactile->checkState() == Qt::Checked ) {
            settings.setValue("tactilepopups", "1");
        } else {
            settings.setValue("tactilepopups", "0");
        }
    }

    if (settings.contains("forcerotation")) {
        if ( ui->forcerotation->checkState() == Qt::Checked ) {
            settings.setValue("forcerotation", "1");
        } else {
            settings.setValue("forcerotation", "0");
        }
    }


     settings.endGroup();

     settings.beginGroup("home");

     if (settings.contains("zoom_on_press")) {
        if ( ui->zoomonpress->checkState() == Qt::Checked ) {
            settings.setValue("zoom_on_press", "1");
        } else {
            settings.setValue("zoom_on_press", "0");
        }
     }

     if (settings.contains("parallax")) {
         double parallaxint = ui->parallax->value();
         QString parallax = QString::number(parallaxint);
         parallax.replace(',', '.');
        // QMaemo5InformationBox::information(this, parallax, QMaemo5InformationBox::DefaultTimeout);
        settings.setValue("parallax", parallax);
    }

     if (settings.contains("radius_more")) {
         int radius_moreint = ui->blur->value();
         QString radius_more = QString::number(radius_moreint);
      //   parallax.replace(',', '.');
        // QMaemo5InformationBox::information(this, parallax, QMaemo5InformationBox::DefaultTimeout);
        settings.setValue("radius_more", radius_more);
    }

     settings.endGroup();

     settings2.beginGroup("thp_tweaks");

     if (settings2.contains("blurless")) {
         if ( ui->blurless->checkState() == Qt::Checked ) {
             settings2.setValue("blurless","1");
         } else {
             settings2.setValue("blurless","0");
         }
     }

     if (settings2.contains("taskswitcher")) {
         settings2.setValue("taskswitcher", ui->taskswitcher->currentIndex());
     }

     if (settings2.contains("zaxisrotation")) {
         if ( ui->zaxis->checkState() == Qt::Checked ) {
             settings2.setValue("zaxisrotation", "1");
         } else {
             settings2.setValue("zaxisrotation", "0");
         }
     }

     if (settings2.contains("forcerotation")) {
         if ( ui->forcerotation->checkState() == Qt::Checked ) {
             settings2.setValue("forcerotation", "1");
         } else {
             settings2.setValue("forcerotation", "0");
         }
     }

     if (settings2.contains("tactilepopups")) {
         if ( ui->tactile->checkState() == Qt::Checked ) {
             settings2.setValue("tactilepopups", "1");
         } else {
             settings2.setValue("tactilepopups", "0");
         }
     }


      settings2.endGroup();

      settings2.beginGroup("home");

      if (settings2.contains("zoom_on_press")) {
         if ( ui->zoomonpress->checkState() == Qt::Checked ) {
             settings2.setValue("zoom_on_press", "1");
         } else {
             settings2.setValue("zoom_on_press", "0");
         }
      }


   //      double parallaxdouble = ui->parallax->value();
      if (settings2.contains("parallax")) {
          double parallaxint = ui->parallax->value();
          QString parallax = QString::number(parallaxint);
          parallax.replace(',', '.');
         settings2.setValue("parallax", parallax);
     }

      if (settings2.contains("radius_more")) {
          int radius_moreint = ui->blur->value();
          QString radius_more = QString::number(radius_moreint);
       //   parallax.replace(',', '.');
         // QMaemo5InformationBox::information(this, parallax, QMaemo5InformationBox::DefaultTimeout);
         settings2.setValue("radius_more", radius_more);
     }

      settings2.endGroup();

      settings3.beginGroup("thp_tweaks");

      if (settings3.contains("blurless")) {
          if ( ui->blurless->checkState() == Qt::Checked ) {
              settings3.setValue("blurless","1");
          } else {
              settings3.setValue("blurless","0");
          }
      }

      if (settings3.contains("taskswitcher")) {
          settings3.setValue("taskswitcher", ui->taskswitcher->currentIndex());
      }

      if (settings3.contains("zaxisrotation")) {
          if ( ui->zaxis->checkState() == Qt::Checked ) {
              settings3.setValue("zaxisrotation", "1");
          } else {
              settings3.setValue("zaxisrotation", "0");
          }
      }

      if (settings3.contains("forcerotation")) {
          if ( ui->forcerotation->checkState() == Qt::Checked ) {
              settings3.setValue("forcerotation", "1");
          } else {
              settings3.setValue("forcerotation", "0");
          }
      }

      if (settings3.contains("tactilepopups")) {
          if ( ui->tactile->checkState() == Qt::Checked ) {
              settings3.setValue("tactilepopups", "1");
          } else {
              settings3.setValue("tactilepopups", "0");
          }
      }


       settings3.endGroup();

       settings3.beginGroup("home");

       if (settings3.contains("zoom_on_press")) {
          if ( ui->zoomonpress->checkState() == Qt::Checked ) {
              settings3.setValue("zoom_on_press", "1");
          } else {
              settings3.setValue("zoom_on_press", "0");
          }
       }


    //      double parallaxdouble = ui->parallax->value();
       if (settings3.contains("parallax")) {
          double parallaxint = ui->parallax->value();
          QString parallax = QString::number(parallaxint);
          parallax.replace(',', '.');
          settings3.setValue("parallax", parallax);
      }

       if (settings3.contains("radius_more")) {
           int radius_moreint = ui->blur->value();
           QString radius_more = QString::number(radius_moreint);
        //   parallax.replace(',', '.');
          // QMaemo5InformationBox::information(this, parallax, QMaemo5InformationBox::DefaultTimeout);
          settings3.setValue("radius_more", radius_more);
      }

       settings3.endGroup();


}
void mainwindow::on_pushButton_clicked()
{
    ui->pushButton->setDisabled(true);
    // sleep(1);
    storevalues();
    // QMaemo5InformationBox::information(this, tr("Settings saved."), QMaemo5InformationBox::DefaultTimeout);
    //QMaemo5InformationBox::information(this, tr("Transitions updated!") +  "<br /><br />" + tr("Some changes requires restarting the device to activate them."), QMaemo5InformationBox::NoTimeout);

    QMessageBox msgBox;
    msgBox.setWindowTitle("CSSU Transitions Tuner");
    msgBox.setText("Transitions updated! <br /><br />Reboot is required to activate all changes.");
    msgBox.exec();

    ui->pushButton->setEnabled(true);
}

void mainwindow::on_pushButton_2_clicked()
{
    QMessageBox msgBox;
    msgBox.setWindowTitle("CSSU Transitions Tuner");
    msgBox.setText(abouttext);
    msgBox.exec();
}

void mainwindow::on_pushButton_3_clicked()
{
    ui->pushButton->setDisabled(true);
    // sleep(1);
    storevalues();
    // QMaemo5InformationBox::information(this, tr("Settings saved."), QMaemo5InformationBox::DefaultTimeout);
    //QMaemo5InformationBox::information(this, tr("Transitions updated!") +  "<br /><br />" + tr("Some changes requires restarting the device to activate them."), QMaemo5InformationBox::NoTimeout);

    QMessageBox msgBox;
    msgBox.setWindowTitle("CSSU Transitions Tuner");
    msgBox.setText("Transitions updated! <br /><br />Reboot is required to activate all changes.");
    msgBox.exec();

    ui->pushButton->setEnabled(true);
}

void mainwindow::on_pushButton_5_clicked()
{
    QMessageBox msgBox;
    msgBox.setWindowTitle("CSSU Transitions Tuner");
    msgBox.setText(abouttext);
    msgBox.exec();
}
