
;@ Dave's Cyclone 68000 Emulator v0.086 - Assembler Output

;@ (c) Copyright 2003 Dave, All rights reserved.
;@ some code (c) Copyright 2005-2006 notaz, All rights reserved.
;@ Cyclone 68000 is free for non-commercial use.

;@ For commercial use, separate licencing terms must be obtained.

  .global CycloneInit
  .global CycloneRun
  .global CycloneSetSr
  .global CycloneGetSr
  .global CycloneVer
CycloneVer: .long 0x0086

;@ --------------------------- Framework --------------------------
CycloneRun:
  stmdb sp!,{r4-r11,lr}
  mov r7,r0          ;@ r7 = Pointer to Cpu Context
                     ;@ r0-3 = Temporary registers
  ldrb r9,[r7,#0x46] ;@ r9 = Flags (NZCV)
  ldr r6,=JumpTab    ;@ r6 = Opcode Jump table
  ldr r5,[r7,#0x5c]  ;@ r5 = Cycles
  ldr r4,[r7,#0x40]  ;@ r4 = Current PC + Memory Base
                     ;@ r8 = Current Opcode
  mov r9,r9,lsl #28  ;@ r9 = Flags 0xf0000000, cpsr format
                     ;@ r10 = Source value / Memory Base

;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts0
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts0:

;@ Check if our processor is in stopped state
  ldr r0,[r7,#0x58]
  tst r0,r0 ;@ stopped?
  movne r0,#0
  strne r0,[r7,#0x5C]  ;@ eat all cycles
  ldmneia sp!,{r4-r11,pc} ;@ we are stopped, do nothing!

;@ Check if interrupt used up all the cycles:
  subs r5,r5,#0
  blt CycloneEndNoBack

  ldrh r8,[r4],#2 ;@ Fetch first opcode
  ldr pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  .ltorg

;@ We come back here after execution
CycloneEnd:
  sub r4,r4,#2
CycloneEndNoBack:
  mov r9,r9,lsr #28
  str r4,[r7,#0x40]  ;@ Save Current PC + Memory Base
  str r5,[r7,#0x5c]  ;@ Save Cycles
  strb r9,[r7,#0x46] ;@ Save Flags (NZCV)
  ldmia sp!,{r4-r11,pc}

;@ uncompress jump table
CycloneInit:
  ldr r12,=JumpTab
  add r0,r12,#0xe000*4 ;@ ctrl code pointer
  ldr r1,[r0,#-4]
  tst r1,r1
  movne pc,lr ;@ already uncompressed
  add r3,r12,#0xa000*4 ;@ handler table pointer, r12=dest
unc_loop:
  ldrh r1,[r0],#2
  and r2,r1,#0xf
  bic r1,r1,#0xf
  ldr r1,[r3,r1,lsr #2] ;@ r1=handler
  cmp r2,#0xf
  addeq r2,r2,#1 ;@ 0xf is really 0x10
  tst r2,r2
  ldreqh r2,[r0],#2 ;@ counter is in next word
  tst r2,r2
  beq unc_finish ;@ done decompressing
  tst r1,r1
  addeq r12,r12,r2,lsl #2 ;@ 0 handler means we should skip those bytes
  beq unc_loop
unc_loop_in:
  subs r2,r2,#1
  str r1,[r12],#4
  bgt unc_loop_in
  b unc_loop
unc_finish:
  ldr r12,=JumpTab
  ;@ set a-line and f-line handlers
  add r0,r12,#0xa000*4
  ldr r1,[r0,#4] ;@ a-line handler
  ldr r3,[r0,#8] ;@ f-line handler
  mov r2,#0x1000
unc_fill3:
  subs r2,r2,#1
  str r1,[r0],#4
  bgt unc_fill3
  add r0,r12,#0xf000*4
  mov r2,#0x1000
unc_fill4:
  subs r2,r2,#1
  str r3,[r0],#4
  bgt unc_fill4
  bx lr
  .ltorg

CycloneSetSr:
  mov r2,r1,lsr #8
  ldrb r3,[r0,#0x44] ;@ get SR high
  eor r3,r3,r2
  tst r3,#0x20
  and r2,r2,#0xa7 ;@ only nonzero bits
  strb r2,[r0,#0x44] ;@ set SR high
  bne setsr_noswap
  ldr r2,[r0,#0x3C] ;@ Get A7
  ldr r3,[r0,#0x48] ;@ Get OSP
  str r3,[r0,#0x3C]
  str r2,[r0,#0x48]
setsr_noswap:
  mov r2,r1,lsr #3
  strb r2,[r0,#0x45] ;@ the X flag
  bic r2,r1,#0xf3
  tst r1,#1
  orrne r2,r2,#2
  tst r1,#2
  orrne r2,r2,#1
  strb r2,[r0,#0x46] ;@ flags
  bx lr

CycloneGetSr:
  ldrb r1,[r0,#0x46] ;@ flags
  bic r2,r1,#0xf3
  tst r1,#1
  orrne r2,r2,#2
  tst r1,#2
  orrne r2,r2,#1
  ldrb r1,[r0,#0x45] ;@ the X flag
  tst r1,#2
  orrne r2,r2,#0x10
  ldrb r1,[r0,#0x44] ;@ the SR high
  orr r0,r2,r1,lsl #8
  bx lr

;@ DoInterrupt - r0=IRQ number
DoInterrupt:
  stmdb sp!,{lr} ;@ Push ARM return address
;@ Get IRQ Vector address:
  mov r0,r0,asl #2
  add r11,r0,#0x60
;@ swap OSP <-> A7?
  ldrb r0,[r7,#0x44] ;@ Get SR high
  tst r0,#0x20
  bne no_sp_swap1
;@ swap OSP and A7:
  ldr r0,[r7,#0x3C] ;@ Get A7
  ldr r1,[r7,#0x48] ;@ Get OSP
  str r1,[r7,#0x3C]
  str r0,[r7,#0x48]
no_sp_swap1:
  ldr r10,[r7,#0x60] ;@ Get Memory base
  mov r1,r4,lsl #8
  sub r1,r1,r10,lsl #8 ;@ r1 = Old PC
  mov r1,r1,asr #8 ;@ push sign extended
;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Push SR:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  ldr r0,[r7,#0x3c]
  sub r0,r0,#2 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  mov r0,r11
;@ Read IRQ Vector:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  tst r0,r0 ;@ uninitialized int vector?
  moveq r0,#0x3c
  moveq lr,pc
  ldreq pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r0,r0,r10 ;@ r0 = Memory Base + New PC
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrb r0,[r7,#0x47] ;@ IRQ
  orr r1,r0,#0x20 ;@ Supervisor mode + IRQ number
  strb r1,[r7,#0x44] ;@ Put SR high
;@ Clear stopped states:
  mov r1,#0
  str r1,[r7,#0x58]
  sub r5,r5,#44 ;@ Subtract cycles

;@ Clear irq:
  strb r1,[r7,#0x47]
  ldmia sp!,{pc} ;@ Return

Exception:

  stmdb sp!,{lr} ;@ Preserve ARM return address
  ;@ Cause an Exception - Vector address in r0
  mov r11,r0
;@ swap OSP <-> A7?
  ldrb r0,[r7,#0x44] ;@ Get SR high
  tst r0,#0x20
  bne no_sp_swap0
;@ swap OSP and A7:
  ldr r0,[r7,#0x3C] ;@ Get A7
  ldr r1,[r7,#0x48] ;@ Get OSP
  str r1,[r7,#0x3C]
  str r0,[r7,#0x48]
no_sp_swap0:
  ldr r10,[r7,#0x60] ;@ Get Memory base
  mov r1,r4,lsl #8
  sub r1,r1,r10,lsl #8 ;@ r1 = Old PC
  mov r1,r1,asr #8 ;@ push sign extended
;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Push SR:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  ldr r0,[r7,#0x3c]
  sub r0,r0,#2 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  mov r0,r11
;@ Read IRQ Vector:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r0,r0,r10 ;@ r0 = Memory Base + New PC
  mov lr,pc
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrb r0,[r7,#0x44] ;@ Get SR high
  bic r0,r0,#0xd8 ;@ clear trace and unused flags
  orr r0,r0,#0x20 ;@ set supervisor mode
  strb r0,[r7,#0x44]
  ldmia sp!,{pc} ;@ Return

;@ ---------------------------- Opcodes ---------------------------
Op____: ;@ Called if an opcode is not recognised
  sub r4,r4,#2
  mov r0,#0x10
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

Op__al: ;@ Unrecognised a-line opcode
  sub r4,r4,#2
  mov r0,#0x28
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

Op__fl: ;@ Unrecognised f-line opcode
  sub r4,r4,#2
  mov r0,#0x2c
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0000] ori.b #$33, d0 uses Op0000 ----------
Op0000:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldrb r0,[r7,r11,lsl #2]
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0010] ori.b #$33, (a0) uses Op0010 ----------
Op0010:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0018] ori.b #$33, (a0)+ uses Op0018 ----------
Op0018:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [001f] ori.b #$33, (a7)+ uses Op001f ----------
Op001f:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0020] ori.b #$33, -(a0) uses Op0020 ----------
Op0020:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0027] ori.b #$33, -(a7) uses Op0027 ----------
Op0027:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0028] ori.b #$33, ($3333,a0) uses Op0028 ----------
Op0028:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0030] ori.b #$33, ($33,a0,d3.w*2) uses Op0030 ----------
Op0030:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0038] ori.b #$33, $3333.w uses Op0038 ----------
Op0038:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0039] ori.b #$33, $33333333.l uses Op0039 ----------
Op0039:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [003c] ori.b #$33, ccr uses Op003c ----------
Op003c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r10:
  mov r10,r0,asl #0

  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  and r0,r0,#0x02
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  orr r0,r1,r10
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0040] ori.w #$3333, d0 uses Op0040 ----------
Op0040:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldrsh r0,[r7,r11]
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0050] ori.w #$3333, (a0) uses Op0050 ----------
Op0050:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0058] ori.w #$3333, (a0)+ uses Op0058 ----------
Op0058:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [005f] ori.w #$3333, (a7)+ uses Op005f ----------
Op005f:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0060] ori.w #$3333, -(a0) uses Op0060 ----------
Op0060:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0067] ori.w #$3333, -(a7) uses Op0067 ----------
Op0067:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0068] ori.w #$3333, ($3333,a0) uses Op0068 ----------
Op0068:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0070] ori.w #$3333, ($33,a0,d3.w*2) uses Op0070 ----------
Op0070:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0078] ori.w #$3333, $3333.w uses Op0078 ----------
Op0078:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0079] ori.w #$3333, $33333333.l uses Op0079 ----------
Op0079:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [007c] ori.w #$3333, sr uses Op007c ----------
Op007c:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode007c ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r10:
  mov r10,r0,asl #0

  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  orr r0,r1,r10
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap007c
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap007c:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts7c
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts7c:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode007c:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0080] ori.l #$33333333, d0 uses Op0080 ----------
Op0080:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0090] ori.l #$33333333, (a0) uses Op0090 ----------
Op0090:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0098] ori.l #$33333333, (a0)+ uses Op0098 ----------
Op0098:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [009f] ori.l #$33333333, (a7)+ uses Op009f ----------
Op009f:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00a0] ori.l #$33333333, -(a0) uses Op00a0 ----------
Op00a0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00a7] ori.l #$33333333, -(a7) uses Op00a7 ----------
Op00a7:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00a8] ori.l #$33333333, ($3333,a0) uses Op00a8 ----------
Op00a8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00b0] ori.l #$33333333, ($33,a0,d3.w*2) uses Op00b0 ----------
Op00b0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00b8] ori.l #$33333333, $3333.w uses Op00b8 ----------
Op00b8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [00b9] ori.l #$33333333, $33333333.l uses Op00b9 ----------
Op00b9:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  orr r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0100] btst d0, d0 uses Op0100 ----------
Op0100:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#31 ;@ reg - do mod 32

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0108] movep.w ($3333,a0), d0 uses Op0108 ----------
Op0108:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x0007
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r11:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r11,r0,asl #24

  add r10,r10,#2
;@ EaRead : Read '($3333,a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r0,r11,r1,lsr #8 ;@ second byte
;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
  mov r11,r11,lsr #7
;@ EaWrite: r0 into register[r11]:
  mov r0,r0,asr #16
  strh r0,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0110] btst d0, (a0) uses Op0110 ----------
Op0110:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0118] btst d0, (a0)+ uses Op0118 ----------
Op0118:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [011f] btst d0, (a7)+ uses Op011f ----------
Op011f:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0120] btst d0, -(a0) uses Op0120 ----------
Op0120:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0127] btst d0, -(a7) uses Op0127 ----------
Op0127:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0128] btst d0, ($3333,a0) uses Op0128 ----------
Op0128:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0130] btst d0, ($33,a0,d3.w*2) uses Op0130 ----------
Op0130:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0138] btst d0, $3333.w uses Op0138 ----------
Op0138:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0139] btst d0, $33333333.l uses Op0139 ----------
Op0139:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [013a] btst d0, ($3333,pc); =3335 uses Op013a ----------
Op013a:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($3333,pc)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r11,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [013b] btst d0, ($33,pc,d3.w*2); =35 uses Op013b ----------
Op013b:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($33,pc,d3.w*2)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r11,r2,r0,asr #8 ;@ r11=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [013c] btst d0, #$33 uses Op013c ----------
Op013c:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '#$33' into r11:
  ldrsb r11,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r11) into r0:
  mov r0,r11,asl #0

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0140] bchg d0, d0 uses Op0140 ----------
Op0140:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#31 ;@ reg - do mod 32

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0148] movep.l ($3333,a0), d0 uses Op0148 ----------
Op0148:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x0007
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r11:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r11,r0,asl #24

  add r10,r10,#2
;@ EaRead : Read '($3333,a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r11,r11,r1,lsr #8 ;@ second byte
  add r10,r10,#2
;@ EaRead : Read '($3333,a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r11,r11,r1,lsr #16 ;@ third byte
  add r10,r10,#2
;@ EaRead : Read '($3333,a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  orr r0,r11,r1,lsr #24 ;@ fourth byte
;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
;@ EaWrite: r0 into register[r11]:
  str r0,[r7,r11,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0150] bchg d0, (a0) uses Op0150 ----------
Op0150:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0158] bchg d0, (a0)+ uses Op0158 ----------
Op0158:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [015f] bchg d0, (a7)+ uses Op015f ----------
Op015f:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0160] bchg d0, -(a0) uses Op0160 ----------
Op0160:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0167] bchg d0, -(a7) uses Op0167 ----------
Op0167:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0168] bchg d0, ($3333,a0) uses Op0168 ----------
Op0168:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0170] bchg d0, ($33,a0,d3.w*2) uses Op0170 ----------
Op0170:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0178] bchg d0, $3333.w uses Op0178 ----------
Op0178:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0179] bchg d0, $33333333.l uses Op0179 ----------
Op0179:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r1,lsl r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0180] bclr d0, d0 uses Op0180 ----------
Op0180:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#31 ;@ reg - do mod 32

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0188] movep.w d0, ($3333,a0) uses Op0188 ----------
Op0188:
;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
  mov r11,r11,lsr #7
;@ EaRead : Read register[r11] into r11:
  ldrsh r11,[r7,r11]

;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x0007
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
  mov r1,r11,lsr #8 ;@ first or third byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r10,r10,#2
  and r1,r11,#0xff
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0190] bclr d0, (a0) uses Op0190 ----------
Op0190:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0198] bclr d0, (a0)+ uses Op0198 ----------
Op0198:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [019f] bclr d0, (a7)+ uses Op019f ----------
Op019f:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01a0] bclr d0, -(a0) uses Op01a0 ----------
Op01a0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01a7] bclr d0, -(a7) uses Op01a7 ----------
Op01a7:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01a8] bclr d0, ($3333,a0) uses Op01a8 ----------
Op01a8:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01b0] bclr d0, ($33,a0,d3.w*2) uses Op01b0 ----------
Op01b0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01b8] bclr d0, $3333.w uses Op01b8 ----------
Op01b8:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01b9] bclr d0, $33333333.l uses Op01b9 ----------
Op01b9:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r1,lsl r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01c0] bset d0, d0 uses Op01c0 ----------
Op01c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#31 ;@ reg - do mod 32

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01c8] movep.l d0, ($3333,a0) uses Op01c8 ----------
Op01c8:
;@ EaCalc : Get register index into r11:
  and r11,r8,#0x0e00
;@ EaRead : Read register[r11] into r11:
  ldr r11,[r7,r11,lsr #7]

;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x0007
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
  mov r1,r11,lsr #24 ;@ first byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r10,r10,#2
  mov r1,r11,lsr #16 ;@ second byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r10,r10,#2
  mov r1,r11,lsr #8 ;@ first or third byte
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  add r10,r10,#2
  and r1,r11,#0xff
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01d0] bset d0, (a0) uses Op01d0 ----------
Op01d0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01d8] bset d0, (a0)+ uses Op01d8 ----------
Op01d8:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01df] bset d0, (a7)+ uses Op01df ----------
Op01df:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01e0] bset d0, -(a0) uses Op01e0 ----------
Op01e0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01e7] bset d0, -(a7) uses Op01e7 ----------
Op01e7:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01e8] bset d0, ($3333,a0) uses Op01e8 ----------
Op01e8:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01f0] bset d0, ($33,a0,d3.w*2) uses Op01f0 ----------
Op01f0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01f8] bset d0, $3333.w uses Op01f8 ----------
Op01f8:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [01f9] bset d0, $33333333.l uses Op01f9 ----------
Op01f9:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaRead : Read register[r0] into r0:
  ldrsb r0,[r7,r0]

  and r10,r0,#7  ;@ mem - do mod 8

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  mov r1,#1
  tst r0,r1,lsl r10 ;@ Do arithmetic
  bicne r9,r9,#0x40000000
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r1,lsl r10 ;@ Set bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0200] andi.b #$33, d0 uses Op0200 ----------
Op0200:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldrb r0,[r7,r11,lsl #2]
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0210] andi.b #$33, (a0) uses Op0210 ----------
Op0210:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0218] andi.b #$33, (a0)+ uses Op0218 ----------
Op0218:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [021f] andi.b #$33, (a7)+ uses Op021f ----------
Op021f:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0220] andi.b #$33, -(a0) uses Op0220 ----------
Op0220:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0227] andi.b #$33, -(a7) uses Op0227 ----------
Op0227:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0228] andi.b #$33, ($3333,a0) uses Op0228 ----------
Op0228:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0230] andi.b #$33, ($33,a0,d3.w*2) uses Op0230 ----------
Op0230:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0238] andi.b #$33, $3333.w uses Op0238 ----------
Op0238:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0239] andi.b #$33, $33333333.l uses Op0239 ----------
Op0239:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [023c] andi.b #$33, ccr uses Op023c ----------
Op023c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r10:
  mov r10,r0,asl #0

  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  and r0,r0,#0x02
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  and r0,r1,r10
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0240] andi.w #$3333, d0 uses Op0240 ----------
Op0240:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldrsh r0,[r7,r11]
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0250] andi.w #$3333, (a0) uses Op0250 ----------
Op0250:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0258] andi.w #$3333, (a0)+ uses Op0258 ----------
Op0258:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [025f] andi.w #$3333, (a7)+ uses Op025f ----------
Op025f:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0260] andi.w #$3333, -(a0) uses Op0260 ----------
Op0260:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0267] andi.w #$3333, -(a7) uses Op0267 ----------
Op0267:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0268] andi.w #$3333, ($3333,a0) uses Op0268 ----------
Op0268:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0270] andi.w #$3333, ($33,a0,d3.w*2) uses Op0270 ----------
Op0270:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0278] andi.w #$3333, $3333.w uses Op0278 ----------
Op0278:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0279] andi.w #$3333, $33333333.l uses Op0279 ----------
Op0279:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [027c] andi.w #$3333, sr uses Op027c ----------
Op027c:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode027c ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r10:
  mov r10,r0,asl #0

  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  and r0,r1,r10
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap027c
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap027c:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts27c
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts27c:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode027c:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0280] andi.l #$33333333, d0 uses Op0280 ----------
Op0280:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0290] andi.l #$33333333, (a0) uses Op0290 ----------
Op0290:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0298] andi.l #$33333333, (a0)+ uses Op0298 ----------
Op0298:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [029f] andi.l #$33333333, (a7)+ uses Op029f ----------
Op029f:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02a0] andi.l #$33333333, -(a0) uses Op02a0 ----------
Op02a0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02a7] andi.l #$33333333, -(a7) uses Op02a7 ----------
Op02a7:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02a8] andi.l #$33333333, ($3333,a0) uses Op02a8 ----------
Op02a8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02b0] andi.l #$33333333, ($33,a0,d3.w*2) uses Op02b0 ----------
Op02b0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02b8] andi.l #$33333333, $3333.w uses Op02b8 ----------
Op02b8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [02b9] andi.l #$33333333, $33333333.l uses Op02b9 ----------
Op02b9:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  and r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0400] subi.b #$33, d0 uses Op0400 ----------
Op0400:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldrb r0,[r7,r11,lsl #2]
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0410] subi.b #$33, (a0) uses Op0410 ----------
Op0410:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0418] subi.b #$33, (a0)+ uses Op0418 ----------
Op0418:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [041f] subi.b #$33, (a7)+ uses Op041f ----------
Op041f:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0420] subi.b #$33, -(a0) uses Op0420 ----------
Op0420:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0427] subi.b #$33, -(a7) uses Op0427 ----------
Op0427:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0428] subi.b #$33, ($3333,a0) uses Op0428 ----------
Op0428:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0430] subi.b #$33, ($33,a0,d3.w*2) uses Op0430 ----------
Op0430:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0438] subi.b #$33, $3333.w uses Op0438 ----------
Op0438:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0439] subi.b #$33, $33333333.l uses Op0439 ----------
Op0439:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0440] subi.w #$3333, d0 uses Op0440 ----------
Op0440:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldrsh r0,[r7,r11]
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0450] subi.w #$3333, (a0) uses Op0450 ----------
Op0450:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0458] subi.w #$3333, (a0)+ uses Op0458 ----------
Op0458:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [045f] subi.w #$3333, (a7)+ uses Op045f ----------
Op045f:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0460] subi.w #$3333, -(a0) uses Op0460 ----------
Op0460:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0467] subi.w #$3333, -(a7) uses Op0467 ----------
Op0467:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0468] subi.w #$3333, ($3333,a0) uses Op0468 ----------
Op0468:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0470] subi.w #$3333, ($33,a0,d3.w*2) uses Op0470 ----------
Op0470:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0478] subi.w #$3333, $3333.w uses Op0478 ----------
Op0478:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0479] subi.w #$3333, $33333333.l uses Op0479 ----------
Op0479:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0480] subi.l #$33333333, d0 uses Op0480 ----------
Op0480:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0490] subi.l #$33333333, (a0) uses Op0490 ----------
Op0490:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0498] subi.l #$33333333, (a0)+ uses Op0498 ----------
Op0498:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [049f] subi.l #$33333333, (a7)+ uses Op049f ----------
Op049f:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04a0] subi.l #$33333333, -(a0) uses Op04a0 ----------
Op04a0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04a7] subi.l #$33333333, -(a7) uses Op04a7 ----------
Op04a7:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04a8] subi.l #$33333333, ($3333,a0) uses Op04a8 ----------
Op04a8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04b0] subi.l #$33333333, ($33,a0,d3.w*2) uses Op04b0 ----------
Op04b0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04b8] subi.l #$33333333, $3333.w uses Op04b8 ----------
Op04b8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [04b9] subi.l #$33333333, $33333333.l uses Op04b9 ----------
Op04b9:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  subs r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0600] addi.b #$33, d0 uses Op0600 ----------
Op0600:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldrb r0,[r7,r11,lsl #2]
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0610] addi.b #$33, (a0) uses Op0610 ----------
Op0610:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0618] addi.b #$33, (a0)+ uses Op0618 ----------
Op0618:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [061f] addi.b #$33, (a7)+ uses Op061f ----------
Op061f:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0620] addi.b #$33, -(a0) uses Op0620 ----------
Op0620:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0627] addi.b #$33, -(a7) uses Op0627 ----------
Op0627:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0628] addi.b #$33, ($3333,a0) uses Op0628 ----------
Op0628:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0630] addi.b #$33, ($33,a0,d3.w*2) uses Op0630 ----------
Op0630:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0638] addi.b #$33, $3333.w uses Op0638 ----------
Op0638:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0639] addi.b #$33, $33333333.l uses Op0639 ----------
Op0639:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0640] addi.w #$3333, d0 uses Op0640 ----------
Op0640:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldrsh r0,[r7,r11]
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0650] addi.w #$3333, (a0) uses Op0650 ----------
Op0650:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0658] addi.w #$3333, (a0)+ uses Op0658 ----------
Op0658:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [065f] addi.w #$3333, (a7)+ uses Op065f ----------
Op065f:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0660] addi.w #$3333, -(a0) uses Op0660 ----------
Op0660:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0667] addi.w #$3333, -(a7) uses Op0667 ----------
Op0667:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0668] addi.w #$3333, ($3333,a0) uses Op0668 ----------
Op0668:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0670] addi.w #$3333, ($33,a0,d3.w*2) uses Op0670 ----------
Op0670:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0678] addi.w #$3333, $3333.w uses Op0678 ----------
Op0678:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0679] addi.w #$3333, $33333333.l uses Op0679 ----------
Op0679:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0680] addi.l #$33333333, d0 uses Op0680 ----------
Op0680:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0690] addi.l #$33333333, (a0) uses Op0690 ----------
Op0690:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0698] addi.l #$33333333, (a0)+ uses Op0698 ----------
Op0698:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [069f] addi.l #$33333333, (a7)+ uses Op069f ----------
Op069f:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06a0] addi.l #$33333333, -(a0) uses Op06a0 ----------
Op06a0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06a7] addi.l #$33333333, -(a7) uses Op06a7 ----------
Op06a7:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06a8] addi.l #$33333333, ($3333,a0) uses Op06a8 ----------
Op06a8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06b0] addi.l #$33333333, ($33,a0,d3.w*2) uses Op06b0 ----------
Op06b0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06b8] addi.l #$33333333, $3333.w uses Op06b8 ----------
Op06b8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [06b9] addi.l #$33333333, $33333333.l uses Op06b9 ----------
Op06b9:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  adds r1,r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0800] btst #$33, d0 uses Op0800 ----------
Op0800:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0810] btst #$33, (a0) uses Op0810 ----------
Op0810:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0818] btst #$33, (a0)+ uses Op0818 ----------
Op0818:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [081f] btst #$33, (a7)+ uses Op081f ----------
Op081f:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0820] btst #$33, -(a0) uses Op0820 ----------
Op0820:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0827] btst #$33, -(a7) uses Op0827 ----------
Op0827:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0828] btst #$33, ($3333,a0) uses Op0828 ----------
Op0828:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0830] btst #$33, ($33,a0,d3.w*2) uses Op0830 ----------
Op0830:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0838] btst #$33, $3333.w uses Op0838 ----------
Op0838:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0839] btst #$33, $33333333.l uses Op0839 ----------
Op0839:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [083a] btst #$33, ($3333,pc); =3337 uses Op083a ----------
Op083a:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,pc)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r11,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [083b] btst #$33, ($33,pc,d3.w*2); =37 uses Op083b ----------
Op083b:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,pc,d3.w*2)' into r11:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r11,r2,r0,asr #8 ;@ r11=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0840] bchg #$33, d0 uses Op0840 ----------
Op0840:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0850] bchg #$33, (a0) uses Op0850 ----------
Op0850:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0858] bchg #$33, (a0)+ uses Op0858 ----------
Op0858:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [085f] bchg #$33, (a7)+ uses Op085f ----------
Op085f:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0860] bchg #$33, -(a0) uses Op0860 ----------
Op0860:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0867] bchg #$33, -(a7) uses Op0867 ----------
Op0867:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0868] bchg #$33, ($3333,a0) uses Op0868 ----------
Op0868:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0870] bchg #$33, ($33,a0,d3.w*2) uses Op0870 ----------
Op0870:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0878] bchg #$33, $3333.w uses Op0878 ----------
Op0878:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0879] bchg #$33, $33333333.l uses Op0879 ----------
Op0879:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  eor r1,r0,r10 ;@ Toggle bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0880] bclr #$33, d0 uses Op0880 ----------
Op0880:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0890] bclr #$33, (a0) uses Op0890 ----------
Op0890:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0898] bclr #$33, (a0)+ uses Op0898 ----------
Op0898:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [089f] bclr #$33, (a7)+ uses Op089f ----------
Op089f:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08a0] bclr #$33, -(a0) uses Op08a0 ----------
Op08a0:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08a7] bclr #$33, -(a7) uses Op08a7 ----------
Op08a7:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08a8] bclr #$33, ($3333,a0) uses Op08a8 ----------
Op08a8:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08b0] bclr #$33, ($33,a0,d3.w*2) uses Op08b0 ----------
Op08b0:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08b8] bclr #$33, $3333.w uses Op08b8 ----------
Op08b8:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08b9] bclr #$33, $33333333.l uses Op08b9 ----------
Op08b9:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  bic r1,r0,r10 ;@ Clear bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08c0] bset #$33, d0 uses Op08c0 ----------
Op08c0:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#0x1F ;@ reg - do mod 32
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08d0] bset #$33, (a0) uses Op08d0 ----------
Op08d0:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08d8] bset #$33, (a0)+ uses Op08d8 ----------
Op08d8:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08df] bset #$33, (a7)+ uses Op08df ----------
Op08df:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08e0] bset #$33, -(a0) uses Op08e0 ----------
Op08e0:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08e7] bset #$33, -(a7) uses Op08e7 ----------
Op08e7:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08e8] bset #$33, ($3333,a0) uses Op08e8 ----------
Op08e8:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08f0] bset #$33, ($33,a0,d3.w*2) uses Op08f0 ----------
Op08f0:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08f8] bset #$33, $3333.w uses Op08f8 ----------
Op08f8:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [08f9] bset #$33, $33333333.l uses Op08f9 ----------
Op08f9:
  mov r10,#1

;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r0:

  bic r9,r9,#0x40000000 ;@ Blank Z flag
  and r0,r0,#7 ;@ mem - do mod 8
  mov r10,r10,lsl r0 ;@ Make bit mask

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

  tst r0,r10 ;@ Do arithmetic
  orreq r9,r9,#0x40000000 ;@ Get Z flag

  orr r1,r0,r10 ;@ Set bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a00] eori.b #$33, d0 uses Op0a00 ----------
Op0a00:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldrb r0,[r7,r11,lsl #2]
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #24
  strb r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a10] eori.b #$33, (a0) uses Op0a10 ----------
Op0a10:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a18] eori.b #$33, (a0)+ uses Op0a18 ----------
Op0a18:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a1f] eori.b #$33, (a7)+ uses Op0a1f ----------
Op0a1f:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a20] eori.b #$33, -(a0) uses Op0a20 ----------
Op0a20:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a27] eori.b #$33, -(a7) uses Op0a27 ----------
Op0a27:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a28] eori.b #$33, ($3333,a0) uses Op0a28 ----------
Op0a28:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a30] eori.b #$33, ($33,a0,d3.w*2) uses Op0a30 ----------
Op0a30:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a38] eori.b #$33, $3333.w uses Op0a38 ----------
Op0a38:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a39] eori.b #$33, $33333333.l uses Op0a39 ----------
Op0a39:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a3c] eori.b #$33, ccr uses Op0a3c ----------
Op0a3c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r10:
  mov r10,r0,asl #0

  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  and r0,r0,#0x02
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  eor r0,r1,r10
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a40] eori.w #$3333, d0 uses Op0a40 ----------
Op0a40:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldrsh r0,[r7,r11]
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  mov r1,r1,asr #16
  strh r1,[r7,r11]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a50] eori.w #$3333, (a0) uses Op0a50 ----------
Op0a50:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a58] eori.w #$3333, (a0)+ uses Op0a58 ----------
Op0a58:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a5f] eori.w #$3333, (a7)+ uses Op0a5f ----------
Op0a5f:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a60] eori.w #$3333, -(a0) uses Op0a60 ----------
Op0a60:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a67] eori.w #$3333, -(a7) uses Op0a67 ----------
Op0a67:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a68] eori.w #$3333, ($3333,a0) uses Op0a68 ----------
Op0a68:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a70] eori.w #$3333, ($33,a0,d3.w*2) uses Op0a70 ----------
Op0a70:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a78] eori.w #$3333, $3333.w uses Op0a78 ----------
Op0a78:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a79] eori.w #$3333, $33333333.l uses Op0a79 ----------
Op0a79:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a7c] eori.w #$3333, sr uses Op0a7c ----------
Op0a7c:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode0a7c ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r10:
  mov r10,r0,asl #0

  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

  eor r0,r1,r10
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap0a7c
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap0a7c:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoIntsa7c
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoIntsa7c:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode0a7c:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a80] eori.l #$33333333, d0 uses Op0a80 ----------
Op0a80:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r11]:
  str r1,[r7,r11,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a90] eori.l #$33333333, (a0) uses Op0a90 ----------
Op0a90:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a98] eori.l #$33333333, (a0)+ uses Op0a98 ----------
Op0a98:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0a9f] eori.l #$33333333, (a7)+ uses Op0a9f ----------
Op0a9f:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0aa0] eori.l #$33333333, -(a0) uses Op0aa0 ----------
Op0aa0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0aa7] eori.l #$33333333, -(a7) uses Op0aa7 ----------
Op0aa7:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0aa8] eori.l #$33333333, ($3333,a0) uses Op0aa8 ----------
Op0aa8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ab0] eori.l #$33333333, ($33,a0,d3.w*2) uses Op0ab0 ----------
Op0ab0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ab8] eori.l #$33333333, $3333.w uses Op0ab8 ----------
Op0ab8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ab9] eori.l #$33333333, $33333333.l uses Op0ab9 ----------
Op0ab9:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  eor r1,r0,r10
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r11):
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c00] cmpi.b #$33, d0 uses Op0c00 ----------
Op0c00:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldrb r0,[r7,r11,lsl #2]
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c10] cmpi.b #$33, (a0) uses Op0c10 ----------
Op0c10:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c18] cmpi.b #$33, (a0)+ uses Op0c18 ----------
Op0c18:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c1f] cmpi.b #$33, (a7)+ uses Op0c1f ----------
Op0c1f:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c20] cmpi.b #$33, -(a0) uses Op0c20 ----------
Op0c20:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#1 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c27] cmpi.b #$33, -(a7) uses Op0c27 ----------
Op0c27:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c28] cmpi.b #$33, ($3333,a0) uses Op0c28 ----------
Op0c28:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c30] cmpi.b #$33, ($33,a0,d3.w*2) uses Op0c30 ----------
Op0c30:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c38] cmpi.b #$33, $3333.w uses Op0c38 ----------
Op0c38:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c39] cmpi.b #$33, $33333333.l uses Op0c39 ----------
Op0c39:
;@ EaCalc : Get '#$33' into r10:
  ldrsb r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r10) into r10:
  mov r10,r10,asl #24

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c40] cmpi.w #$3333, d0 uses Op0c40 ----------
Op0c40:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
  mov r11,r11,lsl #2
;@ EaRead : Read register[r11] into r0:
  ldrsh r0,[r7,r11]
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c50] cmpi.w #$3333, (a0) uses Op0c50 ----------
Op0c50:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c58] cmpi.w #$3333, (a0)+ uses Op0c58 ----------
Op0c58:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c5f] cmpi.w #$3333, (a7)+ uses Op0c5f ----------
Op0c5f:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c60] cmpi.w #$3333, -(a0) uses Op0c60 ----------
Op0c60:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c67] cmpi.w #$3333, -(a7) uses Op0c67 ----------
Op0c67:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#2 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c68] cmpi.w #$3333, ($3333,a0) uses Op0c68 ----------
Op0c68:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c70] cmpi.w #$3333, ($33,a0,d3.w*2) uses Op0c70 ----------
Op0c70:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c78] cmpi.w #$3333, $3333.w uses Op0c78 ----------
Op0c78:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c79] cmpi.w #$3333, $33333333.l uses Op0c79 ----------
Op0c79:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r10:
  mov r10,r10,asl #16

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c80] cmpi.l #$33333333, d0 uses Op0c80 ----------
Op0c80:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get register index into r11:
  and r11,r8,#0x000f
;@ EaRead : Read register[r11] into r0:
  ldr r0,[r7,r11,lsl #2]

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c90] cmpi.l #$33333333, (a0) uses Op0c90 ----------
Op0c90:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c98] cmpi.l #$33333333, (a0)+ uses Op0c98 ----------
Op0c98:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a0)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0c9f] cmpi.l #$33333333, (a7)+ uses Op0c9f ----------
Op0c9f:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '(a7)+' into r11:
  and r2,r8,#0x000f
  ldr r11,[r7,r2,lsl #2]
  add r3,r11,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ca0] cmpi.l #$33333333, -(a0) uses Op0ca0 ----------
Op0ca0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a0)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ca7] cmpi.l #$33333333, -(a7) uses Op0ca7 ----------
Op0ca7:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '-(a7)' into r11:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r11,[r7,r2,lsl #2]
  sub r11,r11,#4 ;@ Pre-decrement An
  str r11,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0ca8] cmpi.l #$33333333, ($3333,a0) uses Op0ca8 ----------
Op0ca8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($3333,a0)' into r11:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r11,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0cb0] cmpi.l #$33333333, ($33,a0,d3.w*2) uses Op0cb0 ----------
Op0cb0:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '($33,a0,d3.w*2)' into r11:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r11,r2,r3 ;@ r11=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0cb8] cmpi.l #$33333333, $3333.w uses Op0cb8 ----------
Op0cb8:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$3333.w' into r11:
  ldrsh r11,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [0cb9] cmpi.l #$33333333, $33333333.l uses Op0cb9 ----------
Op0cb9:
;@ EaCalc : Get '#$33333333' into r10:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r10) into r10:

;@ EaCalc : Get '$33333333.l' into r11:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r11,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r11) into r0:
  mov r0,r11
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Do arithmetic:
  cmp r0,r10 ;@ Defines NZCV
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1000] move.b d0, d0 uses Op1000 ----------
Op1000:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1010] move.b (a0), d0 uses Op1010 ----------
Op1010:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1018] move.b (a0)+, d0 uses Op1018 ----------
Op1018:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [101f] move.b (a7)+, d0 uses Op101f ----------
Op101f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1020] move.b -(a0), d0 uses Op1020 ----------
Op1020:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1027] move.b -(a7), d0 uses Op1027 ----------
Op1027:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1028] move.b ($3333,a0), d0 uses Op1028 ----------
Op1028:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1030] move.b ($33,a0,d3.w*2), d0 uses Op1030 ----------
Op1030:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1038] move.b $3333.w, d0 uses Op1038 ----------
Op1038:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1039] move.b $33333333.l, d0 uses Op1039 ----------
Op1039:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [103a] move.b ($3333,pc), d0; =3335 uses Op103a ----------
Op103a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [103b] move.b ($33,pc,d3.w*2), d0; =35 uses Op103b ----------
Op103b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [103c] move.b #$33, d0 uses Op103c ----------
Op103c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1080] move.b d0, (a0) uses Op1080 ----------
Op1080:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1090] move.b (a0), (a0) uses Op1090 ----------
Op1090:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1098] move.b (a0)+, (a0) uses Op1098 ----------
Op1098:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [109f] move.b (a7)+, (a0) uses Op109f ----------
Op109f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10a0] move.b -(a0), (a0) uses Op10a0 ----------
Op10a0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10a7] move.b -(a7), (a0) uses Op10a7 ----------
Op10a7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10a8] move.b ($3333,a0), (a0) uses Op10a8 ----------
Op10a8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10b0] move.b ($33,a0,d3.w*2), (a0) uses Op10b0 ----------
Op10b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10b8] move.b $3333.w, (a0) uses Op10b8 ----------
Op10b8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10b9] move.b $33333333.l, (a0) uses Op10b9 ----------
Op10b9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10ba] move.b ($3333,pc), (a0); =3335 uses Op10ba ----------
Op10ba:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10bb] move.b ($33,pc,d3.w*2), (a0); =35 uses Op10bb ----------
Op10bb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10bc] move.b #$33, (a0) uses Op10bc ----------
Op10bc:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10c0] move.b d0, (a0)+ uses Op10c0 ----------
Op10c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10d0] move.b (a0), (a0)+ uses Op10d0 ----------
Op10d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10d8] move.b (a0)+, (a0)+ uses Op10d8 ----------
Op10d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10df] move.b (a7)+, (a0)+ uses Op10df ----------
Op10df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10e0] move.b -(a0), (a0)+ uses Op10e0 ----------
Op10e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10e7] move.b -(a7), (a0)+ uses Op10e7 ----------
Op10e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10e8] move.b ($3333,a0), (a0)+ uses Op10e8 ----------
Op10e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10f0] move.b ($33,a0,d3.w*2), (a0)+ uses Op10f0 ----------
Op10f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10f8] move.b $3333.w, (a0)+ uses Op10f8 ----------
Op10f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10f9] move.b $33333333.l, (a0)+ uses Op10f9 ----------
Op10f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10fa] move.b ($3333,pc), (a0)+; =3335 uses Op10fa ----------
Op10fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10fb] move.b ($33,pc,d3.w*2), (a0)+; =35 uses Op10fb ----------
Op10fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [10fc] move.b #$33, (a0)+ uses Op10fc ----------
Op10fc:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1100] move.b d0, -(a0) uses Op1100 ----------
Op1100:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1110] move.b (a0), -(a0) uses Op1110 ----------
Op1110:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1118] move.b (a0)+, -(a0) uses Op1118 ----------
Op1118:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [111f] move.b (a7)+, -(a0) uses Op111f ----------
Op111f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1120] move.b -(a0), -(a0) uses Op1120 ----------
Op1120:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1127] move.b -(a7), -(a0) uses Op1127 ----------
Op1127:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1128] move.b ($3333,a0), -(a0) uses Op1128 ----------
Op1128:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1130] move.b ($33,a0,d3.w*2), -(a0) uses Op1130 ----------
Op1130:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1138] move.b $3333.w, -(a0) uses Op1138 ----------
Op1138:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1139] move.b $33333333.l, -(a0) uses Op1139 ----------
Op1139:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [113a] move.b ($3333,pc), -(a0); =3335 uses Op113a ----------
Op113a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [113b] move.b ($33,pc,d3.w*2), -(a0); =35 uses Op113b ----------
Op113b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [113c] move.b #$33, -(a0) uses Op113c ----------
Op113c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1140] move.b d0, ($3333,a0) uses Op1140 ----------
Op1140:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1150] move.b (a0), ($3333,a0) uses Op1150 ----------
Op1150:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1158] move.b (a0)+, ($3333,a0) uses Op1158 ----------
Op1158:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [115f] move.b (a7)+, ($3333,a0) uses Op115f ----------
Op115f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1160] move.b -(a0), ($3333,a0) uses Op1160 ----------
Op1160:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1167] move.b -(a7), ($3333,a0) uses Op1167 ----------
Op1167:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1168] move.b ($3333,a0), ($3333,a0) uses Op1168 ----------
Op1168:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1170] move.b ($33,a0,d3.w*2), ($3333,a0) uses Op1170 ----------
Op1170:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1178] move.b $3333.w, ($3333,a0) uses Op1178 ----------
Op1178:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1179] move.b $33333333.l, ($3333,a0) uses Op1179 ----------
Op1179:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [117a] move.b ($3333,pc), ($3333,a0); =3335 uses Op117a ----------
Op117a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [117b] move.b ($33,pc,d3.w*2), ($3333,a0); =35 uses Op117b ----------
Op117b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [117c] move.b #$33, ($3333,a0) uses Op117c ----------
Op117c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1180] move.b d0, ($33,a0,d3.w*2) uses Op1180 ----------
Op1180:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1190] move.b (a0), ($33,a0,d3.w*2) uses Op1190 ----------
Op1190:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1198] move.b (a0)+, ($33,a0,d3.w*2) uses Op1198 ----------
Op1198:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [119f] move.b (a7)+, ($33,a0,d3.w*2) uses Op119f ----------
Op119f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11a0] move.b -(a0), ($33,a0,d3.w*2) uses Op11a0 ----------
Op11a0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11a7] move.b -(a7), ($33,a0,d3.w*2) uses Op11a7 ----------
Op11a7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11a8] move.b ($3333,a0), ($33,a0,d3.w*2) uses Op11a8 ----------
Op11a8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11b0] move.b ($33,a0,d3.w*2), ($33,a0,d3.w*2) uses Op11b0 ----------
Op11b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11b8] move.b $3333.w, ($33,a0,d3.w*2) uses Op11b8 ----------
Op11b8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11b9] move.b $33333333.l, ($33,a0,d3.w*2) uses Op11b9 ----------
Op11b9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11ba] move.b ($3333,pc), ($33,a0,d3.w*2); =3335 uses Op11ba ----------
Op11ba:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11bb] move.b ($33,pc,d3.w*2), ($33,a0,d3.w*2); =35 uses Op11bb ----------
Op11bb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11bc] move.b #$33, ($33,a0,d3.w*2) uses Op11bc ----------
Op11bc:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11c0] move.b d0, $3333.w uses Op11c0 ----------
Op11c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11d0] move.b (a0), $3333.w uses Op11d0 ----------
Op11d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11d8] move.b (a0)+, $3333.w uses Op11d8 ----------
Op11d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11df] move.b (a7)+, $3333.w uses Op11df ----------
Op11df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11e0] move.b -(a0), $3333.w uses Op11e0 ----------
Op11e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11e7] move.b -(a7), $3333.w uses Op11e7 ----------
Op11e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11e8] move.b ($3333,a0), $3333.w uses Op11e8 ----------
Op11e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11f0] move.b ($33,a0,d3.w*2), $3333.w uses Op11f0 ----------
Op11f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11f8] move.b $3333.w, $3333.w uses Op11f8 ----------
Op11f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11f9] move.b $33333333.l, $3333.w uses Op11f9 ----------
Op11f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11fa] move.b ($3333,pc), $3333.w; =3335 uses Op11fa ----------
Op11fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11fb] move.b ($33,pc,d3.w*2), $3333.w; =35 uses Op11fb ----------
Op11fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [11fc] move.b #$33, $3333.w uses Op11fc ----------
Op11fc:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13c0] move.b d0, $33333333.l uses Op13c0 ----------
Op13c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13d0] move.b (a0), $33333333.l uses Op13d0 ----------
Op13d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13d8] move.b (a0)+, $33333333.l uses Op13d8 ----------
Op13d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13df] move.b (a7)+, $33333333.l uses Op13df ----------
Op13df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13e0] move.b -(a0), $33333333.l uses Op13e0 ----------
Op13e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13e7] move.b -(a7), $33333333.l uses Op13e7 ----------
Op13e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13e8] move.b ($3333,a0), $33333333.l uses Op13e8 ----------
Op13e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13f0] move.b ($33,a0,d3.w*2), $33333333.l uses Op13f0 ----------
Op13f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13f8] move.b $3333.w, $33333333.l uses Op13f8 ----------
Op13f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13f9] move.b $33333333.l, $33333333.l uses Op13f9 ----------
Op13f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13fa] move.b ($3333,pc), $33333333.l; =3335 uses Op13fa ----------
Op13fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13fb] move.b ($33,pc,d3.w*2), $33333333.l; =35 uses Op13fb ----------
Op13fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [13fc] move.b #$33, $33333333.l uses Op13fc ----------
Op13fc:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ec0] move.b d0, (a7)+ uses Op1ec0 ----------
Op1ec0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ed0] move.b (a0), (a7)+ uses Op1ed0 ----------
Op1ed0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ed8] move.b (a0)+, (a7)+ uses Op1ed8 ----------
Op1ed8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1edf] move.b (a7)+, (a7)+ uses Op1edf ----------
Op1edf:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ee0] move.b -(a0), (a7)+ uses Op1ee0 ----------
Op1ee0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ee7] move.b -(a7), (a7)+ uses Op1ee7 ----------
Op1ee7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ee8] move.b ($3333,a0), (a7)+ uses Op1ee8 ----------
Op1ee8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ef0] move.b ($33,a0,d3.w*2), (a7)+ uses Op1ef0 ----------
Op1ef0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ef8] move.b $3333.w, (a7)+ uses Op1ef8 ----------
Op1ef8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1ef9] move.b $33333333.l, (a7)+ uses Op1ef9 ----------
Op1ef9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1efa] move.b ($3333,pc), (a7)+; =3335 uses Op1efa ----------
Op1efa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1efb] move.b ($33,pc,d3.w*2), (a7)+; =35 uses Op1efb ----------
Op1efb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1efc] move.b #$33, (a7)+ uses Op1efc ----------
Op1efc:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f00] move.b d0, -(a7) uses Op1f00 ----------
Op1f00:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsb r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f10] move.b (a0), -(a7) uses Op1f10 ----------
Op1f10:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f18] move.b (a0)+, -(a7) uses Op1f18 ----------
Op1f18:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f1f] move.b (a7)+, -(a7) uses Op1f1f ----------
Op1f1f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f20] move.b -(a0), -(a7) uses Op1f20 ----------
Op1f20:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f27] move.b -(a7), -(a7) uses Op1f27 ----------
Op1f27:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f28] move.b ($3333,a0), -(a7) uses Op1f28 ----------
Op1f28:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f30] move.b ($33,a0,d3.w*2), -(a7) uses Op1f30 ----------
Op1f30:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f38] move.b $3333.w, -(a7) uses Op1f38 ----------
Op1f38:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f39] move.b $33333333.l, -(a7) uses Op1f39 ----------
Op1f39:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f3a] move.b ($3333,pc), -(a7); =3335 uses Op1f3a ----------
Op1f3a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f3b] move.b ($33,pc,d3.w*2), -(a7); =35 uses Op1f3b ----------
Op1f3b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x80] ;@ Call fetch8(r0) handler
  mov r1,r0,asl #24
  mov r1,r1,asr #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [1f3c] move.b #$33, -(a7) uses Op1f3c ----------
Op1f3c:
;@ EaCalc : Get '#$33' into r0:
  ldrsb r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$33' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2000] move.l d0, d0 uses Op2000 ----------
Op2000:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2010] move.l (a0), d0 uses Op2010 ----------
Op2010:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2018] move.l (a0)+, d0 uses Op2018 ----------
Op2018:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [201f] move.l (a7)+, d0 uses Op201f ----------
Op201f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2020] move.l -(a0), d0 uses Op2020 ----------
Op2020:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2027] move.l -(a7), d0 uses Op2027 ----------
Op2027:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2028] move.l ($3333,a0), d0 uses Op2028 ----------
Op2028:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2030] move.l ($33,a0,d3.w*2), d0 uses Op2030 ----------
Op2030:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2038] move.l $3333.w, d0 uses Op2038 ----------
Op2038:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2039] move.l $33333333.l, d0 uses Op2039 ----------
Op2039:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [203a] move.l ($3333,pc), d0; =3335 uses Op203a ----------
Op203a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [203b] move.l ($33,pc,d3.w*2), d0; =35 uses Op203b ----------
Op203b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [203c] move.l #$33333333, d0 uses Op203c ----------
Op203c:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2040] movea.l d0, a0 uses Op2040 ----------
Op2040:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2050] movea.l (a0), a0 uses Op2050 ----------
Op2050:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2058] movea.l (a0)+, a0 uses Op2058 ----------
Op2058:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [205f] movea.l (a7)+, a0 uses Op205f ----------
Op205f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2060] movea.l -(a0), a0 uses Op2060 ----------
Op2060:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2067] movea.l -(a7), a0 uses Op2067 ----------
Op2067:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2068] movea.l ($3333,a0), a0 uses Op2068 ----------
Op2068:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2070] movea.l ($33,a0,d3.w*2), a0 uses Op2070 ----------
Op2070:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2078] movea.l $3333.w, a0 uses Op2078 ----------
Op2078:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2079] movea.l $33333333.l, a0 uses Op2079 ----------
Op2079:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [207a] movea.l ($3333,pc), a0; =3335 uses Op207a ----------
Op207a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [207b] movea.l ($33,pc,d3.w*2), a0; =35 uses Op207b ----------
Op207b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [207c] movea.l #$33333333, a0 uses Op207c ----------
Op207c:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2080] move.l d0, (a0) uses Op2080 ----------
Op2080:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2090] move.l (a0), (a0) uses Op2090 ----------
Op2090:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2098] move.l (a0)+, (a0) uses Op2098 ----------
Op2098:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [209f] move.l (a7)+, (a0) uses Op209f ----------
Op209f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20a0] move.l -(a0), (a0) uses Op20a0 ----------
Op20a0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20a7] move.l -(a7), (a0) uses Op20a7 ----------
Op20a7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20a8] move.l ($3333,a0), (a0) uses Op20a8 ----------
Op20a8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20b0] move.l ($33,a0,d3.w*2), (a0) uses Op20b0 ----------
Op20b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20b8] move.l $3333.w, (a0) uses Op20b8 ----------
Op20b8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20b9] move.l $33333333.l, (a0) uses Op20b9 ----------
Op20b9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20ba] move.l ($3333,pc), (a0); =3335 uses Op20ba ----------
Op20ba:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20bb] move.l ($33,pc,d3.w*2), (a0); =35 uses Op20bb ----------
Op20bb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20bc] move.l #$33333333, (a0) uses Op20bc ----------
Op20bc:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20c0] move.l d0, (a0)+ uses Op20c0 ----------
Op20c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20d0] move.l (a0), (a0)+ uses Op20d0 ----------
Op20d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20d8] move.l (a0)+, (a0)+ uses Op20d8 ----------
Op20d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20df] move.l (a7)+, (a0)+ uses Op20df ----------
Op20df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20e0] move.l -(a0), (a0)+ uses Op20e0 ----------
Op20e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20e7] move.l -(a7), (a0)+ uses Op20e7 ----------
Op20e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20e8] move.l ($3333,a0), (a0)+ uses Op20e8 ----------
Op20e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20f0] move.l ($33,a0,d3.w*2), (a0)+ uses Op20f0 ----------
Op20f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20f8] move.l $3333.w, (a0)+ uses Op20f8 ----------
Op20f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20f9] move.l $33333333.l, (a0)+ uses Op20f9 ----------
Op20f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20fa] move.l ($3333,pc), (a0)+; =3335 uses Op20fa ----------
Op20fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20fb] move.l ($33,pc,d3.w*2), (a0)+; =35 uses Op20fb ----------
Op20fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [20fc] move.l #$33333333, (a0)+ uses Op20fc ----------
Op20fc:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2100] move.l d0, -(a0) uses Op2100 ----------
Op2100:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2110] move.l (a0), -(a0) uses Op2110 ----------
Op2110:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2118] move.l (a0)+, -(a0) uses Op2118 ----------
Op2118:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [211f] move.l (a7)+, -(a0) uses Op211f ----------
Op211f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2120] move.l -(a0), -(a0) uses Op2120 ----------
Op2120:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2127] move.l -(a7), -(a0) uses Op2127 ----------
Op2127:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2128] move.l ($3333,a0), -(a0) uses Op2128 ----------
Op2128:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2130] move.l ($33,a0,d3.w*2), -(a0) uses Op2130 ----------
Op2130:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2138] move.l $3333.w, -(a0) uses Op2138 ----------
Op2138:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2139] move.l $33333333.l, -(a0) uses Op2139 ----------
Op2139:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [213a] move.l ($3333,pc), -(a0); =3335 uses Op213a ----------
Op213a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [213b] move.l ($33,pc,d3.w*2), -(a0); =35 uses Op213b ----------
Op213b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [213c] move.l #$33333333, -(a0) uses Op213c ----------
Op213c:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2140] move.l d0, ($3333,a0) uses Op2140 ----------
Op2140:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2150] move.l (a0), ($3333,a0) uses Op2150 ----------
Op2150:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2158] move.l (a0)+, ($3333,a0) uses Op2158 ----------
Op2158:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [215f] move.l (a7)+, ($3333,a0) uses Op215f ----------
Op215f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2160] move.l -(a0), ($3333,a0) uses Op2160 ----------
Op2160:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2167] move.l -(a7), ($3333,a0) uses Op2167 ----------
Op2167:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2168] move.l ($3333,a0), ($3333,a0) uses Op2168 ----------
Op2168:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2170] move.l ($33,a0,d3.w*2), ($3333,a0) uses Op2170 ----------
Op2170:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2178] move.l $3333.w, ($3333,a0) uses Op2178 ----------
Op2178:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2179] move.l $33333333.l, ($3333,a0) uses Op2179 ----------
Op2179:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [217a] move.l ($3333,pc), ($3333,a0); =3335 uses Op217a ----------
Op217a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [217b] move.l ($33,pc,d3.w*2), ($3333,a0); =35 uses Op217b ----------
Op217b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [217c] move.l #$33333333, ($3333,a0) uses Op217c ----------
Op217c:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2180] move.l d0, ($33,a0,d3.w*2) uses Op2180 ----------
Op2180:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2190] move.l (a0), ($33,a0,d3.w*2) uses Op2190 ----------
Op2190:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2198] move.l (a0)+, ($33,a0,d3.w*2) uses Op2198 ----------
Op2198:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [219f] move.l (a7)+, ($33,a0,d3.w*2) uses Op219f ----------
Op219f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21a0] move.l -(a0), ($33,a0,d3.w*2) uses Op21a0 ----------
Op21a0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21a7] move.l -(a7), ($33,a0,d3.w*2) uses Op21a7 ----------
Op21a7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21a8] move.l ($3333,a0), ($33,a0,d3.w*2) uses Op21a8 ----------
Op21a8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21b0] move.l ($33,a0,d3.w*2), ($33,a0,d3.w*2) uses Op21b0 ----------
Op21b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21b8] move.l $3333.w, ($33,a0,d3.w*2) uses Op21b8 ----------
Op21b8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21b9] move.l $33333333.l, ($33,a0,d3.w*2) uses Op21b9 ----------
Op21b9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21ba] move.l ($3333,pc), ($33,a0,d3.w*2); =3335 uses Op21ba ----------
Op21ba:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21bb] move.l ($33,pc,d3.w*2), ($33,a0,d3.w*2); =35 uses Op21bb ----------
Op21bb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21bc] move.l #$33333333, ($33,a0,d3.w*2) uses Op21bc ----------
Op21bc:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21c0] move.l d0, $3333.w uses Op21c0 ----------
Op21c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21d0] move.l (a0), $3333.w uses Op21d0 ----------
Op21d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21d8] move.l (a0)+, $3333.w uses Op21d8 ----------
Op21d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21df] move.l (a7)+, $3333.w uses Op21df ----------
Op21df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21e0] move.l -(a0), $3333.w uses Op21e0 ----------
Op21e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21e7] move.l -(a7), $3333.w uses Op21e7 ----------
Op21e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21e8] move.l ($3333,a0), $3333.w uses Op21e8 ----------
Op21e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21f0] move.l ($33,a0,d3.w*2), $3333.w uses Op21f0 ----------
Op21f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21f8] move.l $3333.w, $3333.w uses Op21f8 ----------
Op21f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21f9] move.l $33333333.l, $3333.w uses Op21f9 ----------
Op21f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21fa] move.l ($3333,pc), $3333.w; =3335 uses Op21fa ----------
Op21fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21fb] move.l ($33,pc,d3.w*2), $3333.w; =35 uses Op21fb ----------
Op21fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [21fc] move.l #$33333333, $3333.w uses Op21fc ----------
Op21fc:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23c0] move.l d0, $33333333.l uses Op23c0 ----------
Op23c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23d0] move.l (a0), $33333333.l uses Op23d0 ----------
Op23d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23d8] move.l (a0)+, $33333333.l uses Op23d8 ----------
Op23d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23df] move.l (a7)+, $33333333.l uses Op23df ----------
Op23df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23e0] move.l -(a0), $33333333.l uses Op23e0 ----------
Op23e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23e7] move.l -(a7), $33333333.l uses Op23e7 ----------
Op23e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#30 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23e8] move.l ($3333,a0), $33333333.l uses Op23e8 ----------
Op23e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23f0] move.l ($33,a0,d3.w*2), $33333333.l uses Op23f0 ----------
Op23f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23f8] move.l $3333.w, $33333333.l uses Op23f8 ----------
Op23f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23f9] move.l $33333333.l, $33333333.l uses Op23f9 ----------
Op23f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#36 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23fa] move.l ($3333,pc), $33333333.l; =3335 uses Op23fa ----------
Op23fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#32 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23fb] move.l ($33,pc,d3.w*2), $33333333.l; =35 uses Op23fb ----------
Op23fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [23fc] move.l #$33333333, $33333333.l uses Op23fc ----------
Op23fc:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ec0] move.l d0, (a7)+ uses Op2ec0 ----------
Op2ec0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ed0] move.l (a0), (a7)+ uses Op2ed0 ----------
Op2ed0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ed8] move.l (a0)+, (a7)+ uses Op2ed8 ----------
Op2ed8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2edf] move.l (a7)+, (a7)+ uses Op2edf ----------
Op2edf:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ee0] move.l -(a0), (a7)+ uses Op2ee0 ----------
Op2ee0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ee7] move.l -(a7), (a7)+ uses Op2ee7 ----------
Op2ee7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ee8] move.l ($3333,a0), (a7)+ uses Op2ee8 ----------
Op2ee8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ef0] move.l ($33,a0,d3.w*2), (a7)+ uses Op2ef0 ----------
Op2ef0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ef8] move.l $3333.w, (a7)+ uses Op2ef8 ----------
Op2ef8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2ef9] move.l $33333333.l, (a7)+ uses Op2ef9 ----------
Op2ef9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2efa] move.l ($3333,pc), (a7)+; =3335 uses Op2efa ----------
Op2efa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2efb] move.l ($33,pc,d3.w*2), (a7)+; =35 uses Op2efb ----------
Op2efb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2efc] move.l #$33333333, (a7)+ uses Op2efc ----------
Op2efc:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f00] move.l d0, -(a7) uses Op2f00 ----------
Op2f00:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r1:
  ldr r1,[r7,r0,lsl #2]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f10] move.l (a0), -(a7) uses Op2f10 ----------
Op2f10:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f18] move.l (a0)+, -(a7) uses Op2f18 ----------
Op2f18:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f1f] move.l (a7)+, -(a7) uses Op2f1f ----------
Op2f1f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f20] move.l -(a0), -(a7) uses Op2f20 ----------
Op2f20:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f27] move.l -(a7), -(a7) uses Op2f27 ----------
Op2f27:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f28] move.l ($3333,a0), -(a7) uses Op2f28 ----------
Op2f28:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f30] move.l ($33,a0,d3.w*2), -(a7) uses Op2f30 ----------
Op2f30:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f38] move.l $3333.w, -(a7) uses Op2f38 ----------
Op2f38:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f39] move.l $33333333.l, -(a7) uses Op2f39 ----------
Op2f39:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f3a] move.l ($3333,pc), -(a7); =3335 uses Op2f3a ----------
Op2f3a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f3b] move.l ($33,pc,d3.w*2), -(a7); =35 uses Op2f3b ----------
Op2f3b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler
  mov r1,r0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [2f3c] move.l #$33333333, -(a7) uses Op2f3c ----------
Op2f3c:
;@ EaCalc : Get '#$33333333' into r0:
  ldrh r2,[r4],#2 ;@ Fetch immediate value
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '#$33333333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
  mov r10,r0
  mov r11,r1
  add r0,r0,#2
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

;@ EaWrite: Write r11 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r11,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3000] move.w d0, d0 uses Op3000 ----------
Op3000:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3010] move.w (a0), d0 uses Op3010 ----------
Op3010:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3018] move.w (a0)+, d0 uses Op3018 ----------
Op3018:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [301f] move.w (a7)+, d0 uses Op301f ----------
Op301f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3020] move.w -(a0), d0 uses Op3020 ----------
Op3020:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3027] move.w -(a7), d0 uses Op3027 ----------
Op3027:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3028] move.w ($3333,a0), d0 uses Op3028 ----------
Op3028:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3030] move.w ($33,a0,d3.w*2), d0 uses Op3030 ----------
Op3030:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3038] move.w $3333.w, d0 uses Op3038 ----------
Op3038:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3039] move.w $33333333.l, d0 uses Op3039 ----------
Op3039:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [303a] move.w ($3333,pc), d0; =3335 uses Op303a ----------
Op303a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [303b] move.w ($33,pc,d3.w*2), d0; =35 uses Op303b ----------
Op303b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [303c] move.w #$3333, d0 uses Op303c ----------
Op303c:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  mov r0,r0,lsr #7
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3040] movea.w d0, a0 uses Op3040 ----------
Op3040:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3050] movea.w (a0), a0 uses Op3050 ----------
Op3050:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3058] movea.w (a0)+, a0 uses Op3058 ----------
Op3058:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [305f] movea.w (a7)+, a0 uses Op305f ----------
Op305f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3060] movea.w -(a0), a0 uses Op3060 ----------
Op3060:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3067] movea.w -(a7), a0 uses Op3067 ----------
Op3067:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3068] movea.w ($3333,a0), a0 uses Op3068 ----------
Op3068:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3070] movea.w ($33,a0,d3.w*2), a0 uses Op3070 ----------
Op3070:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3078] movea.w $3333.w, a0 uses Op3078 ----------
Op3078:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3079] movea.w $33333333.l, a0 uses Op3079 ----------
Op3079:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [307a] movea.w ($3333,pc), a0; =3335 uses Op307a ----------
Op307a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [307b] movea.w ($33,pc,d3.w*2), a0; =35 uses Op307b ----------
Op307b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [307c] movea.w #$3333, a0 uses Op307c ----------
Op307c:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3080] move.w d0, (a0) uses Op3080 ----------
Op3080:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3090] move.w (a0), (a0) uses Op3090 ----------
Op3090:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3098] move.w (a0)+, (a0) uses Op3098 ----------
Op3098:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [309f] move.w (a7)+, (a0) uses Op309f ----------
Op309f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30a0] move.w -(a0), (a0) uses Op30a0 ----------
Op30a0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30a7] move.w -(a7), (a0) uses Op30a7 ----------
Op30a7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30a8] move.w ($3333,a0), (a0) uses Op30a8 ----------
Op30a8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30b0] move.w ($33,a0,d3.w*2), (a0) uses Op30b0 ----------
Op30b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30b8] move.w $3333.w, (a0) uses Op30b8 ----------
Op30b8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30b9] move.w $33333333.l, (a0) uses Op30b9 ----------
Op30b9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30ba] move.w ($3333,pc), (a0); =3335 uses Op30ba ----------
Op30ba:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30bb] move.w ($33,pc,d3.w*2), (a0); =35 uses Op30bb ----------
Op30bb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30bc] move.w #$3333, (a0) uses Op30bc ----------
Op30bc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30c0] move.w d0, (a0)+ uses Op30c0 ----------
Op30c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30d0] move.w (a0), (a0)+ uses Op30d0 ----------
Op30d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30d8] move.w (a0)+, (a0)+ uses Op30d8 ----------
Op30d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30df] move.w (a7)+, (a0)+ uses Op30df ----------
Op30df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30e0] move.w -(a0), (a0)+ uses Op30e0 ----------
Op30e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30e7] move.w -(a7), (a0)+ uses Op30e7 ----------
Op30e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30e8] move.w ($3333,a0), (a0)+ uses Op30e8 ----------
Op30e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30f0] move.w ($33,a0,d3.w*2), (a0)+ uses Op30f0 ----------
Op30f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30f8] move.w $3333.w, (a0)+ uses Op30f8 ----------
Op30f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30f9] move.w $33333333.l, (a0)+ uses Op30f9 ----------
Op30f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30fa] move.w ($3333,pc), (a0)+; =3335 uses Op30fa ----------
Op30fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30fb] move.w ($33,pc,d3.w*2), (a0)+; =35 uses Op30fb ----------
Op30fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [30fc] move.w #$3333, (a0)+ uses Op30fc ----------
Op30fc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3100] move.w d0, -(a0) uses Op3100 ----------
Op3100:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3110] move.w (a0), -(a0) uses Op3110 ----------
Op3110:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3118] move.w (a0)+, -(a0) uses Op3118 ----------
Op3118:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [311f] move.w (a7)+, -(a0) uses Op311f ----------
Op311f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3120] move.w -(a0), -(a0) uses Op3120 ----------
Op3120:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3127] move.w -(a7), -(a0) uses Op3127 ----------
Op3127:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3128] move.w ($3333,a0), -(a0) uses Op3128 ----------
Op3128:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3130] move.w ($33,a0,d3.w*2), -(a0) uses Op3130 ----------
Op3130:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3138] move.w $3333.w, -(a0) uses Op3138 ----------
Op3138:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3139] move.w $33333333.l, -(a0) uses Op3139 ----------
Op3139:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [313a] move.w ($3333,pc), -(a0); =3335 uses Op313a ----------
Op313a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [313b] move.w ($33,pc,d3.w*2), -(a0); =35 uses Op313b ----------
Op313b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [313c] move.w #$3333, -(a0) uses Op313c ----------
Op313c:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3140] move.w d0, ($3333,a0) uses Op3140 ----------
Op3140:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3150] move.w (a0), ($3333,a0) uses Op3150 ----------
Op3150:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3158] move.w (a0)+, ($3333,a0) uses Op3158 ----------
Op3158:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [315f] move.w (a7)+, ($3333,a0) uses Op315f ----------
Op315f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3160] move.w -(a0), ($3333,a0) uses Op3160 ----------
Op3160:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3167] move.w -(a7), ($3333,a0) uses Op3167 ----------
Op3167:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3168] move.w ($3333,a0), ($3333,a0) uses Op3168 ----------
Op3168:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3170] move.w ($33,a0,d3.w*2), ($3333,a0) uses Op3170 ----------
Op3170:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3178] move.w $3333.w, ($3333,a0) uses Op3178 ----------
Op3178:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3179] move.w $33333333.l, ($3333,a0) uses Op3179 ----------
Op3179:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [317a] move.w ($3333,pc), ($3333,a0); =3335 uses Op317a ----------
Op317a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [317b] move.w ($33,pc,d3.w*2), ($3333,a0); =35 uses Op317b ----------
Op317b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [317c] move.w #$3333, ($3333,a0) uses Op317c ----------
Op317c:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3180] move.w d0, ($33,a0,d3.w*2) uses Op3180 ----------
Op3180:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3190] move.w (a0), ($33,a0,d3.w*2) uses Op3190 ----------
Op3190:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3198] move.w (a0)+, ($33,a0,d3.w*2) uses Op3198 ----------
Op3198:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [319f] move.w (a7)+, ($33,a0,d3.w*2) uses Op319f ----------
Op319f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31a0] move.w -(a0), ($33,a0,d3.w*2) uses Op31a0 ----------
Op31a0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31a7] move.w -(a7), ($33,a0,d3.w*2) uses Op31a7 ----------
Op31a7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31a8] move.w ($3333,a0), ($33,a0,d3.w*2) uses Op31a8 ----------
Op31a8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31b0] move.w ($33,a0,d3.w*2), ($33,a0,d3.w*2) uses Op31b0 ----------
Op31b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31b8] move.w $3333.w, ($33,a0,d3.w*2) uses Op31b8 ----------
Op31b8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31b9] move.w $33333333.l, ($33,a0,d3.w*2) uses Op31b9 ----------
Op31b9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31ba] move.w ($3333,pc), ($33,a0,d3.w*2); =3335 uses Op31ba ----------
Op31ba:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31bb] move.w ($33,pc,d3.w*2), ($33,a0,d3.w*2); =35 uses Op31bb ----------
Op31bb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31bc] move.w #$3333, ($33,a0,d3.w*2) uses Op31bc ----------
Op31bc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  mov r2,r2,lsr #9
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31c0] move.w d0, $3333.w uses Op31c0 ----------
Op31c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31d0] move.w (a0), $3333.w uses Op31d0 ----------
Op31d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31d8] move.w (a0)+, $3333.w uses Op31d8 ----------
Op31d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31df] move.w (a7)+, $3333.w uses Op31df ----------
Op31df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31e0] move.w -(a0), $3333.w uses Op31e0 ----------
Op31e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31e7] move.w -(a7), $3333.w uses Op31e7 ----------
Op31e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31e8] move.w ($3333,a0), $3333.w uses Op31e8 ----------
Op31e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31f0] move.w ($33,a0,d3.w*2), $3333.w uses Op31f0 ----------
Op31f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31f8] move.w $3333.w, $3333.w uses Op31f8 ----------
Op31f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31f9] move.w $33333333.l, $3333.w uses Op31f9 ----------
Op31f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31fa] move.w ($3333,pc), $3333.w; =3335 uses Op31fa ----------
Op31fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31fb] move.w ($33,pc,d3.w*2), $3333.w; =35 uses Op31fb ----------
Op31fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [31fc] move.w #$3333, $3333.w uses Op31fc ----------
Op31fc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33c0] move.w d0, $33333333.l uses Op33c0 ----------
Op33c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33d0] move.w (a0), $33333333.l uses Op33d0 ----------
Op33d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33d8] move.w (a0)+, $33333333.l uses Op33d8 ----------
Op33d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33df] move.w (a7)+, $33333333.l uses Op33df ----------
Op33df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33e0] move.w -(a0), $33333333.l uses Op33e0 ----------
Op33e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33e7] move.w -(a7), $33333333.l uses Op33e7 ----------
Op33e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33e8] move.w ($3333,a0), $33333333.l uses Op33e8 ----------
Op33e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33f0] move.w ($33,a0,d3.w*2), $33333333.l uses Op33f0 ----------
Op33f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33f8] move.w $3333.w, $33333333.l uses Op33f8 ----------
Op33f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33f9] move.w $33333333.l, $33333333.l uses Op33f9 ----------
Op33f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33fa] move.w ($3333,pc), $33333333.l; =3335 uses Op33fa ----------
Op33fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33fb] move.w ($33,pc,d3.w*2), $33333333.l; =35 uses Op33fb ----------
Op33fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [33fc] move.w #$3333, $33333333.l uses Op33fc ----------
Op33fc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ec0] move.w d0, (a7)+ uses Op3ec0 ----------
Op3ec0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ed0] move.w (a0), (a7)+ uses Op3ed0 ----------
Op3ed0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ed8] move.w (a0)+, (a7)+ uses Op3ed8 ----------
Op3ed8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3edf] move.w (a7)+, (a7)+ uses Op3edf ----------
Op3edf:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ee0] move.w -(a0), (a7)+ uses Op3ee0 ----------
Op3ee0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ee7] move.w -(a7), (a7)+ uses Op3ee7 ----------
Op3ee7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ee8] move.w ($3333,a0), (a7)+ uses Op3ee8 ----------
Op3ee8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ef0] move.w ($33,a0,d3.w*2), (a7)+ uses Op3ef0 ----------
Op3ef0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ef8] move.w $3333.w, (a7)+ uses Op3ef8 ----------
Op3ef8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3ef9] move.w $33333333.l, (a7)+ uses Op3ef9 ----------
Op3ef9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3efa] move.w ($3333,pc), (a7)+; =3335 uses Op3efa ----------
Op3efa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3efb] move.w ($33,pc,d3.w*2), (a7)+; =35 uses Op3efb ----------
Op3efb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3efc] move.w #$3333, (a7)+ uses Op3efc ----------
Op3efc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f00] move.w d0, -(a7) uses Op3f00 ----------
Op3f00:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r1:
  ldrsh r1,[r7,r0]

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f10] move.w (a0), -(a7) uses Op3f10 ----------
Op3f10:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f18] move.w (a0)+, -(a7) uses Op3f18 ----------
Op3f18:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f1f] move.w (a7)+, -(a7) uses Op3f1f ----------
Op3f1f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f20] move.w -(a0), -(a7) uses Op3f20 ----------
Op3f20:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f27] move.w -(a7), -(a7) uses Op3f27 ----------
Op3f27:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f28] move.w ($3333,a0), -(a7) uses Op3f28 ----------
Op3f28:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f30] move.w ($33,a0,d3.w*2), -(a7) uses Op3f30 ----------
Op3f30:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f38] move.w $3333.w, -(a7) uses Op3f38 ----------
Op3f38:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f39] move.w $33333333.l, -(a7) uses Op3f39 ----------
Op3f39:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f3a] move.w ($3333,pc), -(a7); =3335 uses Op3f3a ----------
Op3f3a:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f3b] move.w ($33,pc,d3.w*2), -(a7); =35 uses Op3f3b ----------
Op3f3b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r1:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r1,r0,asl #16
  mov r1,r1,asr #16

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [3f3c] move.w #$3333, -(a7) uses Op3f3c ----------
Op3f3c:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r1:
  mov r1,r0,asl #0

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=NZCV flags

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x0e00
  orr r2,r2,#0x1000 ;@ A0-7
  ldr r0,[r7,r2,lsr #7]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsr #7]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4000] negx.b d0 uses Op4000 ----------
Op4000:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsb r0,[r7,r10]

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4010] negx.b (a0) uses Op4010 ----------
Op4010:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4018] negx.b (a0)+ uses Op4018 ----------
Op4018:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [401f] negx.b (a7)+ uses Op401f ----------
Op401f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4020] negx.b -(a0) uses Op4020 ----------
Op4020:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4027] negx.b -(a7) uses Op4027 ----------
Op4027:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4028] negx.b ($3333,a0) uses Op4028 ----------
Op4028:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4030] negx.b ($33,a0,d3.w*2) uses Op4030 ----------
Op4030:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4038] negx.b $3333.w uses Op4038 ----------
Op4038:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4039] negx.b $33333333.l uses Op4039 ----------
Op4039:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #24
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #24
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4040] negx.w d0 uses Op4040 ----------
Op4040:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4050] negx.w (a0) uses Op4050 ----------
Op4050:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4058] negx.w (a0)+ uses Op4058 ----------
Op4058:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [405f] negx.w (a7)+ uses Op405f ----------
Op405f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4060] negx.w -(a0) uses Op4060 ----------
Op4060:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4067] negx.w -(a7) uses Op4067 ----------
Op4067:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4068] negx.w ($3333,a0) uses Op4068 ----------
Op4068:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4070] negx.w ($33,a0,d3.w*2) uses Op4070 ----------
Op4070:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4078] negx.w $3333.w uses Op4078 ----------
Op4078:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4079] negx.w $33333333.l uses Op4079 ----------
Op4079:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  mov r0,r0,lsl #16
  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  movs r1,r1,asr #16
  orreq r9,r9,#0x40000000 ;@ possily missed Z
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4080] negx.l d0 uses Op4080 ----------
Op4080:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4090] negx.l (a0) uses Op4090 ----------
Op4090:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4098] negx.l (a0)+ uses Op4098 ----------
Op4098:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [409f] negx.l (a7)+ uses Op409f ----------
Op409f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40a0] negx.l -(a0) uses Op40a0 ----------
Op40a0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40a7] negx.l -(a7) uses Op40a7 ----------
Op40a7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40a8] negx.l ($3333,a0) uses Op40a8 ----------
Op40a8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40b0] negx.l ($33,a0,d3.w*2) uses Op40b0 ----------
Op40b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40b8] negx.l $3333.w uses Op40b8 ----------
Op40b8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40b9] negx.l $33333333.l uses Op40b9 ----------
Op40b9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Negx:
;@ Get X bit:
  ldrb r2,[r7,#0x45]
  mvn r2,r2,lsl #28 ;@ Invert it
  msr cpsr_flg,r2 ;@ Get into Carry

  rscs r1,r0,#0 ;@ do arithmetic
  orr r3,r9,#0xb0000000 ;@ for old Z
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  andeq r9,r9,r3 ;@ fix Z

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40c0] move sr, d0 uses Op40c0 ----------
Op40c0:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strh r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40d0] move sr, (a0) uses Op40d0 ----------
Op40d0:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40d8] move sr, (a0)+ uses Op40d8 ----------
Op40d8:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40df] move sr, (a7)+ uses Op40df ----------
Op40df:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40e0] move sr, -(a0) uses Op40e0 ----------
Op40e0:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40e7] move sr, -(a7) uses Op40e7 ----------
Op40e7:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40e8] move sr, ($3333,a0) uses Op40e8 ----------
Op40e8:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40f0] move sr, ($33,a0,d3.w*2) uses Op40f0 ----------
Op40f0:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40f8] move sr, $3333.w uses Op40f8 ----------
Op40f8:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [40f9] move sr, $33333333.l uses Op40f9 ----------
Op40f9:
  mov r1,r9,lsr #28   ;@ ____NZCV
  eor r0,r1,r1,ror #1 ;@ Bit 0=C^V
  tst r0,#1           ;@ 1 if C!=V
  eorne r1,r1,#3      ;@ ____NZVC

  ldrb r0,[r7,#0x45]  ;@ X bit
  ldrb r2,[r7,#0x44]  ;@ Include SR high
  and r0,r0,#0x02
  orr r1,r1,r2,lsl #8
  orr r1,r1,r0,lsl #3 ;@ ___XNZVC

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4180]  uses Op4180 ----------
Op4180:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap4180
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap4180
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap4180: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#50 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4190]  uses Op4190 ----------
Op4190:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap4190
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap4190
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap4190: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4198]  uses Op4198 ----------
Op4198:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap4198
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap4198
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap4198: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [419f]  uses Op419f ----------
Op419f:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap419f
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap419f
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap419f: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41a0]  uses Op41a0 ----------
Op41a0:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41a0
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41a0
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41a0: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#56 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41a7]  uses Op41a7 ----------
Op41a7:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41a7
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41a7
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41a7: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#56 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41a8]  uses Op41a8 ----------
Op41a8:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41a8
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41a8
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41a8: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#58 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41b0]  uses Op41b0 ----------
Op41b0:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41b0
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41b0
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41b0: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#60 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41b8]  uses Op41b8 ----------
Op41b8:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41b8
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41b8
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41b8: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#58 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41b9]  uses Op41b9 ----------
Op41b9:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41b9
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41b9
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41b9: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#62 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41ba]  uses Op41ba ----------
Op41ba:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($3333,pc)' into r10:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r10,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41ba
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41ba
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41ba: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#58 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41bb]  uses Op41bb ----------
Op41bb:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r10:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r10,r2,r0,asr #8 ;@ r10=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41bb
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41bb
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41bb: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#60 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41bc]  uses Op41bc ----------
Op41bc:
;@ Get EA into r10 and value into r0:
;@ EaCalc : Get '#$3333' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r10) into r0:
  mov r0,r10,asl #16

;@ Get register operand into r1:
;@ EaCalc : Get register index into r1:
  and r1,r8,#0x0e00
  mov r1,r1,lsr #7
;@ EaRead : Read register[r1] into r1:
  ldrsh r1,[r7,r1]
  mov r1,r1,asl #16

;@ get flags, including undocumented ones
  and r3,r9,#0x80000000
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ is reg negative?
  bmi chktrap41bc
;@ Do arithmetic:
  cmp r1,r0
  bicgt r9,r9,#0x80000000 ;@ N
  bgt chktrap41bc
;@ old N remains
  bic r9,r9,#0x80000000 ;@ N
  orr r9,r9,r3
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

chktrap41bc: ;@ CHK exception:
  mov r0,#0x18
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#54 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41d0] lea (a0), a0 uses Op41d0 ----------
Op41d0:
;@ EaCalc : Get '(a0)' into r1:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r1,[r7,r2,lsl #2]
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41e8] lea ($3333,a0), a0 uses Op41e8 ----------
Op41e8:
;@ EaCalc : Get '($3333,a0)' into r1:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r1,r0,r2 ;@ Add on offset
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41f0] lea ($33,a0,d3.w*2), a0 uses Op41f0 ----------
Op41f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r1:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r1,r2,r3 ;@ r1=Disp+An+Rn
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41f8] lea $3333.w, a0 uses Op41f8 ----------
Op41f8:
;@ EaCalc : Get '$3333.w' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch Absolute Short address
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41f9] lea $33333333.l, a0 uses Op41f9 ----------
Op41f9:
;@ EaCalc : Get '$33333333.l' into r1:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r1,r0,r2,lsl #16
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41fa] lea ($3333,pc), a0; =3335 uses Op41fa ----------
Op41fa:
;@ EaCalc : Get '($3333,pc)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r1,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [41fb] lea ($33,pc,d3.w*2), a0; =35 uses Op41fb ----------
Op41fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r1,r2,r0,asr #8 ;@ r1=Disp+PC+Rn
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0e00
  orr r0,r0,#0x1000 ;@ A0-7
;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsr #7]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4200] clr.b d0 uses Op4200 ----------
Op4200:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4210] clr.b (a0) uses Op4210 ----------
Op4210:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4218] clr.b (a0)+ uses Op4218 ----------
Op4218:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [421f] clr.b (a7)+ uses Op421f ----------
Op421f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4220] clr.b -(a0) uses Op4220 ----------
Op4220:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4227] clr.b -(a7) uses Op4227 ----------
Op4227:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4228] clr.b ($3333,a0) uses Op4228 ----------
Op4228:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4230] clr.b ($33,a0,d3.w*2) uses Op4230 ----------
Op4230:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4238] clr.b $3333.w uses Op4238 ----------
Op4238:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4239] clr.b $33333333.l uses Op4239 ----------
Op4239:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4240] clr.w d0 uses Op4240 ----------
Op4240:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4250] clr.w (a0) uses Op4250 ----------
Op4250:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4258] clr.w (a0)+ uses Op4258 ----------
Op4258:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [425f] clr.w (a7)+ uses Op425f ----------
Op425f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4260] clr.w -(a0) uses Op4260 ----------
Op4260:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4267] clr.w -(a7) uses Op4267 ----------
Op4267:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4268] clr.w ($3333,a0) uses Op4268 ----------
Op4268:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4270] clr.w ($33,a0,d3.w*2) uses Op4270 ----------
Op4270:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4278] clr.w $3333.w uses Op4278 ----------
Op4278:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4279] clr.w $33333333.l uses Op4279 ----------
Op4279:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4280] clr.l d0 uses Op4280 ----------
Op4280:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4290] clr.l (a0) uses Op4290 ----------
Op4290:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4298] clr.l (a0)+ uses Op4298 ----------
Op4298:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [429f] clr.l (a7)+ uses Op429f ----------
Op429f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42a0] clr.l -(a0) uses Op42a0 ----------
Op42a0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42a7] clr.l -(a7) uses Op42a7 ----------
Op42a7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42a8] clr.l ($3333,a0) uses Op42a8 ----------
Op42a8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42b0] clr.l ($33,a0,d3.w*2) uses Op42b0 ----------
Op42b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42b8] clr.l $3333.w uses Op42b8 ----------
Op42b8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [42b9] clr.l $33333333.l uses Op42b9 ----------
Op42b9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16

;@ Clear:
  mov r1,#0
  mov r9,#0x40000000 ;@ NZCV=0100

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4400] neg.b d0 uses Op4400 ----------
Op4400:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsb r0,[r7,r10]

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4410] neg.b (a0) uses Op4410 ----------
Op4410:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4418] neg.b (a0)+ uses Op4418 ----------
Op4418:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [441f] neg.b (a7)+ uses Op441f ----------
Op441f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4420] neg.b -(a0) uses Op4420 ----------
Op4420:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4427] neg.b -(a7) uses Op4427 ----------
Op4427:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4428] neg.b ($3333,a0) uses Op4428 ----------
Op4428:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4430] neg.b ($33,a0,d3.w*2) uses Op4430 ----------
Op4430:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4438] neg.b $3333.w uses Op4438 ----------
Op4438:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4439] neg.b $33333333.l uses Op4439 ----------
Op4439:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Neg:
  mov r0,r0,lsl #24
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #24

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4440] neg.w d0 uses Op4440 ----------
Op4440:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4450] neg.w (a0) uses Op4450 ----------
Op4450:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4458] neg.w (a0)+ uses Op4458 ----------
Op4458:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [445f] neg.w (a7)+ uses Op445f ----------
Op445f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4460] neg.w -(a0) uses Op4460 ----------
Op4460:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4467] neg.w -(a7) uses Op4467 ----------
Op4467:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4468] neg.w ($3333,a0) uses Op4468 ----------
Op4468:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4470] neg.w ($33,a0,d3.w*2) uses Op4470 ----------
Op4470:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4478] neg.w $3333.w uses Op4478 ----------
Op4478:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4479] neg.w $33333333.l uses Op4479 ----------
Op4479:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Neg:
  mov r0,r0,lsl #16
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit
  mov r1,r1,asr #16

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4480] neg.l d0 uses Op4480 ----------
Op4480:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4490] neg.l (a0) uses Op4490 ----------
Op4490:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4498] neg.l (a0)+ uses Op4498 ----------
Op4498:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [449f] neg.l (a7)+ uses Op449f ----------
Op449f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44a0] neg.l -(a0) uses Op44a0 ----------
Op44a0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44a7] neg.l -(a7) uses Op44a7 ----------
Op44a7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44a8] neg.l ($3333,a0) uses Op44a8 ----------
Op44a8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44b0] neg.l ($33,a0,d3.w*2) uses Op44b0 ----------
Op44b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44b8] neg.l $3333.w uses Op44b8 ----------
Op44b8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44b9] neg.l $33333333.l uses Op44b9 ----------
Op44b9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Neg:
  rsbs r1,r0,#0
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44c0] move d0, ccr uses Op44c0 ----------
Op44c0:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r0:
  ldrsh r0,[r7,r0]

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44d0] move (a0), ccr uses Op44d0 ----------
Op44d0:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44d8] move (a0)+, ccr uses Op44d8 ----------
Op44d8:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44df] move (a7)+, ccr uses Op44df ----------
Op44df:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44e0] move -(a0), ccr uses Op44e0 ----------
Op44e0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44e7] move -(a7), ccr uses Op44e7 ----------
Op44e7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44e8] move ($3333,a0), ccr uses Op44e8 ----------
Op44e8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44f0] move ($33,a0,d3.w*2), ccr uses Op44f0 ----------
Op44f0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44f8] move $3333.w, ccr uses Op44f8 ----------
Op44f8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44f9] move $33333333.l, ccr uses Op44f9 ----------
Op44f9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44fa] move ($3333,pc), ccr; =3335 uses Op44fa ----------
Op44fa:
;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44fb] move ($33,pc,d3.w*2), ccr; =35 uses Op44fb ----------
Op44fb:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [44fc] move #$3333, ccr uses Op44fc ----------
Op44fc:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4600] not.b d0 uses Op4600 ----------
Op4600:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsb r0,[r7,r10]

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r10]:
  strb r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4610] not.b (a0) uses Op4610 ----------
Op4610:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4618] not.b (a0)+ uses Op4618 ----------
Op4618:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [461f] not.b (a7)+ uses Op461f ----------
Op461f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4620] not.b -(a0) uses Op4620 ----------
Op4620:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4627] not.b -(a7) uses Op4627 ----------
Op4627:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4628] not.b ($3333,a0) uses Op4628 ----------
Op4628:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4630] not.b ($33,a0,d3.w*2) uses Op4630 ----------
Op4630:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4638] not.b $3333.w uses Op4638 ----------
Op4638:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4639] not.b $33333333.l uses Op4639 ----------
Op4639:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24
  mov r0,r0,asr #24

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4640] not.w d0 uses Op4640 ----------
Op4640:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4650] not.w (a0) uses Op4650 ----------
Op4650:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4658] not.w (a0)+ uses Op4658 ----------
Op4658:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [465f] not.w (a7)+ uses Op465f ----------
Op465f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4660] not.w -(a0) uses Op4660 ----------
Op4660:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4667] not.w -(a7) uses Op4667 ----------
Op4667:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4668] not.w ($3333,a0) uses Op4668 ----------
Op4668:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4670] not.w ($33,a0,d3.w*2) uses Op4670 ----------
Op4670:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4678] not.w $3333.w uses Op4678 ----------
Op4678:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4679] not.w $33333333.l uses Op4679 ----------
Op4679:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4680] not.l d0 uses Op4680 ----------
Op4680:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4690] not.l (a0) uses Op4690 ----------
Op4690:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4698] not.l (a0)+ uses Op4698 ----------
Op4698:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [469f] not.l (a7)+ uses Op469f ----------
Op469f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46a0] not.l -(a0) uses Op46a0 ----------
Op46a0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46a7] not.l -(a7) uses Op46a7 ----------
Op46a7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46a8] not.l ($3333,a0) uses Op46a8 ----------
Op46a8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46b0] not.l ($33,a0,d3.w*2) uses Op46b0 ----------
Op46b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46b8] not.l $3333.w uses Op46b8 ----------
Op46b8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46b9] not.l $33333333.l uses Op46b9 ----------
Op46b9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

;@ Not:
  mvn r1,r0
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46c0] move d0, sr uses Op46c0 ----------
Op46c0:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46c0 ;@ No

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r0:
  ldrsh r0,[r7,r0]

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46c0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46c0:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46c0
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46c0:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46c0:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46d0] move (a0), sr uses Op46d0 ----------
Op46d0:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46d0 ;@ No

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46d0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46d0:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46d0
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46d0:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46d0:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46d8] move (a0)+, sr uses Op46d8 ----------
Op46d8:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46d8 ;@ No

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46d8
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46d8:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46d8
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46d8:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46d8:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46df] move (a7)+, sr uses Op46df ----------
Op46df:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46df ;@ No

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46df
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46df:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46df
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46df:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46df:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46e0] move -(a0), sr uses Op46e0 ----------
Op46e0:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46e0 ;@ No

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46e0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46e0:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46e0
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46e0:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46e0:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46e7] move -(a7), sr uses Op46e7 ----------
Op46e7:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46e7 ;@ No

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46e7
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46e7:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46e7
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46e7:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46e7:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46e8] move ($3333,a0), sr uses Op46e8 ----------
Op46e8:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46e8 ;@ No

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46e8
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46e8:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46e8
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46e8:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46e8:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46f0] move ($33,a0,d3.w*2), sr uses Op46f0 ----------
Op46f0:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46f0 ;@ No

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46f0
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46f0:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46f0
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46f0:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46f0:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46f8] move $3333.w, sr uses Op46f8 ----------
Op46f8:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46f8 ;@ No

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46f8
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46f8:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46f8
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46f8:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46f8:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46f9] move $33333333.l, sr uses Op46f9 ----------
Op46f9:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46f9 ;@ No

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46f9
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46f9:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46f9
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46f9:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46f9:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46fa] move ($3333,pc), sr; =3335 uses Op46fa ----------
Op46fa:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46fa ;@ No

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ EaRead : Read '($3333,pc)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46fa
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46fa:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46fa
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46fa:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46fa:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46fb] move ($33,pc,d3.w*2), sr; =35 uses Op46fb ----------
Op46fb:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46fb ;@ No

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46fb
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46fb:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46fb
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46fb:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46fb:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [46fc] move #$3333, sr uses Op46fc ----------
Op46fc:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode46fc ;@ No

;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap46fc
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap46fc:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts46fc
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts46fc:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode46fc:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4800]  uses Op4800 ----------
Op4800:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldrb r0,[r7,r10,lsl #2]
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4800

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

finish4800:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#6 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4810]  uses Op4810 ----------
Op4810:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4810

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4810:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4818]  uses Op4818 ----------
Op4818:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4818

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4818:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [481f]  uses Op481f ----------
Op481f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish481f

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish481f:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4820]  uses Op4820 ----------
Op4820:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4820

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4820:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4827]  uses Op4827 ----------
Op4827:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4827

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4827:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4828]  uses Op4828 ----------
Op4828:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4828

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4828:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4830]  uses Op4830 ----------
Op4830:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4830

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4830:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4838]  uses Op4838 ----------
Op4838:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4838

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4838:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4839]  uses Op4839 ----------
Op4839:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  ldrb r2,[r7,#0x45]
  tst r2,#2
  mov r2,r0
  addne r2,r0,#0x01000000 ;@ add X
  rsbs r1,r2,#0x9a000000 ;@ do arithmetic
  bic r9,r9,#0xb0000000 ;@ clear all flags, except Z
  orrmi r9,r9,#0x80000000 ;@ N
  cmp r1,#0x9a000000
  beq finish4839

  mvn r3,r9,lsr #3 ;@ Undefined V behavior
  and r2,r1,#0x0f000000
  cmp r2,#0x0a000000
  andeq r1,r1,#0xf0000000
  addeq r1,r1,#0x10000000
  and r3,r3,r1,lsr #3 ;@ Undefined V behavior part II
  tst r1,r1
  orr r9,r9,r3 ;@ save V
  bicne r9,r9,#0x40000000 ;@ Z
  orr r9,r9,#0x20000000 ;@ C

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

finish4839:
  mov r2,r9,lsr #28
  strb r2, [r7,#0x45]
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4840] swap d0 uses Op4840 ----------
Op4840:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  mov r1,r0,ror #16
  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4850] pea (a0) uses Op4850 ----------
Op4850:
;@ EaCalc : Get '(a0)' into r1:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r1,[r7,r2,lsl #2]

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4868] pea ($3333,a0) uses Op4868 ----------
Op4868:
;@ EaCalc : Get '($3333,a0)' into r1:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r1,r0,r2 ;@ Add on offset

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4870] pea ($33,a0,d3.w*2) uses Op4870 ----------
Op4870:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r1:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r1,r2,r3 ;@ r1=Disp+An+Rn

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4878] pea $3333.w uses Op4878 ----------
Op4878:
;@ EaCalc : Get '$3333.w' into r1:
  ldrsh r1,[r4],#2 ;@ Fetch Absolute Short address

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4879] pea $33333333.l uses Op4879 ----------
Op4879:
;@ EaCalc : Get '$33333333.l' into r1:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r1,r0,r2,lsl #16

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [487a] pea ($3333,pc); =3335 uses Op487a ----------
Op487a:
;@ EaCalc : Get '($3333,pc)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r1,r2,r0,asr #8 ;@ ($nn,PC)

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [487b] pea ($33,pc,d3.w*2); =35 uses Op487b ----------
Op487b:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r1:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r1,r2,r0,asr #8 ;@ r1=Disp+PC+Rn

  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7

  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4880] ext.w d0 uses Op4880 ----------
Op4880:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]

  mov r0,r0,asl #24
  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
  mov r1,r0,asr #24

;@ EaWrite: r1 into register[r10]:
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4890] movem.w d0-d1/d4-d5/a0-a1/a4-a5, (a0) uses Op4890 ----------
Op4890:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4890:
  tst r11,#1
  beq SkipReg4890

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '(a0)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4890:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4890

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48a0] movem.w d2-d3/d6-d7/a2-a3/a6-a7, -(a0) uses Op48a0 ----------
Op48a0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0x3c ;@ order reversed for -(An)

MoreReg48a0:
  tst r11,#1
  beq SkipReg48a0

  sub r9,r9,#2 ;@ Pre-decrement address
  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '-(a0)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  sub r5,r5,#4 ;@ Take some cycles

SkipReg48a0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#-4 ;@ r10=Next Register
  bne MoreReg48a0

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48a7] movem.w d2-d3/d6-d7/a2-a3/a6-a7, -(a7) uses Op48a7 ----------
Op48a7:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0x3c ;@ order reversed for -(An)

MoreReg48a7:
  tst r11,#1
  beq SkipReg48a7

  sub r9,r9,#2 ;@ Pre-decrement address
  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '-(a7)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  sub r5,r5,#4 ;@ Take some cycles

SkipReg48a7:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#-4 ;@ r10=Next Register
  bne MoreReg48a7

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48a8] movem.w d0-d1/d4-d5/a0-a1/a4-a5, ($3333,a0) uses Op48a8 ----------
Op48a8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($3333,a0)' into r9:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r9,r0,r2 ;@ Add on offset
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48a8:
  tst r11,#1
  beq SkipReg48a8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($3333,a0)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg48a8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48a8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48b0] movem.w d0-d1/d4-d5/a0-a1/a4-a5, ($33,a0,d3.w*2) uses Op48b0 ----------
Op48b0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r9:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r9,r2,r3 ;@ r9=Disp+An+Rn
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48b0:
  tst r11,#1
  beq SkipReg48b0

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg48b0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48b0

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48b8] movem.w d0-d1/d4-d5/a0-a1/a4-a5, $3333.w uses Op48b8 ----------
Op48b8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$3333.w' into r9:
  ldrsh r9,[r4],#2 ;@ Fetch Absolute Short address
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48b8:
  tst r11,#1
  beq SkipReg48b8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$3333.w' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg48b8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48b8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48b9] movem.w d0-d1/d4-d5/a0-a1/a4-a5, $33333333.l uses Op48b9 ----------
Op48b9:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$33333333.l' into r9:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r9,r0,r2,lsl #16
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48b9:
  tst r11,#1
  beq SkipReg48b9

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$33333333.l' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg48b9:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48b9

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48c0] ext.l d0 uses Op48c0 ----------
Op48c0:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  mov r0,r0,asl #16
  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags
  mov r1,r0,asr #16

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48d0] movem.l d0-d1/d4-d5/a0-a1/a4-a5, (a0) uses Op48d0 ----------
Op48d0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48d0:
  tst r11,#1
  beq SkipReg48d0

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '(a0)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg48d0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48d0

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48e0] movem.l d2-d3/d6-d7/a2-a3/a6-a7, -(a0) uses Op48e0 ----------
Op48e0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0x3c ;@ order reversed for -(An)

MoreReg48e0:
  tst r11,#1
  beq SkipReg48e0

  sub r9,r9,#4 ;@ Pre-decrement address
  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '-(a0)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  sub r5,r5,#8 ;@ Take some cycles

SkipReg48e0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#-4 ;@ r10=Next Register
  bne MoreReg48e0

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48e7] movem.l d2-d3/d6-d7/a2-a3/a6-a7, -(a7) uses Op48e7 ----------
Op48e7:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0x3c ;@ order reversed for -(An)

MoreReg48e7:
  tst r11,#1
  beq SkipReg48e7

  sub r9,r9,#4 ;@ Pre-decrement address
  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '-(a7)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  sub r5,r5,#8 ;@ Take some cycles

SkipReg48e7:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#-4 ;@ r10=Next Register
  bne MoreReg48e7

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48e8] movem.l d0-d1/d4-d5/a0-a1/a4-a5, ($3333,a0) uses Op48e8 ----------
Op48e8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($3333,a0)' into r9:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r9,r0,r2 ;@ Add on offset
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48e8:
  tst r11,#1
  beq SkipReg48e8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($3333,a0)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg48e8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48e8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48f0] movem.l d0-d1/d4-d5/a0-a1/a4-a5, ($33,a0,d3.w*2) uses Op48f0 ----------
Op48f0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r9:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r9,r2,r3 ;@ r9=Disp+An+Rn
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48f0:
  tst r11,#1
  beq SkipReg48f0

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg48f0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48f0

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48f8] movem.l d0-d1/d4-d5/a0-a1/a4-a5, $3333.w uses Op48f8 ----------
Op48f8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$3333.w' into r9:
  ldrsh r9,[r4],#2 ;@ Fetch Absolute Short address
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48f8:
  tst r11,#1
  beq SkipReg48f8

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$3333.w' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg48f8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48f8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [48f9] movem.l d0-d1/d4-d5/a0-a1/a4-a5, $33333333.l uses Op48f9 ----------
Op48f9:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$33333333.l' into r9:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r9,r0,r2,lsl #16
;@ r10=Register Index*4:
  mov r10,#0

MoreReg48f9:
  tst r11,#1
  beq SkipReg48f9

  ;@ Copy register to memory:
  ldr r1,[r7,r10] ;@ Load value from Dn/An
;@ EaWrite: Write r1 into '$33333333.l' (address in r9):
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg48f9:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg48f9

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a00] tst.b d0 uses Op4a00 ----------
Op4a00:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldrb r0,[r7,r0,lsl #2]
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a10] tst.b (a0) uses Op4a10 ----------
Op4a10:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a18] tst.b (a0)+ uses Op4a18 ----------
Op4a18:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a1f] tst.b (a7)+ uses Op4a1f ----------
Op4a1f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a20] tst.b -(a0) uses Op4a20 ----------
Op4a20:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a27] tst.b -(a7) uses Op4a27 ----------
Op4a27:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a28] tst.b ($3333,a0) uses Op4a28 ----------
Op4a28:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a30] tst.b ($33,a0,d3.w*2) uses Op4a30 ----------
Op4a30:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a38] tst.b $3333.w uses Op4a38 ----------
Op4a38:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a39] tst.b $33333333.l uses Op4a39 ----------
Op4a39:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a40] tst.w d0 uses Op4a40 ----------
Op4a40:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaRead : Read register[r0] into r0:
  ldrsh r0,[r7,r0]
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a50] tst.w (a0) uses Op4a50 ----------
Op4a50:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a58] tst.w (a0)+ uses Op4a58 ----------
Op4a58:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a5f] tst.w (a7)+ uses Op4a5f ----------
Op4a5f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a60] tst.w -(a0) uses Op4a60 ----------
Op4a60:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a67] tst.w -(a7) uses Op4a67 ----------
Op4a67:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a68] tst.w ($3333,a0) uses Op4a68 ----------
Op4a68:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a70] tst.w ($33,a0,d3.w*2) uses Op4a70 ----------
Op4a70:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a78] tst.w $3333.w uses Op4a78 ----------
Op4a78:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a79] tst.w $33333333.l uses Op4a79 ----------
Op4a79:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a80] tst.l d0 uses Op4a80 ----------
Op4a80:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a90] tst.l (a0) uses Op4a90 ----------
Op4a90:
;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a98] tst.l (a0)+ uses Op4a98 ----------
Op4a98:
;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4a9f] tst.l (a7)+ uses Op4a9f ----------
Op4a9f:
;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4aa0] tst.l -(a0) uses Op4aa0 ----------
Op4aa0:
;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4aa7] tst.l -(a7) uses Op4aa7 ----------
Op4aa7:
;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#4 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4aa8] tst.l ($3333,a0) uses Op4aa8 ----------
Op4aa8:
;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ab0] tst.l ($33,a0,d3.w*2) uses Op4ab0 ----------
Op4ab0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ab8] tst.l $3333.w uses Op4ab8 ----------
Op4ab8:
;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ab9] tst.l $33333333.l uses Op4ab9 ----------
Op4ab9:
;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r0) into r0:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r0,r0,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ac0]  uses Op4ac0 ----------
Op4ac0:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r1:
  ldrb r1,[r7,r10,lsl #2]
  mov r1,r1,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ad0]  uses Op4ad0 ----------
Op4ad0:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ad8]  uses Op4ad8 ----------
Op4ad8:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4adf]  uses Op4adf ----------
Op4adf:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ae0]  uses Op4ae0 ----------
Op4ae0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ae7]  uses Op4ae7 ----------
Op4ae7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ae8]  uses Op4ae8 ----------
Op4ae8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4af0]  uses Op4af0 ----------
Op4af0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4af8]  uses Op4af8 ----------
Op4af8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4af9]  uses Op4af9 ----------
Op4af9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r1:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r1,r0,asl #24

  adds r1,r1,#0 ;@ Defines NZ, clears CV
  mrs r9,cpsr ;@ r9=flags

  orr r1,r1,#0x80000000 ;@ set bit7
;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4c90] movem.w (a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4c90 ----------
Op4c90:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4c90:
  tst r11,#1
  beq SkipReg4c90

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4c90:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4c90

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4c98] movem.w (a0)+, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4c98 ----------
Op4c98:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4c98:
  tst r11,#1
  beq SkipReg4c98

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)+' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4c98:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4c98

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4c9f] movem.w (a7)+, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4c9f ----------
Op4c9f:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4c9f:
  tst r11,#1
  beq SkipReg4c9f

  ;@ Copy memory to register:
;@ EaRead : Read '(a7)+' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4c9f:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4c9f

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ca8] movem.w ($3333,a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4ca8 ----------
Op4ca8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($3333,a0)' into r9:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r9,r0,r2 ;@ Add on offset
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4ca8:
  tst r11,#1
  beq SkipReg4ca8

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,a0)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4ca8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4ca8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cb0] movem.w ($33,a0,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cb0 ----------
Op4cb0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r9:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r9,r2,r3 ;@ r9=Disp+An+Rn
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cb0:
  tst r11,#1
  beq SkipReg4cb0

  ;@ Copy memory to register:
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4cb0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cb0

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cb8] movem.w $3333.w, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cb8 ----------
Op4cb8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$3333.w' into r9:
  ldrsh r9,[r4],#2 ;@ Fetch Absolute Short address
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cb8:
  tst r11,#1
  beq SkipReg4cb8

  ;@ Copy memory to register:
;@ EaRead : Read '$3333.w' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4cb8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cb8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cb9] movem.w $33333333.l, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cb9 ----------
Op4cb9:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$33333333.l' into r9:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r9,r0,r2,lsl #16
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cb9:
  tst r11,#1
  beq SkipReg4cb9

  ;@ Copy memory to register:
;@ EaRead : Read '$33333333.l' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4cb9:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cb9

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cba] movem.w ($3333,pc), d0-d1/d4-d5/a0-a1/a4-a5; =3337 uses Op4cba ----------
Op4cba:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($3333,pc)' into r9:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r9,r2,r0,asr #8 ;@ ($nn,PC)
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cba:
  tst r11,#1
  beq SkipReg4cba

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,pc)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4cba:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cba

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cbb] movem.w ($33,pc,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5; =37 uses Op4cbb ----------
Op4cbb:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r9:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r9,r2,r0,asr #8 ;@ r9=Disp+PC+Rn
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cbb:
  tst r11,#1
  beq SkipReg4cbb

  ;@ Copy memory to register:
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x84] ;@ Call fetch16(r0) handler
  mov r0,r0,asl #16
  mov r0,r0,asr #16

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#2 ;@ Post-increment address
  sub r5,r5,#4 ;@ Take some cycles

SkipReg4cbb:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cbb

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cd0] movem.l (a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cd0 ----------
Op4cd0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cd0:
  tst r11,#1
  beq SkipReg4cd0

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cd0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cd0

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cd8] movem.l (a0)+, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cd8 ----------
Op4cd8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cd8:
  tst r11,#1
  beq SkipReg4cd8

  ;@ Copy memory to register:
;@ EaRead : Read '(a0)+' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cd8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cd8

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cdf] movem.l (a7)+, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cdf ----------
Op4cdf:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '(a0)' into r9:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r9,[r7,r2,lsl #2]
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cdf:
  tst r11,#1
  beq SkipReg4cdf

  ;@ Copy memory to register:
;@ EaRead : Read '(a7)+' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cdf:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cdf

;@ Write back address:
;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaWrite: r9 into register[r0]:
  str r9,[r7,r0,lsl #2]

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ce8] movem.l ($3333,a0), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4ce8 ----------
Op4ce8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($3333,a0)' into r9:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r9,r0,r2 ;@ Add on offset
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4ce8:
  tst r11,#1
  beq SkipReg4ce8

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,a0)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4ce8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4ce8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cf0] movem.l ($33,a0,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cf0 ----------
Op4cf0:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r9:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r9,r2,r3 ;@ r9=Disp+An+Rn
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cf0:
  tst r11,#1
  beq SkipReg4cf0

  ;@ Copy memory to register:
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cf0:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cf0

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cf8] movem.l $3333.w, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cf8 ----------
Op4cf8:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$3333.w' into r9:
  ldrsh r9,[r4],#2 ;@ Fetch Absolute Short address
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cf8:
  tst r11,#1
  beq SkipReg4cf8

  ;@ Copy memory to register:
;@ EaRead : Read '$3333.w' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cf8:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cf8

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cf9] movem.l $33333333.l, d0-d1/d4-d5/a0-a1/a4-a5 uses Op4cf9 ----------
Op4cf9:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '$33333333.l' into r9:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r9,r0,r2,lsl #16
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cf9:
  tst r11,#1
  beq SkipReg4cf9

  ;@ Copy memory to register:
;@ EaRead : Read '$33333333.l' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cf9:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cf9

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cfa] movem.l ($3333,pc), d0-d1/d4-d5/a0-a1/a4-a5; =3337 uses Op4cfa ----------
Op4cfa:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($3333,pc)' into r9:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r9,r2,r0,asr #8 ;@ ($nn,PC)
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cfa:
  tst r11,#1
  beq SkipReg4cfa

  ;@ Copy memory to register:
;@ EaRead : Read '($3333,pc)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cfa:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cfa

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4cfb] movem.l ($33,pc,d3.w*2), d0-d1/d4-d5/a0-a1/a4-a5; =37 uses Op4cfb ----------
Op4cfb:
  stmdb sp!,{r9} ;@ Push r9
  ldrh r11,[r4],#2 ;@ r11=register mask

;@ Get the address into r9:
;@ EaCalc : Get '($33,pc,d3.w*2)' into r9:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r9,r2,r0,asr #8 ;@ r9=Disp+PC+Rn
;@ r10=Register Index*4:
  mov r10,#0

MoreReg4cfb:
  tst r11,#1
  beq SkipReg4cfb

  ;@ Copy memory to register:
;@ EaRead : Read '($33,pc,d3.w*2)' (address in r9) into r0:
  mov r0,r9
  mov lr,pc
  ldr pc,[r7,#0x88] ;@ Call fetch32(r0) handler

  str r0,[r7,r10] ;@ Save value into Dn/An
  add r9,r9,#4 ;@ Post-increment address
  sub r5,r5,#8 ;@ Take some cycles

SkipReg4cfb:
  movs r11,r11,lsr #1;@ Shift mask:
  add r10,r10,#4 ;@ r10=Next Register
  bne MoreReg4cfb

  ldmia sp!,{r9} ;@ Pop r9

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e40] trap #0 uses Op4e40 ----------
Op4e40:
  and r0,r8,#0xf ;@ Get trap number
  orr r0,r0,#0x20
  mov r0,r0,asl #2
  bl Exception

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#38 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e50] link a0,#$3333 uses Op4e50 ----------
Op4e50:
;@ Get An
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
  orr r10,r10,#0x8 ;@ A0-7
;@ EaRead : Read register[r10] into r1:
  ldr r1,[r7,r10,lsl #2]

  ldr r0,[r7,#0x3c] ;@ Get A7
  sub r0,r0,#4 ;@ A7-=4
  mov r11,r0

;@ Write An to Stack
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Save to An
;@ EaWrite: r11 into register[r10]:
  str r11,[r7,r10,lsl #2]

;@ Get offset:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  add r11,r11,r0 ;@ Add offset to A7
  str r11,[r7,#0x3c]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e57] link a7,#$3333 uses Op4e57 ----------
Op4e57:
  ldr r0,[r7,#0x3c] ;@ Get A7
  sub r0,r0,#4 ;@ A7-=4
  mov r11,r0
  mov r1,r0

;@ Write An to Stack
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler
;@ Save to An
;@ Get offset:
;@ EaCalc : Get '#$3333' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch immediate value
;@ EaRead : Read '#$3333' (address in r0) into r0:

  add r11,r11,r0 ;@ Add offset to A7
  str r11,[r7,#0x3c]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e58] unlk a0 uses Op4e58 ----------
Op4e58:
;@ Get An
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x0007
  orr r10,r10,#0x8 ;@ A0-7
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  add r11,r0,#4 ;@ A7+=4

;@ Pop An from stack:
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  str r11,[r7,#0x3c] ;@ Save A7

;@ An = value from stack:
;@ EaWrite: r0 into register[r10]:
  str r0,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e60] move a0, usp uses Op4e60 ----------
Op4e60:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode4e60 ;@ No

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
;@ EaRead : Read register[r0] into r0:
  ldr r0,[r7,r0,lsl #2]

  str r0,[r7,#0x48] ;@ Put in USP

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode4e60:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e68] move usp, a0 uses Op4e68 ----------
Op4e68:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode4e68 ;@ No

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x0007
  orr r0,r0,#0x8 ;@ A0-7
  ldr r1,[r7,#0x48] ;@ Get from USP

;@ EaWrite: r1 into register[r0]:
  str r1,[r7,r0,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode4e68:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e70] reset uses Op4e70 ----------
Op4e70:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode4e70 ;@ No

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#132 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode4e70:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e71] nop uses Op4e71 ----------
Op4e71:
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e72] stop uses Op4e72 ----------
Op4e72:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode4e72 ;@ No

  ldrh r0,[r4],#2 ;@ Fetch the immediate
  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap4e72
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap4e72:

  mov r0,#1
  str r0,[r7,#0x58] ;@ stopped

  mov r5,#0 ;@ eat cycles

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode4e72:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e73] rte uses Op4e73 ----------
Op4e73:
  ldrb r11,[r7,#0x44] ;@ Get SR high
  tst r11,#0x20 ;@ Check we are in supervisor mode
  beq WrongMode4e73 ;@ No

;@ Pop SR:
  ldr r0,[r7,#0x3c]
  add r1,r0,#2 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...
  mov r0,r0,ror #8
  and r0,r0,#0xa7 ;@ only take defined bits
  strb r0,[r7,#0x44] ;@ Store SR high

  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Pop PC:
  ldr r0,[r7,#0x3c]
  add r1,r0,#4 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r4,r0,r10 ;@ r4=Memory Base+PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

;@ A7 <-> OSP?
  and r11,r11,#0x20
  ldrb r1,[r7,#0x44] ;@ Get other SR high
  and r1,r1,#0x20
  teq r11,r1 ;@ r11 xor r1
  beq no_sp_swap4e73
 ;@ swap OSP and A7:
  ldr r11,[r7,#0x3C] ;@ Get A7
  ldr r1, [r7,#0x48] ;@ Get OSP
  str r1, [r7,#0x3C]
  str r11,[r7,#0x48]
no_sp_swap4e73:
;@ CheckInterrupt:
  ldrb r0,[r7,#0x47] ;@ Get IRQ level
  tst r0,r0
  beq NoInts4e73
  cmp r0,#6 ;@ irq>6 ?
  ldrleb r1,[r7,#0x44] ;@ Get SR high: T_S__III
  andle r1,r1,#7 ;@ Get interrupt mask
  cmple r0,r1 ;@ irq<=6: Is irq<=mask ?
  blgt DoInterrupt
NoInts4e73:

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

WrongMode4e73:
  sub r4,r4,#2 ;@ this opcode wasn't executed - go back
  mov r0,#0x20 ;@ privilege violation
  bl Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#34 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e75] rts uses Op4e75 ----------
Op4e75:
  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Pop PC:
  ldr r0,[r7,#0x3c]
  add r1,r0,#4 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r4,r0,r10 ;@ r4=Memory Base+PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e76] trapv uses Op4e76 ----------
Op4e76:
  tst r9,#0x10000000
  subne r5,r5,#30
  movne r0,#0x1c ;@ TRAPV exception
  blne Exception
  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e77] rtr uses Op4e77 ----------
Op4e77:
;@ Pop SR:
  ldr r0,[r7,#0x3c]
  add r1,r0,#2 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler

  eor r1,r0,r0,ror #1 ;@ Bit 0=C^V
  mov r2,r0,lsr #3    ;@ r2=___XN
  tst r1,#1           ;@ 1 if C!=V
  eorne r0,r0,#3      ;@ ___XNZCV
  strb r2,[r7,#0x45]  ;@ Store X bit
  mov r9,r0,lsl #28   ;@ r9=NZCV...

  ldr r10,[r7,#0x60] ;@ Get Memory base
;@ Pop PC:
  ldr r0,[r7,#0x3c]
  add r1,r0,#4 ;@ Postincrement A7
  str r1,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler
  add r4,r0,r10 ;@ r4=Memory Base+PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4e90] jsr (a0) uses Op4e90 ----------
Op4e90:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ea8] jsr ($3333,a0) uses Op4ea8 ----------
Op4ea8:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eb0] jsr ($33,a0,d3.w*2) uses Op4eb0 ----------
Op4eb0:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eb8] jsr $3333.w uses Op4eb8 ----------
Op4eb8:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eb9] jsr $33333333.l uses Op4eb9 ----------
Op4eb9:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4eba] jsr ($3333,pc); =3335 uses Op4eba ----------
Op4eba:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ebb] jsr ($33,pc,d3.w*2); =35 uses Op4ebb ----------
Op4ebb:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ Jump - Get new PC from r0
;@ Jsr - Push old PC first
  sub r1,r4,r10 ;@ r1 = Old PC
  add r4,r0,r10 ;@ r4 = Memory Base + New PC
  mov r1,r1,lsl #8
  mov r1,r1,asr #8

;@ Push r1 onto stack
  ldr r0,[r7,#0x3c]
  sub r0,r0,#4 ;@ Predecrement A7
  str r0,[r7,#0x3c] ;@ Save A7
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ed0] jmp (a0) uses Op4ed0 ----------
Op4ed0:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ee8] jmp ($3333,a0) uses Op4ee8 ----------
Op4ee8:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ef0] jmp ($33,a0,d3.w*2) uses Op4ef0 ----------
Op4ef0:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ef8] jmp $3333.w uses Op4ef8 ----------
Op4ef8:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4ef9] jmp $33333333.l uses Op4ef9 ----------
Op4ef9:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4efa] jmp ($3333,pc); =3335 uses Op4efa ----------
Op4efa:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($3333,pc)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ Real PC
  ldrsh r2,[r4],#2 ;@ Fetch extension
  mov r0,r0,lsl #8
  add r0,r2,r0,asr #8 ;@ ($nn,PC)
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [4efb] jmp ($33,pc,d3.w*2); =35 uses Op4efb ----------
Op4efb:
  ldr r10,[r7,#0x60] ;@ Get Memory base

;@ EaCalc : Get '($33,pc,d3.w*2)' into r0:
  ldr r0,[r7,#0x60] ;@ Get Memory base
  sub r0,r4,r0 ;@ r0=PC
;@ Get extension word into r3:
  ldrh r3,[r4],#2
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r3,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r2,r2,r3,asr #24 ;@ r2=Disp+Rn
  mov r0,r0,asl #8 ;@ use only 24bits of PC
  add r0,r2,r0,asr #8 ;@ r0=Disp+PC+Rn
;@ Jump - Get new PC from r0
  add r4,r0,r10 ;@ r4 = Memory Base + New PC

;@ Check Memory Base+pc (r4)
  add lr,pc,#4
  mov r0,r4
  ldr pc,[r7,#0x64] ;@ Call checkpc()
  mov r4,r0

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5000] addq.b #8, d0 uses Op5000 ----------
Op5000:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldrb r0,[r7,r10,lsl #2]
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5010] addq.b #8, (a0) uses Op5010 ----------
Op5010:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5018] addq.b #8, (a0)+ uses Op5018 ----------
Op5018:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [501f] addq.b #8, (a7)+ uses Op501f ----------
Op501f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5020] addq.b #8, -(a0) uses Op5020 ----------
Op5020:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5027] addq.b #8, -(a7) uses Op5027 ----------
Op5027:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5028] addq.b #8, ($3333,a0) uses Op5028 ----------
Op5028:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5030] addq.b #8, ($33,a0,d3.w*2) uses Op5030 ----------
Op5030:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5038] addq.b #8, $3333.w uses Op5038 ----------
Op5038:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5039] addq.b #8, $33333333.l uses Op5039 ----------
Op5039:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  adds r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5040] addq.w #8, d0 uses Op5040 ----------
Op5040:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #16
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5048] addq.w #8, a0 uses Op5048 ----------
Op5048:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  adds r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5050] addq.w #8, (a0) uses Op5050 ----------
Op5050:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5058] addq.w #8, (a0)+ uses Op5058 ----------
Op5058:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [505f] addq.w #8, (a7)+ uses Op505f ----------
Op505f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5060] addq.w #8, -(a0) uses Op5060 ----------
Op5060:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5067] addq.w #8, -(a7) uses Op5067 ----------
Op5067:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5068] addq.w #8, ($3333,a0) uses Op5068 ----------
Op5068:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5070] addq.w #8, ($33,a0,d3.w*2) uses Op5070 ----------
Op5070:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5078] addq.w #8, $3333.w uses Op5078 ----------
Op5078:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5079] addq.w #8, $33333333.l uses Op5079 ----------
Op5079:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  adds r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5080] addq.l #8, d0 uses Op5080 ----------
Op5080:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5088] addq.l #8, a0 uses Op5088 ----------
Op5088:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  adds r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5090] addq.l #8, (a0) uses Op5090 ----------
Op5090:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5098] addq.l #8, (a0)+ uses Op5098 ----------
Op5098:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [509f] addq.l #8, (a7)+ uses Op509f ----------
Op509f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50a0] addq.l #8, -(a0) uses Op50a0 ----------
Op50a0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50a7] addq.l #8, -(a7) uses Op50a7 ----------
Op50a7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50a8] addq.l #8, ($3333,a0) uses Op50a8 ----------
Op50a8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50b0] addq.l #8, ($33,a0,d3.w*2) uses Op50b0 ----------
Op50b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50b8] addq.l #8, $3333.w uses Op50b8 ----------
Op50b8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50b9] addq.l #8, $33333333.l uses Op50b9 ----------
Op50b9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  adds r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50c0] st d0 uses Op50c0 ----------
Op50c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1
  subal r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50c8] dbt d0, 3335 uses Op50c8 ----------
Op50c8:
;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin150c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin150c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue50c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50d0] st (a0) uses Op50d0 ----------
Op50d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50d8] st (a0)+ uses Op50d8 ----------
Op50d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50df] st (a7)+ uses Op50df ----------
Op50df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50e0] st -(a0) uses Op50e0 ----------
Op50e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50e7] st -(a7) uses Op50e7 ----------
Op50e7:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50e8] st ($3333,a0) uses Op50e8 ----------
Op50e8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50f0] st ($33,a0,d3.w*2) uses Op50f0 ----------
Op50f0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50f8] st $3333.w uses Op50f8 ----------
Op50f8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [50f9] st $33333333.l uses Op50f9 ----------
Op50f9:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnal r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5100] subq.b #8, d0 uses Op5100 ----------
Op5100:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldrb r0,[r7,r10,lsl #2]
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #24
  strb r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5110] subq.b #8, (a0) uses Op5110 ----------
Op5110:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5118] subq.b #8, (a0)+ uses Op5118 ----------
Op5118:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [511f] subq.b #8, (a7)+ uses Op511f ----------
Op511f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5120] subq.b #8, -(a0) uses Op5120 ----------
Op5120:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#1 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5127] subq.b #8, -(a7) uses Op5127 ----------
Op5127:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5128] subq.b #8, ($3333,a0) uses Op5128 ----------
Op5128:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5130] subq.b #8, ($33,a0,d3.w*2) uses Op5130 ----------
Op5130:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5138] subq.b #8, $3333.w uses Op5138 ----------
Op5138:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5139] subq.b #8, $33333333.l uses Op5139 ----------
Op5139:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x68] ;@ Call read8(r0) handler
  mov r0,r0,asl #24

  subs r1,r0,#0x8000000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov r1,r1,asr #24
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5140] subq.w #8, d0 uses Op5140 ----------
Op5140:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
  mov r10,r10,lsl #2
;@ EaRead : Read register[r10] into r0:
  ldrsh r0,[r7,r10]
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  mov r1,r1,asr #16
  strh r1,[r7,r10]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5148] subq.w #8, a0 uses Op5148 ----------
Op5148:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  subs r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5150] subq.w #8, (a0) uses Op5150 ----------
Op5150:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5158] subq.w #8, (a0)+ uses Op5158 ----------
Op5158:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [515f] subq.w #8, (a7)+ uses Op515f ----------
Op515f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5160] subq.w #8, -(a0) uses Op5160 ----------
Op5160:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5167] subq.w #8, -(a7) uses Op5167 ----------
Op5167:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#2 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5168] subq.w #8, ($3333,a0) uses Op5168 ----------
Op5168:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5170] subq.w #8, ($33,a0,d3.w*2) uses Op5170 ----------
Op5170:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5178] subq.w #8, $3333.w uses Op5178 ----------
Op5178:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5179] subq.w #8, $33333333.l uses Op5179 ----------
Op5179:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x6c] ;@ Call read16(r0) handler
  mov r0,r0,asl #16

  subs r1,r0,#0x80000
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov r1,r1,asr #16
  mov lr,pc
  ldr pc,[r7,#0x78] ;@ Call write16(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5180] subq.l #8, d0 uses Op5180 ----------
Op5180:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5188] subq.l #8, a0 uses Op5188 ----------
Op5188:
;@ EaCalc : Get register index into r10:
  and r10,r8,#0x000f
;@ EaRead : Read register[r10] into r0:
  ldr r0,[r7,r10,lsl #2]

  subs r1,r0,#0x0008

;@ EaWrite: r1 into register[r10]:
  str r1,[r7,r10,lsl #2]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#8 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5190] subq.l #8, (a0) uses Op5190 ----------
Op5190:
;@ EaCalc : Get '(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [5198] subq.l #8, (a0)+ uses Op5198 ----------
Op5198:
;@ EaCalc : Get '(a0)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a0)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a0)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [519f] subq.l #8, (a7)+ uses Op519f ----------
Op519f:
;@ EaCalc : Get '(a7)+' into r10:
  and r2,r8,#0x000f
  ldr r10,[r7,r2,lsl #2]
  add r3,r10,#4 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaRead : Read '(a7)+' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '(a7)+' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51a0] subq.l #8, -(a0) uses Op51a0 ----------
Op51a0:
;@ EaCalc : Get '-(a0)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51a7] subq.l #8, -(a7) uses Op51a7 ----------
Op51a7:
;@ EaCalc : Get '-(a7)' into r10:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r10,[r7,r2,lsl #2]
  sub r10,r10,#4 ;@ Pre-decrement An
  str r10,[r7,r2,lsl #2]
;@ EaRead : Read '-(a7)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '-(a7)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#22 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51a8] subq.l #8, ($3333,a0) uses Op51a8 ----------
Op51a8:
;@ EaCalc : Get '($3333,a0)' into r10:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r10,r0,r2 ;@ Add on offset
;@ EaRead : Read '($3333,a0)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($3333,a0)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51b0] subq.l #8, ($33,a0,d3.w*2) uses Op51b0 ----------
Op51b0:
;@ EaCalc : Get '($33,a0,d3.w*2)' into r10:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r10,r2,r3 ;@ r10=Disp+An+Rn
;@ EaRead : Read '($33,a0,d3.w*2)' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#26 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51b8] subq.l #8, $3333.w uses Op51b8 ----------
Op51b8:
;@ EaCalc : Get '$3333.w' into r10:
  ldrsh r10,[r4],#2 ;@ Fetch Absolute Short address
;@ EaRead : Read '$3333.w' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$3333.w' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#24 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51b9] subq.l #8, $33333333.l uses Op51b9 ----------
Op51b9:
;@ EaCalc : Get '$33333333.l' into r10:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r10,r0,r2,lsl #16
;@ EaRead : Read '$33333333.l' (address in r10) into r0:
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x70] ;@ Call read32(r0) handler

  subs r1,r0,#0x0008
  mrs r9,cpsr ;@ r9=flags
  eor r9,r9,#0x20000000 ;@ Invert carry
  mov r2,r9,lsr #28
  strb r2,[r7,#0x45] ;@ Save X bit

;@ EaWrite: Write r1 into '$33333333.l' (address in r10):
  mov r0,r10
  mov lr,pc
  ldr pc,[r7,#0x7c] ;@ Call write32(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#28 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51c0] sf d0 uses Op51c0 ----------
Op51c0:
  mov r1,#0

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51c8] dbra d0, 3335 uses Op51c8 ----------
Op51c8:
;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin151c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin151c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue51c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51d0] sf (a0) uses Op51d0 ----------
Op51d0:
  mov r1,#0

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51d8] sf (a0)+ uses Op51d8 ----------
Op51d8:
  mov r1,#0

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51df] sf (a7)+ uses Op51df ----------
Op51df:
  mov r1,#0

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51e0] sf -(a0) uses Op51e0 ----------
Op51e0:
  mov r1,#0

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51e7] sf -(a7) uses Op51e7 ----------
Op51e7:
  mov r1,#0

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51e8] sf ($3333,a0) uses Op51e8 ----------
Op51e8:
  mov r1,#0

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51f0] sf ($33,a0,d3.w*2) uses Op51f0 ----------
Op51f0:
  mov r1,#0

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51f8] sf $3333.w uses Op51f8 ----------
Op51f8:
  mov r1,#0

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [51f9] sf $33333333.l uses Op51f9 ----------
Op51f9:
  mov r1,#0

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52c0] shi d0 uses Op52c0 ----------
Op52c0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1
  subhi r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52c8] dbhi d0, 3335 uses Op52c8 ----------
Op52c8:
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000
;@ If so, don't dbra
  bhi DbraTrue52c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin152c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin152c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue52c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52d0] shi (a0) uses Op52d0 ----------
Op52d0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52d8] shi (a0)+ uses Op52d8 ----------
Op52d8:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52df] shi (a7)+ uses Op52df ----------
Op52df:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52e0] shi -(a0) uses Op52e0 ----------
Op52e0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52e7] shi -(a7) uses Op52e7 ----------
Op52e7:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52e8] shi ($3333,a0) uses Op52e8 ----------
Op52e8:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52f0] shi ($33,a0,d3.w*2) uses Op52f0 ----------
Op52f0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52f8] shi $3333.w uses Op52f8 ----------
Op52f8:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [52f9] shi $33333333.l uses Op52f9 ----------
Op52f9:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnhi r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53c0] sls d0 uses Op53c0 ----------
Op53c0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1
  subls r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53c8] dbls d0, 3335 uses Op53c8 ----------
Op53c8:
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000
;@ If so, don't dbra
  bls DbraTrue53c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin153c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin153c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue53c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53d0] sls (a0) uses Op53d0 ----------
Op53d0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53d8] sls (a0)+ uses Op53d8 ----------
Op53d8:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53df] sls (a7)+ uses Op53df ----------
Op53df:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53e0] sls -(a0) uses Op53e0 ----------
Op53e0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53e7] sls -(a7) uses Op53e7 ----------
Op53e7:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53e8] sls ($3333,a0) uses Op53e8 ----------
Op53e8:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53f0] sls ($33,a0,d3.w*2) uses Op53f0 ----------
Op53f0:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53f8] sls $3333.w uses Op53f8 ----------
Op53f8:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [53f9] sls $33333333.l uses Op53f9 ----------
Op53f9:
  mov r1,#0
;@ Is the condition true?
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  eor r9,r9,#0x20000000 ;@ Invert carry for hi/ls
  mvnls r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54c0] scc d0 uses Op54c0 ----------
Op54c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1
  subcc r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54c8] dbcc d0, 3335 uses Op54c8 ----------
Op54c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bcc DbraTrue54c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin154c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin154c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue54c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54d0] scc (a0) uses Op54d0 ----------
Op54d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54d8] scc (a0)+ uses Op54d8 ----------
Op54d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54df] scc (a7)+ uses Op54df ----------
Op54df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54e0] scc -(a0) uses Op54e0 ----------
Op54e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54e7] scc -(a7) uses Op54e7 ----------
Op54e7:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54e8] scc ($3333,a0) uses Op54e8 ----------
Op54e8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54f0] scc ($33,a0,d3.w*2) uses Op54f0 ----------
Op54f0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54f8] scc $3333.w uses Op54f8 ----------
Op54f8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [54f9] scc $33333333.l uses Op54f9 ----------
Op54f9:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncc r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55c0] scs d0 uses Op55c0 ----------
Op55c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1
  subcs r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55c8] dbcs d0, 3335 uses Op55c8 ----------
Op55c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bcs DbraTrue55c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin155c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin155c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue55c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55d0] scs (a0) uses Op55d0 ----------
Op55d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55d8] scs (a0)+ uses Op55d8 ----------
Op55d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55df] scs (a7)+ uses Op55df ----------
Op55df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55e0] scs -(a0) uses Op55e0 ----------
Op55e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55e7] scs -(a7) uses Op55e7 ----------
Op55e7:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55e8] scs ($3333,a0) uses Op55e8 ----------
Op55e8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55f0] scs ($33,a0,d3.w*2) uses Op55f0 ----------
Op55f0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55f8] scs $3333.w uses Op55f8 ----------
Op55f8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [55f9] scs $33333333.l uses Op55f9 ----------
Op55f9:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvncs r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56c0] sne d0 uses Op56c0 ----------
Op56c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1
  subne r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56c8] dbne d0, 3335 uses Op56c8 ----------
Op56c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bne DbraTrue56c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin156c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin156c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue56c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56d0] sne (a0) uses Op56d0 ----------
Op56d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56d8] sne (a0)+ uses Op56d8 ----------
Op56d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56df] sne (a7)+ uses Op56df ----------
Op56df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56e0] sne -(a0) uses Op56e0 ----------
Op56e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56e7] sne -(a7) uses Op56e7 ----------
Op56e7:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56e8] sne ($3333,a0) uses Op56e8 ----------
Op56e8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56f0] sne ($33,a0,d3.w*2) uses Op56f0 ----------
Op56f0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56f8] sne $3333.w uses Op56f8 ----------
Op56f8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [56f9] sne $33333333.l uses Op56f9 ----------
Op56f9:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnne r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57c0] seq d0 uses Op57c0 ----------
Op57c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1
  subeq r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57c8] dbeq d0, 3335 uses Op57c8 ----------
Op57c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  beq DbraTrue57c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin157c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin157c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue57c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57d0] seq (a0) uses Op57d0 ----------
Op57d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57d8] seq (a0)+ uses Op57d8 ----------
Op57d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57df] seq (a7)+ uses Op57df ----------
Op57df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57e0] seq -(a0) uses Op57e0 ----------
Op57e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57e7] seq -(a7) uses Op57e7 ----------
Op57e7:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57e8] seq ($3333,a0) uses Op57e8 ----------
Op57e8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57f0] seq ($33,a0,d3.w*2) uses Op57f0 ----------
Op57f0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57f8] seq $3333.w uses Op57f8 ----------
Op57f8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [57f9] seq $33333333.l uses Op57f9 ----------
Op57f9:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvneq r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58c0] svc d0 uses Op58c0 ----------
Op58c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1
  subvc r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58c8] dbvc d0, 3335 uses Op58c8 ----------
Op58c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bvc DbraTrue58c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin158c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin158c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue58c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58d0] svc (a0) uses Op58d0 ----------
Op58d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58d8] svc (a0)+ uses Op58d8 ----------
Op58d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58df] svc (a7)+ uses Op58df ----------
Op58df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58e0] svc -(a0) uses Op58e0 ----------
Op58e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58e7] svc -(a7) uses Op58e7 ----------
Op58e7:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '-(a7)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#2 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a7)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58e8] svc ($3333,a0) uses Op58e8 ----------
Op58e8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '($3333,a0)' into r0:
  and r2,r8,#0x000f
  ldr r2,[r7,r2,lsl #2]
  ldrsh r0,[r4],#2 ;@ Fetch offset
  add r0,r0,r2 ;@ Add on offset
;@ EaWrite: Write r1 into '($3333,a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58f0] svc ($33,a0,d3.w*2) uses Op58f0 ----------
Op58f0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '($33,a0,d3.w*2)' into r0:
;@ Get extension word into r3:
  ldrh r3,[r4],#2 ;@ ($Disp,PC,Rn)
  mov r2,r3,lsr #10
  tst r3,#0x0800 ;@ Is Rn Word or Long
  and r2,r2,#0x3c ;@ r2=Index of Rn
  mov r0,r3,asl #24 ;@ r0=Get 8-bit signed Disp
  ldreqsh r2,[r7,r2] ;@ r2=Rn.w
  ldrne   r2,[r7,r2] ;@ r2=Rn.l
  add r3,r2,r0,asr #24 ;@ r3=Disp+Rn
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r2,[r7,r2,lsl #2]
  add r0,r2,r3 ;@ r0=Disp+An+Rn
;@ EaWrite: Write r1 into '($33,a0,d3.w*2)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#18 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58f8] svc $3333.w uses Op58f8 ----------
Op58f8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '$3333.w' into r0:
  ldrsh r0,[r4],#2 ;@ Fetch Absolute Short address
;@ EaWrite: Write r1 into '$3333.w' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#16 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [58f9] svc $33333333.l uses Op58f9 ----------
Op58f9:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvc r1,r1

;@ EaCalc : Get '$33333333.l' into r0:
  ldrh r2,[r4],#2 ;@ Fetch Absolute Long address
  ldrh r0,[r4],#2
  orr r0,r0,r2,lsl #16
;@ EaWrite: Write r1 into '$33333333.l' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#20 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59c0] svs d0 uses Op59c0 ----------
Op59c0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvs r1,r1
  subvs r5,r5,#2 ;@ Extra cycles

;@ EaCalc : Get register index into r0:
  and r0,r8,#0x000f
  mov r0,r0,lsl #2
;@ EaWrite: r1 into register[r0]:
  strb r1,[r7,r0]

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#4 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59c8] dbvs d0, 3335 uses Op59c8 ----------
Op59c8:
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
;@ If so, don't dbra
  bvs DbraTrue59c8

;@ Decrement Dn.w
  and r1,r8,#0x0007
  mov r1,r1,lsl #2
  ldrsh r0,[r7,r1]
  sub r0,r0,#1
  strh r0,[r7,r1]

;@ Check if Dn.w is -1
  cmps r0,#-1
  beq DbraMin159c8

;@ Get Branch offset:
  ldrsh r0,[r4]
  add r4,r4,r0 ;@ r4 = New PC

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#10 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ Dn.w is -1:
DbraMin159c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ condition true:
DbraTrue59c8:
  add r4,r4,#2 ;@ Skip branch offset

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59d0] svs (a0) uses Op59d0 ----------
Op59d0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvs r1,r1

;@ EaCalc : Get '(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59d8] svs (a0)+ uses Op59d8 ----------
Op59d8:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvs r1,r1

;@ EaCalc : Get '(a0)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#1 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a0)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59df] svs (a7)+ uses Op59df ----------
Op59df:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvs r1,r1

;@ EaCalc : Get '(a7)+' into r0:
  and r2,r8,#0x000f
  ldr r0,[r7,r2,lsl #2]
  add r3,r0,#2 ;@ Post-increment An
  str r3,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '(a7)+' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#12 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59e0] svs -(a0) uses Op59e0 ----------
Op59e0:
  mov r1,#0
;@ Is the condition true?
  msr cpsr_flg,r9 ;@ ARM flags = 68000 flags
  mvnvs r1,r1

;@ EaCalc : Get '-(a0)' into r0:
  and r2,r8,#0x000f
  orr r2,r2,#0x8 ;@ A0-7
  ldr r0,[r7,r2,lsl #2]
  sub r0,r0,#1 ;@ Pre-decrement An
  str r0,[r7,r2,lsl #2]
;@ EaWrite: Write r1 into '-(a0)' (address in r0):
  mov lr,pc
  ldr pc,[r7,#0x74] ;@ Call write8(r0,r1) handler

  ldrh r8,[r4],#2 ;@ Fetch next opcode
  subs r5,r5,#14 ;@ Subtract cycles
  ldrge pc,[r6,r8,asl #2] ;@ Jump to opcode handler
  b CycloneEnd

;@ ---------- [59e7] svs -(a7) uses Op59e7 ----------
Op59e7:
  mov r1,#0
;@ Is the condition tru