/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */
                     
#ifndef INTERFACE_H
#define INTERFACE_H

#include <gtk/gtk.h>
#include <config.h>
#if HILDON == 1
#include <hildon/hildon.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#endif

#include <appdata.h>

#define _(String) gettext(String)

/* Description des colonnes*/
enum
{
	CHECK_COLUMN,
	TYPE_COLUMN,
	LABEL_COLUMN,
	NAME_COLUMN,
	COMPANY_COLUMN,
	REQUESTED_INFO_COLUMN,
	N_COLUMNS
};


/* struct for constructiong the response */
typedef struct _ConstructRepData ConstructRepData;
struct _ConstructRepData {
	GHashTable *hashTable;
	GPtrArray *ptrArray;
	guint index;
	guint limit;
};

/* Struct to include view's information */
typedef struct _AppUIData AppUIData;
struct _AppUIData {
	/* Handle to app's data */
	AppData *data;

	/* selection management */
	gboolean multipleSelection;
	GSList* pathList;

	/* backend */
	gpointer backendData;
	guint requestedInfos;
	
	/* Error */
	GError **error;
	
	/* results */
	GSList* resultList;

	/* dialog */
	GtkWidget *dialog;
	
	/* Editview related */
	GtkWidget* searchEntry;         /* search widget */
	GtkWidget* treeSearch;         /* tree widget */
	GtkTreeStore* storeSearch;         /* tree model */
	GtkWidget* buttonOK;

};

/* Publics: */
AppUIData* newAppUIData();
gboolean interface_dialog_new(AppUIData* result, GtkWindow *parent, gboolean multiSel, gboolean showGui, gboolean confirm, gchar* searchText, GPtrArray ** resultArray, gpointer backendData, guint requestedInfos, guint upperLimit, GError **error );

#endif
