/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <ui/callbacks.h>
#include <ui/interface.h>
#include <util/structures.h>
#include <backend/backend.h>
#include <gtk/gtk.h>
#include <libintl.h>

#include <config.h>

/* strlen needed from string.h */
#include <string.h>

/* search */
void search_cb (GtkButton *widget, gpointer data) {
	AppUIData *mainview = NULL;
	mainview = ( AppUIData * ) data;
	gchar * searchText;
	g_assert(mainview != NULL);
	
	searchText = gtk_entry_get_text(GTK_ENTRY(mainview->searchEntry));

	clearPathList(mainview);

	search(GTK_WINDOW(mainview->dialog), searchText, GTK_TREE_STORE(mainview->storeSearch), mainview->backendData, mainview->requestedInfos, mainview->error);

	gtk_tree_view_columns_autosize(GTK_TREE_VIEW(mainview->treeSearch));
}

void addValueToStore(ContactInfosValue *val, LocalDataForValue *localData) {
	GtkTreeIter iter;
	if (val->typeInfo & localData->requestedInfos) {
		gtk_tree_store_append(localData->store, &iter, localData->iterParent);
		gtk_tree_store_set(localData->store, &iter, CHECK_COLUMN, FALSE, TYPE_COLUMN, val->type, LABEL_COLUMN, val->value, NAME_COLUMN, localData->record->name, COMPANY_COLUMN, localData->record->company, REQUESTED_INFO_COLUMN, val->typeInfo, -1);
		localData->count++;
	}
}

gint search (GtkWindow *parent, const gchar *searchText, GtkTreeStore *store, gpointer backendData, guint requestedInfos, GError ** error) {
		
	GtkTreeIter iter;
	gchar *label;
	GSList *entry;
	gboolean retCode;
	GSList *list;
	guint count;
	ContactInfosElement *p;
	GError *localError=NULL;
	LocalDataForValue *localData;

#ifdef DEBUG	
	g_printf("search(parent=%p,\n   searchText=%s,\n   store=%p,\n   backendData=%p,\n   requestedInfos=%d)\n", parent, searchText, store, backendData, requestedInfos);
#endif	
	retCode = backendGetContactInfos (backendData, requestedInfos, searchText, &list, &localError);

#ifdef DEBUG	
	g_printf("retCode =%d= backendGetContactInfos\n localError=%p \n", retCode, localError);
#endif

	if (!retCode || localError) {
		g_propagate_error(error, localError);
		return 0;
	}
	
	gtk_tree_store_clear(store);
	localData = g_new0(LocalDataForValue, 1);
	localData->store = store;
	localData->count = 0;
	for (entry=list; entry; entry=g_slist_next(entry)) {
		p = (ContactInfosElement *)entry->data;
		if (!p) {
			continue;
		}
		if (!p->name && !p->company) {
			/* free the liste */
#ifdef DEBUG	
			g_printf("search no name or company\n");
#endif
			continue;
		} else if (!p->name) {
			label = g_strdup(p->company);
		} else {
			label = g_strjoin(" - ", p->name, p->company, NULL);
		}
		gtk_tree_store_append(store, &iter, NULL);
		gtk_tree_store_set(store, &iter, CHECK_COLUMN, FALSE, LABEL_COLUMN, label, NAME_COLUMN, p->name, COMPANY_COLUMN, p->company, -1);

		localData->iterParent = &iter;
		localData->record=p;
		localData->requestedInfos=requestedInfos;
		g_ptr_array_foreach (p->valueArray, (GFunc)addValueToStore, (gpointer) localData);

		freeContactInfosElement(p);
		g_free(label);
	}
	g_slist_free(list);
	
	count = localData->count;
	g_free(localData);
	
#ifdef DEBUG	
	g_printf("backendGetContactInfos count %d\n", count);
#endif
	return count;
}

void setRowChecked_cb(GtkCellRendererToggle *cell, gchar *path, gpointer *data)
{
	AppUIData *mainview = NULL;
	mainview = ( AppUIData * ) data;
	GtkTreeIter iter;
	GtkTreeIter oldIter;
	gboolean rowChecked;
	GSList* elem;
	GtkTreeModel *model;
	
	g_assert(mainview != NULL);

	model = GTK_TREE_MODEL(mainview->storeSearch);
	if ( !gtk_tree_model_get_iter_from_string(model, &iter, path) ) {
		return;
	}

	if (gtk_tree_store_iter_depth (GTK_TREE_STORE(mainview->storeSearch), &iter) > 0) {
		if (mainview->multipleSelection) {
		} else {
			if (mainview->pathList) {
				if ( gtk_tree_model_get_iter_from_string(model, &oldIter, mainview->pathList->data) ) {
					gtk_tree_store_set(GTK_TREE_STORE(mainview->storeSearch), &oldIter,
						   CHECK_COLUMN, FALSE, -1);
				}
				clearPathList(mainview);

			}
		}
		gtk_tree_model_get(model, &iter,
		    CHECK_COLUMN, &rowChecked,
		    -1);

		rowChecked = !rowChecked;
		if (rowChecked) {
			mainview->pathList = g_slist_prepend(mainview->pathList, g_strdup(path));
			gtk_widget_set_sensitive(mainview->buttonOK, TRUE);
		} else {
			if (mainview->multipleSelection) {
				elem = g_slist_find_custom (mainview->pathList, path, (GCompareFunc) strcmp);
				if (elem != NULL) {
					g_free(elem->data);
					mainview->pathList = g_slist_delete_link(mainview->pathList, elem);
				}
				if (!mainview->pathList) {
					gtk_widget_set_sensitive(mainview->buttonOK, FALSE);
				}
			} else {
				clearPathList(mainview);
				gtk_widget_set_sensitive(mainview->buttonOK, FALSE);
			}
		}

		gtk_tree_store_set(GTK_TREE_STORE(mainview->storeSearch), &iter,
			   CHECK_COLUMN, rowChecked, -1);
	}
}

void clearPathList(AppUIData* mainview) {
	GSList* pathList = mainview->pathList;
	while (pathList)
	{
		g_free(pathList->data);
		pathList = g_slist_next(pathList);
	}
	g_slist_free (mainview->pathList);
	mainview->pathList = NULL;
}

/*
gboolean rpc_send_via_bluetooth(gchar *path)
{
    DBusGProxy *proxy = NULL;
    DBusGConnection *sys_conn = NULL;
    GError *error = NULL;
    gboolean result = TRUE;
    gchar **files = NULL;

    sys_conn = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);

    if(sys_conn == NULL)
    {
        return FALSE;
    }

    files = g_new0(gchar*, 2);
    *files = g_strdup(path);
    files[1] = NULL;

    // Open connection for btdialogs service 
    proxy = dbus_g_proxy_new_for_name(sys_conn,
                           CONBTDIALOGS_DBUS_SERVICE,
                           CONBTDIALOGS_DBUS_PATH,
                           CONBTDIALOGS_DBUS_INTERFACE);

    // Send send file request to btdialogs service 
    if (!dbus_g_proxy_call(proxy, CONBTDIALOGS_SEND_FILE_REQ,
                             &error, G_TYPE_STRV, files,
                             G_TYPE_INVALID, G_TYPE_INVALID))
    {
        g_print("Error: %s\n", error->message);
        g_clear_error(&error);
        result = FALSE;
    }

    g_strfreev(files);

    g_object_unref(G_OBJECT(proxy));
    return result;
        return TRUE;
}
*/

