/*
 * This file is part of contactinfos
 *
 * Copyright (C) 2007 FLL.
 *
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "contactinfos.h"

#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <gtk/gtk.h>

#include <config.h>

/* strlen needed from string.h */
#include <string.h>

#if HILDON == 1
#include <hildon/hildon.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#else
#include <hildon-widgets/hildon-program.h>
#include <hildon-widgets/hildon-banner.h>
#include <hildon-widgets/hildon-file-chooser-dialog.h>
#include <hildon-widgets/hildon-note.h>
#include <hildon-widgets/hildon-font-selection-dialog.h>
#endif

#include <libosso.h>

#include <libintl.h>
#include <locale.h>

#define _(String) gettext(String)

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	GtkWidget *dialog;
	GConfClient *gc_client;
	gint response;
	gchar *moduleName;
	GtkWidget *combo;
	
	/* Init type system */
	g_type_init();

	/* Load default GConf path */
	gc_client = gconf_client_get_default();

	if (gc_client == NULL) {
	    return FALSE;
	}

	/* Get string variable */
	moduleName = gconf_client_get_string(gc_client, CONTACTINFOS_GCONF_KEY, NULL);

	/* Create dialog with OK and Cancel buttons. Leave the separator out, as we do not have any content. */
	dialog = gtk_dialog_new_with_buttons(
		_("ContactInfos control panel"),
		GTK_WINDOW(data),
		GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
		GTK_STOCK_OK,
		GTK_RESPONSE_OK,
		GTK_STOCK_CANCEL,
		GTK_RESPONSE_CANCEL,
		NULL);

	/* ... add something to the dialog ... */
	combo = gtk_combo_box_entry_new_text();
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo), "contactinfos_gpe");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo), "contactinfos_eds");
	gtk_combo_box_append_text(GTK_COMBO_BOX(combo), "contactinfos_google");
	if (moduleName) {
		gtk_combo_box_prepend_text(GTK_COMBO_BOX(combo), moduleName);
		gtk_combo_box_set_active(GTK_COMBO_BOX(combo), 0);
	}
	
	gtk_container_add (GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), combo);
	

	gtk_window_set_default_size(GTK_WINDOW(dialog), 300, 200);
	gtk_widget_show_all (dialog);
	
#if HILDON == 1
	if (!user_activated)
	{



	}
#endif
	/* Wait until user finishes the dialog. */
	response = gtk_dialog_run(GTK_DIALOG(dialog));

	if (response == GTK_RESPONSE_OK)
	{
		/* ... do something with the dialog stuff ... */
		moduleName = gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo));
		if (moduleName) {
			/* Set string variable */
			gconf_client_set_string(gc_client, CONTACTINFOS_GCONF_KEY, moduleName, NULL);
		}
	}

	/* Free the dialog (and it's children) */
	gtk_widget_destroy(GTK_WIDGET(dialog));

	/* Free gconf settings object */
	g_object_unref(gc_client);

	return OSSO_OK;
}             
     
osso_return_t save_state(osso_context_t *osso, gpointer data)
{
        /* ... save state ... */

        return OSSO_OK;
}
