#include "writewindow.h"
#include "ui_writewindow.h"

#include "processdialog.h"
#include "ui_processdialog.h"

#include "configreader.h"
#include "ui_configreader.h"

#include <QFileDialog>
#include <QDebug>

writeWindow::writeWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::writeWindow)
{
    ui->setupUi(this);
    // Hide the car and progress bar at startup
    ui->carLabel->hide();
    ui->progBar->hide();
    // Set the mainLabel text color to black
    ui->mainLbl->setStyleSheet("color: black;");
    // Set the backgrounds
    this->setStyleSheet("QMainWindow { background-image: url(:/gfx/backsave.png) }");

    // writeParent is a pointer to writeWindow's parent (configReader)
    writeParent = (configReader*) parent;

    // If the dialog is cancelled, writeParent->saveDir is empty, but bkpDir isn't
    // saveDialog has bkpDir as default location, no empty path possible this way
    bkpDir.setPath(writeParent->saveDir.absolutePath());

    connect(this->ui->saveBtn, SIGNAL(clicked()),
            this, SLOT(writeFile()));
}

writeWindow::~writeWindow()
{
    delete ui;
}

void writeWindow::writeFile() {
    // Get the save directory from the user
    writeParent->saveDir.setPath(QFileDialog::getExistingDirectory(this,
                                                      "Select directory",
                                                      bkpDir.absolutePath(),
                                                      QFileDialog::ShowDirsOnly));

    // Only save the file if the dialog hasn't been cancelled
    if(writeParent->saveDir.path().isEmpty() == false) {
        // Hide the saveBtn, show the carLabel and progress bar
        ui->saveBtn->hide();
        ui->carLabel->show();
        ui->progBar->show();
        this->setStyleSheet("QMainWindow { background-image: url(:/gfx/backdone.png) }");

        system("gconftool -s /apps/maemo/configreader/save_dir -t string " + writeParent->saveDir.absolutePath().toAscii());

        curDate = QDate::currentDate();
        curTime = QTime::currentTime();

        // Updating main label, it has a dummy above it, for placement
        ui->mainLbl->setText("Writing configreader"
                             + curDate.toString(writeParent->dateFormat)
                             + "-"
                             + curTime.toString("HHmmss")
                             + ".html");

        // Edit the output to HTML before saving
        editOutData();

        // Save output to file
        saveFile.setFileName(writeParent->saveDir.absolutePath()
                             + "/"
                             + "configreader"
                             + curDate.toString(writeParent->dateFormat)
                             + "-"
                             + curTime.toString("HHmmss")
                             + ".html");
        saveFile.open(QFile::Truncate | QFile::WriteOnly);

        // Write HTML
        QTextStream writeStrm(&saveFile);
        writeStrm << "<html>\n"
                << "\t<head>\n"
                << "\t\t<title>\n"
                << "\t\t\t"
                << curDate.toString(writeParent->dateFormatTitle) << ", "
                << curTime.toString("HH:mm:ss")
                << " (Config Reader)"
                << "\n"
                << "\t\t</title>\n"
                << "\t</head>\n"
                << "\t<body style='font-family: monospace'>\n"
                << writeParent->outData
                << "\t</body>\n"
                << "</html>";

        saveFile.close();

        // Hide the empty label before showing "Done!" label
        ui->dummyLabel->hide();
        ui->mainLbl->setText("Done!<br>"
                             + writeParent->saveDir.absolutePath() + "/" + "<br>"
                             + QFileInfo(saveFile).fileName());
        // Hide the progress bar
        ui->progBar->hide();
    }
}





void writeWindow::editOutData() {
    // Make outDataSplitted, split writeParent->outData by "\n"
    outDataSplitted = writeParent->outData.split("\n", QString::KeepEmptyParts, Qt::CaseInsensitive);

    // Empty writeParent->outData
    writeParent->outData.clear();

    // Read outDataSplitted line by line
    for(i=0; i<outDataSplitted.length(); i++) {
        // tempData = outDataSplitted[#], trimmed() (removes all whitespace and /n, /t etc.)
        tempData = outDataSplitted[i];
        tempData = tempData.trimmed();

        // Make al directory lines bold, make top directory bigger + linebreaks before it
        if(tempData.startsWith("/") && tempData.endsWith(":")) {
            // Top directories
            if(tempData.count("/", Qt::CaseInsensitive) == 1) {
                // Don't put linebreaks before first line
                if(i != 0)
                    outDataSplitted[i] = "<br /><br /><br /><font size='+5' color='#0000FF'><b>" + outDataSplitted[i] + "</b></font>";
                else
                    outDataSplitted[i] = "<font size='+5' color='#0000FF'><b>" + outDataSplitted[i] + "</b></font>";
            }
            // Subdirectories
            else
                outDataSplitted[i] = "<font color='#4D4DFF'><b>" + outDataSplitted[i] + "</b></font>";
        }

        // Start every line with "\t\t" (for html neatness)
        outDataSplitted[i] = "\t\t" + outDataSplitted[i];

        // Append every line with "<br />\n" (newline in HTML and C++)
        outDataSplitted[i] = outDataSplitted[i] + "<br />";

        // Replace all spaces with "&nbsp;", except for HTML tags
        tempData = outDataSplitted[i];
        tempData.replace(" ", "&nbsp;", Qt::CaseInsensitive);
        tempData.replace("<br&nbsp;/>", "<br />", Qt::CaseInsensitive);
        tempData.replace("<font&nbsp;size", "<font size", Qt::CaseInsensitive);
        tempData.replace("&nbsp;color='", " color='", Qt::CaseInsensitive);
        outDataSplitted[i] = tempData;

        // Refill writeParent->outData
        writeParent->outData.append(outDataSplitted[i] + "\n");

        // Show progress
        fI = i;
        fLen = outDataSplitted.length();
        percDone = ((fI + 1) / fLen) * 100;
        ui->progBar->setValue(percDone);

        // Show and move the car
        ui->carLabel->show();
        fPercDone = (fI + 1) / fLen;
        carPos = 800 * fPercDone;
        ui->carLabel->setGeometry(carPos,
                                  ui->carLabel->geometry().y(),
                                  ui->carLabel->geometry().width(),
                                  ui->carLabel->geometry().height());
        // Hide the car after animation
        if(fPercDone == 1)
            ui->carLabel->hide();
    }
}
