#ifndef CONFIGREADER_H
#define CONFIGREADER_H

#include <QMainWindow>
#include <QProcess>
#include <QDir>
#include <QMenu>
#include <QMenuBar>

class aboutDialog;
class settingsDialog;
class processDialog;
class writeWindow;

namespace Ui {
    class configReader;
}

class configReader : public QMainWindow
{
    Q_OBJECT

public:
    explicit configReader(QWidget *parent = 0);
    ~configReader();

    QString saveDirConf;
    QDir saveDir;
    QString outData;
    QString dateFormat;
    QString dateFormatTitle;
    QString dateSepConf;
    QString dateSep;

public slots:
    void saveDirReadReady();
    void sepReadReady();
    void dateReadReady();

    void openProcDialog();
    void openWriteWin();

    void createAboutDialog();
    void createAboutQtDialog();
    void createSettingsDialog();

private:
    Ui::configReader *ui;

    int i;

    QProcess saveDirProcess;
    QProcess sepProcess;
    QProcess dateProcess;

    QMenuBar crMenu;
    aboutDialog *abtDialog;
    settingsDialog *settDialog;
    processDialog *procDialog;
    writeWindow *writeWin;

    void setupCRMenu();
    void getSaveDir();
    void getSep();
    void getDateFormat();
};

#endif // CONFIGREADER_H
