/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef MENUELEMENT_H_
#define MENUELEMENT_H_

#include <QtCore/QString>

#include "../gl.h"
#include <SDL/SDL.h>
#include "../animation/AnimatedElement.h"
#include "../actions/Action.h"

class MenuElement {
private:
	AnimatedElement transition;
protected:
	QString icon;
	QString name;
	Action* action;
	GLuint texture;
	SDL_Surface* surface;
public:
	GLfloat position;
	GLfloat transparency;
	MenuElement() {};
	MenuElement(QString name, QString icon, Action* action);
	virtual void createTexture();
	virtual void deleteTexture();
	virtual int getIconSize();
	virtual bool isHighlighted() {return false;}
	virtual GLfloat** getIconTexCoords();
	virtual ~MenuElement();
friend class Menu;
};

#endif /* MENUELEMENT_H_ */
