/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#ifndef SEQUENTIALTRANSITION_H_
#define SEQUENTIALTRANSITION_H_

#include "../Transition.h"
#include <QtCore/QList>

class SequentialTransition: public Transition {
	bool isFinished;
	Transition* current;
	QList<Transition*> transitions;
	QListIterator<Transition*>* iter;
public:
	SequentialTransition(QList<Transition*> transitions) : isFinished(false), current(0), transitions(transitions), iter(0) {};
	virtual ~SequentialTransition();
	virtual void nextFrame();
	virtual void reset();
	virtual bool finished();
};

#endif /* SEQUENTIALTRANSITION_H_ */
