/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

#include "CubicTransition.h"

void CubicTransition::nextFrame() {
	if (currentFrame <= numFrames) {
		GLfloat normalizedTime = 1.0 - (GLfloat) currentFrame / (GLfloat) numFrames;
		GLfloat normalizedValue = pow(normalizedTime, 3.0);
		GLfloat targetValue = upper + normalizedValue * (lower - upper);
		*target = targetValue;
		currentFrame++;
	}
}

void CubicTransition::reset() {
	currentFrame = 0;
}

bool CubicTransition::finished() {
	return currentFrame >= numFrames;
}

CubicTransition::~CubicTransition() {
}
