/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */

char* PROVIDER_NAMES[] = { "OpenStreetMap", "CloudMade", "Google Maps", "Bing Maps", "Yahoo Maps" };

char* getTileUrl(TileProvider provider, t_tile *tile) {
    char* url = calloc(sizeof(char), 200);
    switch (provider) {
        case OSM:
            sprintf(url, "http://tile.openstreetmap.org/%d/%d/%d.png", tile->zoom, tile->lat, tile->lon);
            return url;
        default:
            fprintf(stderr, "get URL for provider not implemented");
            quit = TRUE;
            return NULL;
    }
}
char* getTileFileName(TileProvider provider, t_tile *tile) {
    char* filename = calloc(sizeof(char), 200);

    if (filename == NULL) {
        fprintf(stderr, "memory allocation error in getFileName()");
        quit = TRUE;
    }
    switch (provider) {
        case OSM:
            sprintf(filename, "/home/user/MyDocs/.maps/OpenStreetMap I/%d/%d/%d.png", tile->zoom, tile->lat, tile->lon);
            return filename;
        default:
            fprintf(stderr, "get file name for provider not implemented");
            quit = TRUE;
            return NULL;
    }
}
