/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
size_t writeFunction(void *ptr, size_t size, size_t nmemb, void *stream) {
    fwrite(ptr, size, nmemb, (FILE *) stream);
    downloaded += nmemb * size;
    return nmemb * size;
}
;

int downloadUrl(char *url, char *filename) {
    CURL *curl = curl_easy_init();
    CURLcode res;
    FILE *destFile;
//    long startTime = SDL_GetTicks();
    long http_code;
//    fprintf(stderr, "downloading '%s' to '%s'\n", url, filename);

    if (curl == NULL) {
        fprintf(stderr, "downloadUrl failed: curl not initialized\n");
        return FALSE;
    }

    curl_easy_setopt(curl, CURLOPT_URL, url);

    destFile = fopen(filename, "wb");

    if (destFile == NULL) {
        fprintf(stderr, "unable to open file '%s' for writing\n", filename);
        curl_easy_cleanup(curl);
        return FALSE;
    }
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, writeFunction);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, destFile);
    res = curl_easy_perform(curl);
    fclose(destFile);
    if (CURLE_OK == res) {
        curl_easy_getinfo(curl, CURLINFO_RESPONSE_CODE, &http_code);

        curl_easy_cleanup(curl);
        if (http_code == 200) {
//            fprintf(stderr, "download successfull, %ld\n", http_code);
            return TRUE;
        } else {
            remove(filename);
//            fprintf(stderr, "Received %ld status code\n", http_code);
            return FALSE;
        }
    }
    curl_easy_cleanup(curl);
//    fprintf(stderr, "download '%s' took %ld ms\n", url, (SDL_GetTicks() - startTime));
    return FALSE;
}
