/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
#define CONFIG_FILE "/home/user/.cloudgps/config"

void loadConfig() {
    canvas.zoom = 2;
    canvas.maxZoom = 18;
    canvas.tilex = -1;
    canvas.tiley = -1;
    FILE* file = fopen(CONFIG_FILE, "r");
    if (file != NULL) {
        fscanf(file, "zoom=%d\ntilex=%d\ntiley=%d\nx=%f\ny=%f\n", &canvas.zoom, &canvas.tilex, &canvas.tiley, &canvas.x, &canvas.y);
        fclose(file);
    } else {
        fprintf(stderr, "unable to open %s for reading, error: %s\n", CONFIG_FILE, strerror(errno));
    }
}

void saveConfig() {
    ensureDirExists(CONFIG_FILE);
    FILE* file = fopen(CONFIG_FILE, "wt");
    if (file != NULL) {
        fprintf(file, "zoom=%d\ntilex=%d\ntiley=%d\nx=%f\ny=%f\n", canvas.zoom, canvas.tilex, canvas.tiley, canvas.x, canvas.y);
        fclose(file);
    } else {
        fprintf(stderr, "unable to open %s for writing, error: %s\n", CONFIG_FILE, strerror(errno));
    }
}
