/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
int currentTilesIdx = 0;

#define DOWNLOADING_THREADS  1

SDL_Thread* downloadThreads[DOWNLOADING_THREADS];
queue * downloadQueue;

SDL_Thread* fileIOthread;
queue * fileIOqueue;

int downloadThread(void* queue);

int getLowerDeallocateBound(int size, int shift) {
    return shift < 0 ? 0 : (size - shift) < 0 ? 0 : (size - shift);
}

int getUpperDeallocateBound(int size, int shift) {
    return shift < 0 ? (-shift < size ? -shift : size) : size;
}

void deallocateTiles(int horizontalShift, int verticalShift) {

    int i, j;
    for (i = getLowerDeallocateBound(TILES_X, horizontalShift); i < getUpperDeallocateBound(TILES_X, horizontalShift); i++) {
        for (j = 0; j < TILES_Y; j++) {
            deallocateTile(tiles[i][j][currentTilesIdx]);
        }
    }
    for (i = 0; i < TILES_X; i++) {
        for (j = getLowerDeallocateBound(TILES_Y, verticalShift); j < getUpperDeallocateBound(TILES_Y, verticalShift); j++) {
            deallocateTile(tiles[i][j][currentTilesIdx]);
        }
    }
}

void updateTiles(int horizontalShift, int verticalShift) {
    // Manual image deallocation - helps some KVMs with memory management.
    deallocateTiles(horizontalShift, verticalShift);
    int i, j;
    for (i = 0; i < TILES_X; i++) {
        for (j = 0; j < TILES_Y; j++) {
            int newPosX = i - horizontalShift;
            int newPosY = j - verticalShift;
            if (newPosX >= 0 && newPosX < TILES_X && newPosY >= 0 && newPosY < TILES_Y) {
                tiles[i][j][1 - currentTilesIdx] = tiles[newPosX][newPosY][currentTilesIdx];
            } else {
                tiles[i][j][1 - currentTilesIdx] = (t_tile*) malloc(sizeof(t_tile));
                tiles[i][j][1 - currentTilesIdx]->lat = tiles[i][j][currentTilesIdx]->lat - horizontalShift ;
                tiles[i][j][1 - currentTilesIdx]->lon = tiles[i][j][currentTilesIdx]->lon - verticalShift;
                tiles[i][j][1 - currentTilesIdx]->zoom = canvas.zoom;
                tiles[i][j][1 - currentTilesIdx]->state = STATE_EMPTY;
                tiles[i][j][1 - currentTilesIdx]->texture = 0;

                enqueue(downloadQueue, tiles[i][j][1 - currentTilesIdx]);

//                threadLoadTile(tiles[i][j][1 - currentTilesIdx]);
//                SDL_Thread *thread;
//                thread = SDL_CreateThread(threadLoadTile, tiles[i][j][1 - currentTilesIdx]);
//                if ( thread == NULL ) {
//                    fprintf(stderr, "Unable to create thread: %s\n", SDL_GetError());
//                }
            }
        }
    }
    currentTilesIdx = 1 - currentTilesIdx;
}

int roundDown(double x) {
    return x < 0 ? (int) (x - 1.0) : (int) x;
}


