/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Author: Damian Waradzyn
 */
SDL_GLES_Context *context;

void setQuadSize(GLfloat w, GLfloat h, GLfloat quad[12]) {
    quad[3] = w;
    quad[7] = h;
    quad[9] = w;
    quad[10] = h;
}

void setBoxSize(GLfloat w, GLfloat h, GLfloat box[12]) {
    box[4] = h;
    box[6] = w;
    box[7] = h;
    box[9] = w;
}

Texture fontMediumMask, fontMedium, barbg, barbgmask;

const int MEDIUM_FONT_METRICS[256] = { 8, 8, 8, 8, 8, 8, 8, 8, 8, 56, 0, 8, 8, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 5, 5, 11,
        8, 12, 11, 3, 5, 5, 7, 11, 4, 5, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 11, 11, 11, 7, 13, 9, 9, 9, 10, 8, 7, 10, 10, 3, 3, 8, 7, 11, 10,
        10, 8, 10, 8, 9, 7, 10, 9, 11, 10, 7, 10, 5, 4, 5, 11, 7, 7, 8, 8, 7, 8, 8, 4, 8, 8, 3, 3, 7, 3, 13, 8, 8, 8, 8, 5, 7, 5, 8, 7, 9, 7, 7, 7,
        8, 4, 8, 11, 8, 8, 8, 4, 8, 7, 13, 7, 7, 7, 17, 9, 5, 14, 8, 10, 8, 8, 4, 4, 7, 7, 8, 7, 13, 7, 13, 7, 5, 13, 8, 7, 7, 8, 5, 8, 8, 8, 8, 4,
        7, 7, 13, 6, 8, 11, 5, 13, 7, 7, 11, 5, 5, 7, 8, 8, 4, 7, 5, 6, 8, 13, 13, 13, 7, 9, 9, 9, 9, 9, 9, 13, 9, 8, 8, 8, 8, 3, 3, 3, 3, 10, 10,
        10, 10, 10, 10, 10, 11, 10, 10, 10, 10, 10, 7, 8, 8, 8, 8, 8, 8, 8, 8, 13, 7, 8, 8, 8, 8, 3, 3, 3, 3, 8, 8, 8, 8, 8, 8, 8, 11, 8, 8, 8, 8, 8,
        7, 8, 7 };

GLfloat boxVertices[12] = { 0.0f, 0.0f, 0.0f, 0.0f, 256.0f, 0.0f, 256.0f, 256.0f, 0.0f, 256.0f, 0.0f, 0.0f, };

GLfloat quadVertices[12] = { 0.0f, 0.0f, 0.0f, /* Bottom Left Of The Quad */
1.0f, 0.0f, 0.0f, /* Bottom Right Of The Quad */
0.0f, 1.0f, 0.0f, /* Top Left Of The Quad */
1.0f, 1.0f, 0.0f, /* Top Right Of The Quad */
};

const GLfloat texCoords[][8] = { { 0.0f, 0.0f, /* Bottom Left Of The Texture */
1.0f, 0.0f, /* Bottom Right Of The Texture */
0.0f, 1.0f, /* Top Left Of The Texture */
1.0f, 1.0f, /* Top Right Of The Texture */
} };

SDL_Surface* loadTextureFromFile(char *filename);
GLuint createTexture(GLushort * pixels4444, int w, int h);

char buf[500];

int stringWidth(char * str) {
    int result = 0, i = 0;
    while (str[i] != '\0') {
        result += MEDIUM_FONT_METRICS[(int) str[i]];
        i++;
    }
    return result;
}

void drawString(char* str, GLfloat r, GLfloat g, GLfloat b) {
    int i, len, charTileSize, xpos = 0;
    //    int j;
    len = strlen(str);
    GLfloat *vertices, *fontTextureCoords;

    int tx, ty;

    if (len == 0) {
        return;
    }

    charTileSize = fontMediumMask.size / 16;
    setQuadSize(charTileSize, charTileSize, quadVertices);

    vertices = malloc(sizeof(GLfloat) * (len) * 18);
    fontTextureCoords = malloc(sizeof(GLfloat) * len * 12);

    for (i = 0; i < len; i++) {
        //        fprintf(stderr, "------------------------------\ni = %d\n", i);
        vertices[i * 18] = xpos;
        vertices[i * 18 + 1] = 0;
        vertices[i * 18 + 2] = 0;

        vertices[i * 18 + 3] = xpos;
        vertices[i * 18 + 4] = charTileSize;
        vertices[i * 18 + 5] = 0;

        vertices[i * 18 + 6] = xpos + charTileSize;
        vertices[i * 18 + 7] = charTileSize;
        vertices[i * 18 + 8] = 0;

        vertices[i * 18 + 9] = xpos;
        vertices[i * 18 + 10] = 0;
        vertices[i * 18 + 11] = 0;

        vertices[i * 18 + 12] = xpos + charTileSize;
        vertices[i * 18 + 13] = charTileSize;
        vertices[i * 18 + 14] = 0;

        vertices[i * 18 + 15] = xpos + charTileSize;
        vertices[i * 18 + 16] = 0;
        vertices[i * 18 + 17] = 0;

        xpos += MEDIUM_FONT_METRICS[(int) str[i]];
        //        fprintf(stderr, "Width of '%c' is %d. xpos = %d\n", str[i], MEDIUM_FONT_METRICS[(int)str[i]], xpos);

        //        for (j = 0; j < 18; j++) {
        //            fprintf(stderr, "vertices[%d] = %g\n", i * 18 + j, vertices[i * 18 + j]);
        //        }

        tx = (str[i] % 16) * charTileSize;
        ty = str[i] / 16 * charTileSize;

        fontTextureCoords[i * 12 + 0] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 1] = ty / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 2] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 3] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 4] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 5] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 6] = tx / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 7] = ty / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 8] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 9] = (ty + charTileSize) / (GLfloat) fontMediumMask.size;

        fontTextureCoords[i * 12 + 10] = (tx + charTileSize) / (GLfloat) fontMediumMask.size;
        fontTextureCoords[i * 12 + 11] = ty / (GLfloat) fontMediumMask.size;

        //        for (j = 0; j < 12; j++) {
        //            fprintf(stderr, "textureCoords[%d] = %g\n", i * 12 + j, fontTextureCoords[i * 12 + j]);
        //        }
    }
    glEnable(GL_BLEND);
    glBlendFunc(GL_DST_COLOR, GL_ZERO);
    glColor4f(1.0, 1.0, 1.0, 1.0);
    glBindTexture(GL_TEXTURE_2D, fontMediumMask.name);
    glVertexPointer(3, GL_FLOAT, 0, vertices);
    glTexCoordPointer(2, GL_FLOAT, 0, fontTextureCoords);
    glDrawArrays(GL_TRIANGLES, 0, len * 6);

    glColor4f(r, g, b, 1.0);
    glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glBindTexture(GL_TEXTURE_2D, fontMedium.name);
    glVertexPointer(3, GL_FLOAT, 0, vertices);
    glTexCoordPointer(2, GL_FLOAT, 0, fontTextureCoords);
    glDrawArrays(GL_TRIANGLES, 0, len * 6);

    free(vertices);
    free(fontTextureCoords);
}

#include "uielement.c"

float color = 1.0;

void drawTile(t_tile *tile) {
    int i;

    switch (tile->state) {
        case STATE_EMPTY:
            //            glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_ERROR:
            //            glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_LOADING:
            //            glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
            //            glVertexPointer(3, GL_FLOAT, 0, boxVertices[0]);
            //            glDrawArrays(GL_LINE_LOOP, 0, 4);
            break;
        case STATE_LOADED:
            //            tile -> transitionTime = 1500;
            if (nowMillis - tile->stateChangeTime < tile->transitionTime) {
                color = (nowMillis - tile->stateChangeTime) / (float) tile->transitionTime;
                //color = 1.0 - sqrt(sqrt(1.0 - color));
            } else {
                color = 1.0;

                if (tile->oldTexture[0] > 0) {
                    if (tile->oldTexture[1] == 0) {
                        int j, count = 0;
                        for (i = 0; i < TILES_X; i++) {
                            for (j = 0; j < TILES_Y; j++) {
                                if (tiles[i][j][currentTilesIdx] -> lat != tile -> lat && tiles[i][j][currentTilesIdx] -> lon != tile -> lon
                                        && tiles[i][j][currentTilesIdx] -> oldTexture[0] == tile -> oldTexture[0]) {
                                    count++;
                                }
                            }
                        }
                        if (count == 0) {
                            glDeleteTextures(1, &tile->oldTexture[0]);
                            //                            free(tile -> oldPixels4444[0]);
                            //                            tile -> oldPixels4444[0] = NULL;
                            //                            SDL_FreeSurface(tile -> oldTmpSurface[0]);
                            //                            tile -> oldTmpSurface[0] = NULL;
                        }
                        tile->oldTexture[0] = 0;
                    } else {
                        for (i = 0; i < 4; i++) {
                            if (tile->oldTexture[i]) {
                                glDeleteTextures(1, &tile->oldTexture[i]);
                                //                                tile->oldTexture[i] = 0;
                                //                                free(tile -> oldPixels4444[i]);
                                //                                tile -> oldPixels4444[i] = NULL;
                                //                                SDL_FreeSurface(tile -> oldTmpSurface[i]);
                                //                                tile -> oldTmpSurface[i] = NULL;
                            }
                        }
                    }
                }

            }

            if (color < 1.0) {
                setQuadSize(tile->oldTextureSize, tile->oldTextureSize, quadVertices);
                glEnable(GL_BLEND);
                glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
                for (i = 0; i < 4; i++) {
                    if (tile->oldTexture[i] > 0) {
                        glTranslatef(TILE_SIZE / 2 * (i / 2), TILE_SIZE / 2 * (i % 2), 0);
                        glColor4f(1.0, 1.0, 1.0, 1.0 - color);
                        glBindTexture(GL_TEXTURE_2D, tile->oldTexture[i]);
                        glVertexPointer(3, GL_FLOAT, 0, quadVertices);
                        glTexCoordPointer(2, GL_FLOAT, 0, tile->oldTextureCoords[i]);
                        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
                        glTranslatef(-TILE_SIZE / 2 * (i / 2), -TILE_SIZE / 2 * (i % 2), 0);
                    }
                }
            } else {
                glDisable(GL_BLEND);
            }
            glColor4f(1.0, 1.0, 1.0, color);
            glBindTexture(GL_TEXTURE_2D, tile->texture);
            setQuadSize(TILE_SIZE, TILE_SIZE, quadVertices);
            glVertexPointer(3, GL_FLOAT, 0, quadVertices);
            glTexCoordPointer(2, GL_FLOAT, 0, texCoords[0]);
            glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
            break;
        case STATE_TEXTURE_BIND_WAIT:
        case STATE_LOADED_SYNC_WAIT:
        case STATE_SCALED_LOADING:
            glDisable(GL_BLEND);
            setQuadSize(tile->oldTextureSize, tile->oldTextureSize, quadVertices);
            for (i = 0; i < 4; i++) {
                if (tile->oldTexture[i] > 0) {
                    glTranslatef(TILE_SIZE / 2 * (i / 2), TILE_SIZE / 2 * (i % 2), 0);
                    glColor4f(1.0, 1.0, 1.0, 1.0);
                    glBindTexture(GL_TEXTURE_2D, tile->oldTexture[i]);
                    glVertexPointer(3, GL_FLOAT, 0, quadVertices);
                    glTexCoordPointer(2, GL_FLOAT, 0, tile->oldTextureCoords[i]);
                    glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
                    glTranslatef(-TILE_SIZE / 2 * (i / 2), -TILE_SIZE / 2 * (i % 2), 0);
                }
            }
            break;
    }
    if (canvas.showGrid) {
        glDisable(GL_BLEND);
        setBoxSize(TILE_SIZE, TILE_SIZE, boxVertices);
        glBindTexture(GL_TEXTURE_2D, 0);
        glColor4f(0.7f, .7f, 0.7f, .9f);
        glVertexPointer(3, GL_FLOAT, 0, boxVertices);
        glDrawArrays(GL_LINE_LOOP, 0, 4);

        sprintf(buf, "%d, %d", tile->lat, tile -> lon);
        drawString(buf, 0.1f, .0, 1.0);
    }
}

/* general OpenGL initialization function */
int initGL(GLvoid) {
    SDL_GLES_Init(SDL_GLES_VERSION_1_1);

    context = SDL_GLES_CreateContext();
    SDL_GLES_MakeCurrent(context);

    /* Enable Texture Mapping ( NEW ) */
    glEnable(GL_TEXTURE_2D);

    /* Set the background black */
    glClearColor(.0f, .0f, .0f, 1.0f);
    glEnable(GL_CLEAR);

    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_CULL_FACE);
    glViewport(0, 0, (GLint) SCREEN_WIDTH, (GLint) SCREEN_HEIGHT);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    //glOrthof(0, SCREEN_WIDTH, SCREEN_HEIGHT, 0, -10000.0, 10000.0);
    glFrustumf(-200, 200, 120, -120, 50.0, 600);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();

    GLfloat fogColor[4] = { 0.1f, 0.1f, 0.1f, 1.0f };
    glFogx(GL_FOG_MODE, GL_LINEAR); // Fog Mode
    glFogfv(GL_FOG_COLOR, fogColor); // Set Fog Color
    glFogf(GL_FOG_DENSITY, .1f); // How Dense Will The Fog Be
    glHint(GL_FOG_HINT, GL_DONT_CARE); // Fog Hint Value
    glFogf(GL_FOG_START, 100.0f); // Fog Start Depth
    glFogf(GL_FOG_END, 200.0f); // Fog End Depth
    glEnable(GL_FOG);
    //    const GLubyte *extensions = glGetString(GL_EXTENSIONS);
    //    fprintf(stderr, "GL extensions: %s\n", (const char*) extensions);

    return (TRUE);
}

GLfloat seconds;
GLfloat fps;

void drawGLScene(GLvoid) {
    static GLint oldTicks = 0;
    static GLint frames = 0;
    int i, j, k;

    glClear(GL_COLOR_BUFFER_BIT);

    glLoadIdentity();
    glTranslatef(-(canvas.scale - 1.0) * SCREEN_WIDTH / 2 - SCREEN_WIDTH / 2, -(canvas.scale - 1.0) * SCREEN_HEIGHT / 2 - SCREEN_HEIGHT / 2, -100.0f);
    glScalef(canvas.scale, canvas.scale, canvas.scale);

    if ( fabs(canvas.rotx) > 0.02 || canvas.rotz > 0.02) {
        glTranslatef(SCREEN_WIDTH / 2, SCREEN_HEIGHT / 2, 0);
        glRotatef(canvas.rotx, 1.0, 0.0, 0.0);
        glRotatef(canvas.rotz, 0, 0.0, 1.0);
        glTranslatef(-SCREEN_WIDTH / 2, -SCREEN_HEIGHT / 2, 0);
        k = TRUE;
    } else {
        k = FALSE;
    }

    if (fabs(canvas.rotx) > 5) {
        glEnable(GL_FOG);
    } else {
        glDisable(GL_FOG);
    }

    if (canvas.scale - 1.0 > 0.01 || k) {
        glTranslatef(canvas.x - TILE_SIZE, canvas.y - TILE_SIZE, 0.0f);
    } else {
        glTranslatef((int) canvas.x - TILE_SIZE, (int) canvas.y - TILE_SIZE, 0.0f);
    }

    for (i = 0; i < TILES_X; i++) {
        for (j = 0; j < TILES_Y; j++) {
            glTranslatef(i * TILE_SIZE, j * TILE_SIZE, 0);
            drawTile(tiles[i][j][currentTilesIdx]);
            glTranslatef(-i * TILE_SIZE, -j * TILE_SIZE, 0);
        }
    }
    if (position -> status != UI_HIDDEN) {
        drawUiElement(position);
    }

    glLoadIdentity();
    glTranslatef(-SCREEN_WIDTH / 2, -SCREEN_HEIGHT / 2, -100);
    drawUI();

    glLoadIdentity();
    glTranslatef(15, 15, -100);
    if (canvas.showCoordinates) {
        sprintf(buf, "%02.6f %02.6f", canvas.center.latitude, canvas.center.longitude);
        drawString(buf, 0.4, 0.4, 0.4);
    }

    frames++;
    {
        GLint t = SDL_GetTicks();
        if (t - oldTicks >= 1000) {
            seconds = (t - oldTicks) / 1000.0;
            fps = frames / seconds;
            oldTicks = t;
            frames = 0;
            //fprintf(stderr, "fps: %f rotx: %f\n", fps, rotx);
        }
        sprintf(buf, "FPS: %.1f", fps);
        glTranslatef(SCREEN_WIDTH / 2 - 85, -SCREEN_HEIGHT / 2 - 10, 0);
        drawString(buf, 1.0, 1.0, 1.0);
    }

    SDL_GLES_SwapBuffers();
}
