/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Cons;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.LazySeq;
import clojure.lang.RT;
import clojure.lang.Seqable;
import clojure.lang.Sequential;
import clojure.lang.Streamable;

public final class Stream
implements Seqable,
Streamable,
Sequential {
    static final ISeq NO_SEQ = new Cons(null, null);
    ISeq sequence = NO_SEQ;
    final IFn src;
    final IFn xform;
    IFn tap = null;

    public Stream(IFn src) {
        this.src = src;
        this.xform = null;
    }

    public Stream(IFn xform, Stream src) {
        this.src = src.tap();
        this.xform = xform;
    }

    public final ISeq seq() {
        return this.sequence().seq();
    }

    public final synchronized ISeq sequence() {
        if (this.sequence == NO_SEQ) {
            this.tap();
            this.sequence = Stream.makeSequence(this.tap);
        }
        return this.sequence;
    }

    static ISeq makeSequence(final IFn tap2) {
        return new LazySeq(new AFn(){

            public Object invoke() throws Exception {
                Object v = tap2.invoke();
                if (v == RT.EOS) {
                    return null;
                }
                return new Cons(v, new LazySeq(this));
            }
        });
    }

    public final synchronized Stream stream() throws Exception {
        return this;
    }

    public final synchronized IFn tap() {
        if (this.tap != null) {
            throw new IllegalStateException("Stream already tapped");
        }
        this.tap = Stream.makeTap(this.xform, this.src);
        return this.tap;
    }

    static IFn makeTap(final IFn xform, final IFn src) {
        return new AFn(){

            public final synchronized Object invoke() throws Exception {
                Object v;
                Object xv;
                if (xform == null) {
                    return src.invoke();
                }
                do {
                    if ((v = src.invoke()) != RT.EOS) continue;
                    return v;
                } while ((xv = xform.invoke(v)) == RT.SKIP);
                return xv;
            }
        };
    }
}

